/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Label;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class WorkBenchFormService {
    public static void setPieChart(PieChart pieChart, String pieSeriesName, ItemValue[] itemValues) {
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(pieSeriesName);
        series.setData(itemValues);
        int sum = 0;
        for (ItemValue itemValue : itemValues) {
            sum += itemValue.getValue().intValue();
        }
        pieChart.setName(new LocaleString(String.valueOf(sum)));
        series.setRadius("40%", "60%");
        pieChart.setTitlePropValue("x", (Object)(92 - String.valueOf(sum).length() * 3));
        pieChart.setTitlePropValue("y", (Object)86);
        int[] points = new int[]{100, 100};
        series.setPropValue("center", (Object)points);
        HashMap map = new HashMap(16);
        HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>(16);
        normalMap.put("show", Boolean.FALSE);
        map.put("normal", normalMap);
        series.setPropValue("label", map);
        series.setPropValue("labelLine", map);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.setShowTooltip(true);
        pieChart.refresh();
    }

    public static ItemValue[] getFaBillItemValue(Map<String, List<DynamicObject>> fABillMap) {
        ItemValue[] itemValues = new ItemValue[3];
        ItemValue prItemValue = new ItemValue(ResManager.loadKDString((String)"\u56e0\u79c1\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7", (String)"FAMaterialTplListPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), (Number)fABillMap.get("B").size(), "#40A9FF");
        ItemValue onBusItemValue = new ItemValue(ResManager.loadKDString((String)"\u56e0\u516c\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7", (String)"FAMaterialTplListPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), (Number)fABillMap.get("C").size(), "#45DAD1");
        ItemValue notItemValue = new ItemValue(ResManager.loadKDString((String)"\u4e0d\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7", (String)"FAMaterialTplListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), (Number)fABillMap.get("A").size(), "#73D13D");
        itemValues[0] = prItemValue;
        itemValues[1] = onBusItemValue;
        itemValues[2] = notItemValue;
        return itemValues;
    }

    public static void detailValueAssignment(Map<String, List<DynamicObject>> fABillMap, IFormView view) {
        int sum = 0;
        Collection<List<DynamicObject>> faBillValues = fABillMap.values();
        for (List<DynamicObject> faBillValue : faBillValues) {
            sum += faBillValue.size();
        }
        if (sum != 0) {
            BigDecimal bigDecimalSum = new BigDecimal(sum);
            BigDecimal prBigDecimal = new BigDecimal(fABillMap.get("B").size() * 100);
            BigDecimal prPercentageBigDecimal = prBigDecimal.divide(bigDecimalSum, 2, 4);
            Label prPercentage = (Label)view.getControl("prpercentage");
            prPercentage.setText("0.00".equals(String.valueOf(prPercentageBigDecimal)) ? "-" : prPercentageBigDecimal + "%");
            BigDecimal onBusBigDecimal = new BigDecimal(fABillMap.get("C").size() * 100);
            BigDecimal onBusPercentageBigDecimal = onBusBigDecimal.divide(bigDecimalSum, 2, 4);
            Label onBusPercentage = (Label)view.getControl("onbuspercentage");
            onBusPercentage.setText("0.00".equals(String.valueOf(onBusPercentageBigDecimal)) ? "-" : onBusPercentageBigDecimal + "%");
            BigDecimal notBigDecimal = new BigDecimal(fABillMap.get("A").size() * 100);
            BigDecimal notPercentageBigDecimal = notBigDecimal.divide(bigDecimalSum, 2, 4);
            Label notPercentage = (Label)view.getControl("notpercentage");
            notPercentage.setText("0.00".equals(String.valueOf(notPercentageBigDecimal)) ? "-" : notPercentageBigDecimal + "%");
            BigDecimal sumPercentageBigDecimal = prPercentageBigDecimal.add(onBusPercentageBigDecimal).add(notPercentageBigDecimal);
            if (sumPercentageBigDecimal.compareTo(new BigDecimal(100)) != 0 && prPercentageBigDecimal.compareTo(new BigDecimal(0)) != 0) {
                BigDecimal residueBigDecimal = new BigDecimal(100).subtract(sumPercentageBigDecimal);
                prPercentage.setText(prPercentageBigDecimal.add(residueBigDecimal) + "%");
            }
        } else {
            Label prPercentage = (Label)view.getControl("prpercentage");
            prPercentage.setText("-");
            Label onBusPercentage = (Label)view.getControl("onbuspercentage");
            onBusPercentage.setText("-");
            Label notPercentage = (Label)view.getControl("notpercentage");
            notPercentage.setText("-");
        }
        Label prNumber = (Label)view.getControl("prnumber");
        prNumber.setText(fABillMap.get("B").size() + "");
        Label onBusNumber = (Label)view.getControl("onbusnumber");
        onBusNumber.setText(fABillMap.get("C").size() + "");
        Label notNumber = (Label)view.getControl("notnumber");
        notNumber.setText(fABillMap.get("A").size() + "");
    }

    public static ItemValue[] getInCerTypeItemValue(Map<String, List<DynamicObject>> inCerTypeMap) {
        ItemValue[] itemValues = new ItemValue[2];
        ItemValue onBusItemValue = new ItemValue(ResManager.loadKDString((String)"\u56e0\u516c\u8bc1\u7167", (String)"FAMaterialTplListPlugin_5", (String)"sihc-soefam-business", (Object[])new Object[0]), (Number)inCerTypeMap.get("0").size(), "#45DAD1");
        ItemValue prItemValue = new ItemValue(ResManager.loadKDString((String)"\u56e0\u79c1\u8bc1\u7167", (String)"FAMaterialTplListPlugin_6", (String)"sihc-soefam-business", (Object[])new Object[0]), (Number)inCerTypeMap.get("1").size(), "#40A9FF");
        itemValues[0] = onBusItemValue;
        itemValues[1] = prItemValue;
        return itemValues;
    }

    public static void inCerTypeValueDetail(Map<String, List<DynamicObject>> inCerMap, IFormView view) {
        int sum = 0;
        Collection<List<DynamicObject>> faBillValues = inCerMap.values();
        for (List<DynamicObject> faBillValue : faBillValues) {
            sum += faBillValue.size();
        }
        if (sum != 0) {
            BigDecimal bigDecimalSum = new BigDecimal(sum);
            BigDecimal prBigDecimal = new BigDecimal(inCerMap.get("1").size() * 100);
            BigDecimal prPercentageBigDecimal = prBigDecimal.divide(bigDecimalSum, 2, 4);
            Label prPercentage = (Label)view.getControl("prpercentage");
            prPercentage.setText("0.00".equals(String.valueOf(prPercentageBigDecimal)) ? "-" : prPercentageBigDecimal + "%");
            BigDecimal onBusBigDecimal = new BigDecimal(inCerMap.get("0").size() * 100);
            BigDecimal onBusPercentageBigDecimal = onBusBigDecimal.divide(bigDecimalSum, 2, 4);
            Label onBusPercentage = (Label)view.getControl("onbuspercentage");
            onBusPercentage.setText("0.00".equals(String.valueOf(onBusPercentageBigDecimal)) ? "-" : onBusPercentageBigDecimal + "%");
        } else {
            Label prPercentage = (Label)view.getControl("prpercentage");
            prPercentage.setText("-");
            Label onBusPercentage = (Label)view.getControl("onbuspercentage");
            onBusPercentage.setText("-");
        }
        Label prNumber = (Label)view.getControl("prnumber");
        prNumber.setText(inCerMap.get("1").size() + "");
        Label onBusNumber = (Label)view.getControl("onbusnumber");
        onBusNumber.setText(inCerMap.get("0").size() + "");
    }

    public static void colorDetail(List<Integer> list, IFormView view) {
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            if (list.get(i) == 0) {
                map.put("fc", "#bbbbbb");
            } else {
                map.put("fc", "#7F93BC");
            }
            view.updateControlMetadata("label_num" + i, map);
        }
    }

    public static void getNumByFilingStatusCount(int i, int count, List<Integer> list, String pageNum, IFormView view) {
        Label label = (Label)view.getControl("label_num" + i);
        int length = count;
        boolean hasPerm = PermissionUtils.checkPermission((String)pageNum, (String)"47150e89000000ac");
        if (hasPerm) {
            label.setText((long)length >= 999L ? "999+" : String.valueOf(length));
            view.getPageCache().put("label_num" + i, String.valueOf(length));
            list.add(length);
        } else {
            label.setText(String.valueOf(0));
            view.getPageCache().put("label_num" + i, String.valueOf(0));
            list.add(0);
        }
    }

    public static void isRefresh(String key, IFormView view) {
        if ("refreshap".equals(key)) {
            view.invokeOperation("refresh");
        }
    }
}

