/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice.faapplication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.queryservice.NotGACApplyDomainService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.enums.ForAffProcessStatusEnum;

public class FAApplicationOpService {
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE = ServiceFactory.getService(CertificateApplicationService.class);
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = ServiceFactory.getService(FaApplyQueryService.class);

    public static void saveBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            String processStatus = dataEntity.getString("processstatus");
            if (ForAffProcessStatusEnum.STATUS_INPRO.getKey().equals(processStatus)) continue;
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_WAITSUB.getKey());
        }
        DynamicObject filPerManage = dataEntities[0].getDynamicObject("filpermanage");
        if (filPerManage != null) {
            DynamicObjectCollection concertTypes = dataEntities[0].getDynamicObjectCollection("concerttype");
            List<DynamicObject> concertTypeList = concertTypes.stream().map(concertType -> concertType.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            CERTIFICATE_APPLICATION_SERVICE.generateToLentOutReg(dataEntities[0], concertTypeList.toArray(new DynamicObject[0]), new DynamicObject[]{filPerManage});
        }
    }

    public static void submitSetEntity(BeginOperationTransactionArgs args) {
        DynamicObject faBillByDynObj;
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities.length > 0 && (faBillByDynObj = FA_APPLY_QUERY_SERVICE.getFaBillById(dataEntities[0].getLong("id"))) != null) {
            DynamicObjectCollection visAprDynObjColl = dataEntities[0].getDynamicObjectCollection("visaprocessentity");
            DynamicObjectCollection faBillByDynObjColl = faBillByDynObj.getDynamicObjectCollection("visaprocessentity");
            if (faBillByDynObjColl.size() != 0 && visAprDynObjColl.size() != faBillByDynObjColl.size()) {
                visAprDynObjColl.clear();
                visAprDynObjColl.addAll((Collection)faBillByDynObj.getDynamicObjectCollection("visaprocessentity"));
            }
        }
    }

    public static void submitBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> companyIdList = new ArrayList<Long>(10);
        ArrayList<Long> adminOrgIdList = new ArrayList<Long>(10);
        ArrayList<Long> positionIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject position;
            DynamicObject adminOrg;
            DynamicObject company = dynamicObject.getDynamicObject("company");
            if (company != null) {
                companyIdList.add(company.getLong("id"));
            }
            if ((adminOrg = dynamicObject.getDynamicObject("adminorg")) != null) {
                adminOrgIdList.add(adminOrg.getLong("id"));
            }
            if ((position = dynamicObject.getDynamicObject("position")) == null) continue;
            positionIdList.add(position.getLong("id"));
        }
        Map<String, Map<String, Object>> companyInfo = HrmpExternalService.adminOrgInfoQuery(companyIdList, new Date());
        Map<String, Map<String, Object>> adminOrgInfo = HrmpExternalService.adminOrgInfoQuery(adminOrgIdList, new Date());
        Map<String, Object> positionInfo = HrmpExternalService.queryPositionHis(positionIdList, new Date());
        for (DynamicObject dataEntity : dataEntities) {
            List hisDataList;
            Map dataMap;
            DynamicObject position;
            Map<String, Object> idMap;
            DynamicObject adminOrg;
            Map<String, Object> idMap2;
            DynamicObject company = dataEntity.getDynamicObject("company");
            if (company != null && (idMap2 = companyInfo.get(company.getString("id"))) != null) {
                Long vid = (Long)idMap2.get("vid");
                dataEntity.set("company", (Object)vid);
            }
            if ((adminOrg = dataEntity.getDynamicObject("adminorg")) != null && (idMap = adminOrgInfo.get(adminOrg.getString("id"))) != null) {
                Long vid = (Long)idMap.get("vid");
                dataEntity.set("adminorg", (Object)vid);
            }
            if ((position = dataEntity.getDynamicObject("position")) != null && (dataMap = (Map)positionInfo.get("data")) != null && (hisDataList = (List)dataMap.get("hisdata")) != null) {
                for (Map hisData : hisDataList) {
                    Long boId = (Long)hisData.get("boid");
                    if (position.getLong("id") != boId.longValue()) continue;
                    Long id = (Long)hisData.get("id");
                    dataEntity.set("position", (Object)id);
                }
            }
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_INPRO.getKey());
            dataEntity.set("submittime", (Object)new Date());
        }
        DynamicObject dynamicObject = dataEntities[0].getDynamicObject("filpermanage");
        if (dynamicObject != null) {
            DynamicObjectCollection concertTypes = dataEntities[0].getDynamicObjectCollection("concerttype");
            List<DynamicObject> concertTypeList = concertTypes.stream().map(concertType -> concertType.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            CERTIFICATE_APPLICATION_SERVICE.generateToLentOutReg(dataEntities[0], concertTypeList.toArray(new DynamicObject[0]), new DynamicObject[]{dynamicObject});
        }
    }

    public static void unSubmitBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            DynamicObject position;
            DynamicObject adminOrg;
            DynamicObject company = dataEntity.getDynamicObject("company");
            if (company != null) {
                dataEntity.set("company", (Object)company.getLong("boid"));
            }
            if ((adminOrg = dataEntity.getDynamicObject("adminorg")) != null) {
                dataEntity.set("adminorg", (Object)adminOrg.getLong("boid"));
            }
            if ((position = dataEntity.getDynamicObject("position")) != null) {
                dataEntity.set("position", (Object)position.getLong("boid"));
            }
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_WAITSUB.getKey());
        }
    }

    public static void auditBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_COMP.getKey());
            DynamicObjectCollection visPersonEntity = dataEntity.getDynamicObjectCollection("vispersonentity");
            ((DynamicObject)visPersonEntity.get(0)).set("affcompany", dataEntity.get("company") instanceof DynamicObject ? dataEntity.getDynamicObject("company") : Long.valueOf(dataEntity.getLong("company")));
            ((DynamicObject)visPersonEntity.get(0)).set("inorg", dataEntity.get("adminorg") instanceof DynamicObject ? dataEntity.getDynamicObject("adminorg") : Long.valueOf(dataEntity.getLong("adminorg")));
            ((DynamicObject)visPersonEntity.get(0)).set("inposition", dataEntity.get("position") instanceof DynamicObject ? dataEntity.getDynamicObject("position") : Long.valueOf(dataEntity.getLong("position")));
        }
        for (DynamicObject dataEntity : dataEntities) {
            CERTIFICATE_APPLICATION_SERVICE.initCertificateManageStatus("fa_apply", dataEntity);
        }
    }

    public static void saveOnBusBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            String processStatus = dataEntity.getString("processstatus");
            if (ForAffProcessStatusEnum.STATUS_INPRO.getKey().equals(processStatus)) continue;
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_WAITSUB.getKey());
        }
        FAApplicationOpService.saveToLentOutReg(dataEntities);
    }

    public static void submitOnBusBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_INPRO.getKey());
            dataEntity.set("submittime", (Object)new Date());
        }
        for (DynamicObject dataEnt : dataEntities) {
            DynamicObjectCollection dynObjColl = dataEnt.getDynamicObjectCollection("vispersonentity");
            for (DynamicObject dynObj : dynObjColl) {
                FAApplicationOpService.setFieldVidValue("affcompany", dynObj);
                FAApplicationOpService.setFieldVidValue("inorg", dynObj);
                FAApplicationOpService.setFieldVidValue("inposition", dynObj);
            }
        }
        FAApplicationOpService.saveToLentOutReg(dataEntities);
    }

    public static void unSubmitOnBusBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            DynamicObjectCollection dynObjCollEntity = dataEntity.getDynamicObjectCollection("vispersonentity");
            for (DynamicObject dynEntity : dynObjCollEntity) {
                DynamicObject position;
                DynamicObject adminOrg;
                DynamicObject company = dynEntity.getDynamicObject("affcompany");
                if (company != null) {
                    dynEntity.set("affcompany", (Object)company.getLong("boid"));
                }
                if ((adminOrg = dynEntity.getDynamicObject("inorg")) != null) {
                    dynEntity.set("inorg", (Object)adminOrg.getLong("boid"));
                }
                if ((position = dynEntity.getDynamicObject("inposition")) == null) continue;
                dynEntity.set("inposition", (Object)position.getLong("boid"));
            }
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_WAITSUB.getKey());
        }
    }

    public static void auditOnBusBeginOpHandle(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_COMP.getKey());
        }
        for (DynamicObject dataEntity : dataEntities) {
            CERTIFICATE_APPLICATION_SERVICE.initCertificateManageStatus("fa_apply", dataEntity);
        }
    }

    public static void terProcessBeginOpHandle(BeginOperationTransactionArgs args, OperateOption option) {
        DynamicObject[] dataEntities;
        String terDataEntityStr = option.getVariableValue("terDataEntity");
        DynamicObject terDataEntity = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)terDataEntityStr);
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("terapplyreason", (Object)terDataEntity.getLong("terapplyreason.id"));
            dataEntity.set("terinstruction", (Object)terDataEntity.getString("terinstruction"));
            dataEntity.set("operator", (Object)UserServiceHelper.getCurrentUserId());
            dataEntity.set("operationdate", (Object)new Date());
            dataEntity.set("processstatus", (Object)ForAffProcessStatusEnum.STATUS_TERM.getKey());
            dataEntity.set("auditstatus", (Object)"F");
            dataEntity.set("billstatus", (Object)"F");
        }
        NotGACApplyDomainService.HRBASESERVICEHELPER.update(dataEntities);
        String billStatus = dataEntities[0].getString("billstatus");
        if ("C".equals(billStatus)) {
            CERTIFICATE_APPLICATION_SERVICE.initCertificateManageStatus("fa_over", dataEntities[0]);
        }
    }

    private static void saveToLentOutReg(DynamicObject[] dataEntities) {
        DynamicObjectCollection dynObjColl = dataEntities[0].getDynamicObjectCollection("vispersonentity");
        ArrayList<DynamicObject> dynObj = new ArrayList<DynamicObject>(dynObjColl.size());
        for (DynamicObject dyn : dynObjColl) {
            DynamicObject dynamicObject = dyn.getDynamicObject("visfilpermanage");
            if (dynamicObject == null) continue;
            dynObj.add(dynamicObject);
        }
        if (dynObj.size() > 0) {
            DynamicObjectCollection concertTypes = dataEntities[0].getDynamicObjectCollection("concerttype");
            List<DynamicObject> concertTypeList = concertTypes.stream().map(concertType -> concertType.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            CERTIFICATE_APPLICATION_SERVICE.generateToLentOutReg(dataEntities[0], concertTypeList.toArray(new DynamicObject[0]), dynObj.toArray(new DynamicObject[0]));
        }
    }

    private static void setFieldVidValue(String fieldNum, DynamicObject dynObj) {
        Long souId;
        DynamicObject dynamicObject = dynObj.getDynamicObject(fieldNum);
        if (dynamicObject != null && dynamicObject.get("sourcevid") != null && (souId = Long.valueOf(dynamicObject.getLong("sourcevid"))) != 0L) {
            dynObj.set(fieldNum, (Object)souId);
        }
    }
}

