/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice.faapplication;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sihc.soebs.common.constants.rpc.HRCSRpcConstants;
import kd.sihc.soefam.business.application.external.PrintTemplateExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.domain.famaterialtpl.FAMaterialTplDomainService;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.formservice.CodeRuleService;
import kd.sihc.soefam.business.formservice.OnBusAbroadFormService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.queryservice.NotGACApplyDomainService;
import kd.sihc.soefam.business.queryservice.PROutBApplyDomainService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;
import kd.sihc.soefam.common.enums.ForAffProcessStatusEnum;

public class FAApplicationService {
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = ServiceFactory.getService(FaApplyQueryService.class);
    public static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);
    private static final FilPersonMgDomainService FILPERSONMG_APPLICATION_SERVICE = FilPersonMgDomainService.init();
    private static final Map<String, String> CERT_LEND_OUT_MAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final Log LOGGER;

    public static BillShowParameter getBillShowParameter(Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billId);
        DynamicObject faBill = FA_APPLY_QUERY_SERVICE.getFaBillById(billId);
        String applyFormType = faBill.getString("applyformtype");
        if ("A".equals(applyFormType)) {
            showParameter.setFormId("soefam_notgacapply");
        } else if ("B".equals(applyFormType)) {
            showParameter.setFormId("soefam_proutbapply");
        } else if ("C".equals(applyFormType)) {
            showParameter.setFormId("soefam_onbusabroad");
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        return showParameter;
    }

    public static void personInfoAssignment(DynamicObject depemp, IFormView view) {
        DynamicObject person = depemp.getDynamicObject("person");
        view.getModel().setValue("person", (Object)person.getLong("id"));
        Map<String, Object> empposorgrel = HrmpExternalService.getEmpOrgrel(depemp.getLong("id"));
        Long personId = (Long)empposorgrel.get("person_id");
        DynamicObject filPerson = FILPERSONMG_APPLICATION_SERVICE.getFilPersonByPerson(personId);
        if (filPerson != null) {
            view.getModel().setValue("filpermanage", (Object)filPerson.getLong("id"));
            view.getModel().setValue("visfilpermanage", (Object)filPerson.getLong("id"), 0);
            view.getModel().setValue("recpersontype", (Object)filPerson.getLong("recpersontype.id"));
            view.getModel().setValue("visrecpersontype", (Object)filPerson.getLong("recpersontype.id"), 0);
        } else {
            view.getModel().setValue("filpermanage", null);
            view.getModel().setValue("visfilpermanage", null, 0);
            view.getModel().setValue("recpersontype", null);
            view.getModel().setValue("visrecpersontype", null, 0);
        }
        view.getModel().setValue("visperson", (Object)person.getLong("id"), 0);
        view.getModel().setValue("visdepemp", (Object)depemp.getLong("id"), 0);
        Long adminOrgId = (Long)empposorgrel.get("adminorg_id");
        view.getModel().setValue("adminorg", (Object)adminOrgId);
        view.getModel().setValue("admorg", (Object)adminOrgId);
        Long companyId = (Long)empposorgrel.get("company_id");
        view.getModel().setValue("company", (Object)companyId);
        Long positionId = (Long)empposorgrel.get("position_id");
        view.getModel().setValue("position", (Object)positionId);
    }

    public static void setContactInfo(IFormView view, DynamicObject person) {
        view.getModel().setValue("recipient", (Object)person.getString("name"));
        List<Map<String, Object>> contactInfoMap = FAApplicationService.getContactInfoMap(Collections.singletonList(person.getString("id")));
        if (contactInfoMap != null && contactInfoMap.size() != 0) {
            Map<String, Object> map = contactInfoMap.get(0);
            view.getModel().setValue("telephone", map.get("phone"));
        }
    }

    public static List<Map<String, Object>> getContactInfoMap(List<String> perIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"003"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", perIdList);
        Map<String, Map<String, Object>> employeeInfo = HrmpExternalService.queryEmployeeInfo(param);
        Map<Long, List<Map<String, Object>>> perContact = PrintTemplateExternalService.getTargetResult(employeeInfo, "hrpi_percontact");
        return perContact.get(Long.parseLong(perIdList.get(0)));
    }

    public static void personBaseInfoAssignment(IFormView view, DynamicObject person) {
        List<Map<String, Object>> personInfo;
        view.getModel().setValue("name", (Object)person.getString("name"));
        view.getModel().setValue("number", (Object)person.getString("number"));
        Map<String, Object> personBaseInfo = HrmpExternalService.getPersonBaseInfo(person.getLong("id"));
        if (personBaseInfo != null) {
            Long genderId = (Long)personBaseInfo.get("gender_id");
            view.getModel().setValue("gender", (Object)genderId);
            Object birthdayObject = personBaseInfo.get("birthday");
            if (birthdayObject != null) {
                Date birthday = DateUtils.parseDateTime((String)birthdayObject.toString(), (String)"yyyy-MM-dd");
                view.getModel().setValue("birthday", (Object)birthday);
            }
        }
        if ((personInfo = HrmpExternalService.listPersonAttachs(person.getLong("id"), "hrpi_perregion")).size() != 0) {
            Long politicalStatusId = (Long)personInfo.get(0).get("politicalstatus_id");
            view.getModel().setValue("politicalstatus", (Object)politicalStatusId);
            String nativePlace = (String)personInfo.get(0).get("nativeplace");
            view.getModel().setValue("nativeplace", (Object)nativePlace);
        }
    }

    public static void faMaterialAssignment(IFormView view, String assApply) {
        DynamicObjectCollection faMaterialEntity = view.getModel().getEntryEntity("famaterialentity");
        if (faMaterialEntity.size() > 0) {
            view.getModel().deleteEntryData("famaterialentity");
        }
        if (view.getModel().getValue("org") == null) {
            return;
        }
        List<DynamicObject> fAMaterialTpls = FAMaterialTplDomainService.getFAMaterialTplByOrgAndType(((DynamicObject)view.getModel().getValue("org")).getLong("id"), assApply);
        if (fAMaterialTpls.size() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{"famaterialentityflex"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"famaterialentityflex"});
            for (DynamicObject fAMaterialTpl : fAMaterialTpls) {
                int newEntryRow = view.getModel().createNewEntryRow("famaterialentity");
                view.getModel().setValue("famaterialtpl", (Object)fAMaterialTpl.getLong("id"), newEntryRow);
                List materialAttachments = AttachmentServiceHelper.getAttachments((String)"soefam_famaterialtpl", (Object)fAMaterialTpl.getLong("id"), (String)"materialattachment");
                if (materialAttachments.size() == 0) continue;
                Map materialAttachment = (Map)materialAttachments.get(0);
                String attachmentName = (String)materialAttachment.get("name");
                view.getModel().setValue("materialdownload", (Object)attachmentName, newEntryRow);
            }
        }
    }

    public static void faMaterialAssignmentMob(IFormView view, String assApply) {
        List mustUploadFAMaterialTpls;
        if (view.getModel().getValue("org") == null) {
            return;
        }
        List<DynamicObject> fAMaterialTpls = FAMaterialTplDomainService.getFAMaterialTplByOrgAndType(((DynamicObject)view.getModel().getValue("org")).getLong("id"), assApply);
        if (fAMaterialTpls.size() > 0) {
            for (DynamicObject fAMaterialTpl2 : fAMaterialTpls) {
                int newEntryRow = view.getModel().createNewEntryRow("famaterialentity");
                view.getModel().setValue("famaterialtpl", (Object)fAMaterialTpl2.getLong("id"), newEntryRow);
            }
        }
        if ((mustUploadFAMaterialTpls = fAMaterialTpls.stream().filter(fAMaterialTpl -> "1".equals(fAMaterialTpl.getString("ismustupload"))).collect(Collectors.toList())).size() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{"famaterialentityflex"});
        }
    }

    public static void faMaterialDownload(IFormView view) {
        DynamicObjectCollection faMaterialEntity = view.getModel().getEntryEntity("famaterialentity");
        if (faMaterialEntity.size() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{"famaterialentityflex"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"famaterialentityflex"});
            for (int index = 0; index < faMaterialEntity.size(); ++index) {
                List materialAttachments = AttachmentServiceHelper.getAttachments((String)"soefam_famaterialtpl", (Object)((DynamicObject)faMaterialEntity.get(index)).getLong("famaterialtpl.id"), (String)"materialattachment");
                if (materialAttachments.size() == 0) continue;
                Map materialAttachment = (Map)materialAttachments.get(0);
                String attachmentName = (String)materialAttachment.get("name");
                view.getModel().setValue("materialdownload", (Object)attachmentName, index);
            }
        }
    }

    public static void setTabVisible(IFormView view) {
        String bizKey;
        boolean isApprovalTabVisible = false;
        boolean isInsightTabVisible = false;
        String billStatus = (String)view.getModel().getValue("billstatus");
        Boolean isExistsWorkFlow = (Boolean)view.getModel().getValue("isexistsworkflow");
        if (isExistsWorkFlow.booleanValue()) {
            isApprovalTabVisible = true;
            view.setVisible(Boolean.FALSE, new String[]{"bar_submiteffect"});
        } else if ("A".equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_submiteffect"});
        }
        view.setVisible(isExistsWorkFlow, new String[]{"bar_viewflowchart"});
        Object filPerManage = view.getModel().getValue("filpermanage");
        if (filPerManage != null && "C".equals(billStatus)) {
            isInsightTabVisible = true;
            boolean isShowInsightTab = FAApplicationService.isShowInsightTab((Long)view.getModel().getValue("id"));
            if (!isShowInsightTab) {
                isInsightTabVisible = false;
            }
        }
        view.setVisible(Boolean.valueOf(isApprovalTabVisible), new String[]{"approvaltab"});
        view.setVisible(Boolean.valueOf(isInsightTabVisible), new String[]{"insighttab"});
        view.setVisible(Boolean.valueOf(isApprovalTabVisible || isInsightTabVisible), new String[]{"otherflex"});
        if (!isApprovalTabVisible && isInsightTabVisible) {
            Tab tab = (Tab)view.getControl("tabap");
            tab.activeTab("insighttab");
        }
        if ((bizKey = (String)view.getFormShowParameter().getCustomParam("businessKey")) != null) {
            view.setVisible(Boolean.FALSE, new String[]{"otherflex", "viewinstruction"});
        }
    }

    public static boolean isShowInsightTab(Long billId) {
        ArrayList<String> manageStatusList = new ArrayList<String>(10);
        manageStatusList.add(CertStockStatusEnum.STATUS_IN.getKey());
        manageStatusList.add(CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
        manageStatusList.add(CertManageStatusEnum.STATUS_TORETURN.getKey());
        DynamicObject[] certLentOutRegs = CERTIFICATE_QUERY_SERVICE.queryLentOutRegByFaIds(billId);
        List certLentOutRegList = Arrays.stream(certLentOutRegs).filter(certLentOutReg -> !"0".equals(certLentOutReg.getString("registerstate")) || manageStatusList.contains(certLentOutReg.getString("certificate.managestatus"))).collect(Collectors.toList());
        DynamicObject[] certReturnRegs = CERTIFICATE_QUERY_SERVICE.queryReturnRegByFaIds(billId);
        List certReturnRegList = Arrays.stream(certReturnRegs).filter(certReturnReg -> !certReturnReg.getString("registerstate").equals("2")).filter(certLentOutReg -> !"0".equals(certLentOutReg.getString("registerstate")) || manageStatusList.contains(certLentOutReg.getString("certificate.managestatus"))).collect(Collectors.toList());
        return certLentOutRegList.size() != 0 || certReturnRegList.size() != 0;
    }

    public static void setOnBusTabVisible(IFormView view) {
        String bizKey;
        Object billId;
        boolean isApprovalTabVisible = false;
        boolean isInsightTabVisible = false;
        String billStatus = (String)view.getModel().getValue("billstatus");
        Boolean isExistsWorkFlow = (Boolean)view.getModel().getValue("isexistsworkflow");
        if (isExistsWorkFlow.booleanValue()) {
            isApprovalTabVisible = true;
            view.setVisible(Boolean.FALSE, new String[]{"bar_submiteffect"});
        } else if ("A".equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_submiteffect"});
        }
        view.setVisible(isExistsWorkFlow, new String[]{"bar_viewflowchart"});
        DynamicObjectCollection dyObjColl = view.getModel().getDataEntity().getDynamicObjectCollection("vispersonentity");
        boolean flag = false;
        for (DynamicObject dynObj : dyObjColl) {
            if (dynObj.getDynamicObject("visfilpermanage") == null) continue;
            flag = true;
        }
        if (flag && "C".equals(billStatus)) {
            isInsightTabVisible = true;
            billId = view.getModel().getDataEntity().get("id");
            boolean showSightTab = FAApplicationService.isShowSightTab(Long.parseLong(billId.toString()));
            if (!showSightTab) {
                isInsightTabVisible = false;
            }
        }
        view.setVisible(Boolean.valueOf(isApprovalTabVisible), new String[]{"approvaltab"});
        view.setVisible(Boolean.valueOf(isInsightTabVisible), new String[]{"insighttab"});
        view.setVisible(Boolean.valueOf(isApprovalTabVisible || isInsightTabVisible), new String[]{"otherflex"});
        if (isInsightTabVisible) {
            billId = view.getModel().getDataEntity().get("id");
            OnBusAbroadFormService onBusAbroadFormService = new OnBusAbroadFormService();
            FormShowParameter formShowParameter = onBusAbroadFormService.buildOnBusLayout("insighttab", Long.parseLong(billId.toString()));
            view.showForm(formShowParameter);
        }
        if ((bizKey = (String)view.getFormShowParameter().getCustomParam("businessKey")) != null) {
            view.setVisible(Boolean.FALSE, new String[]{"otherflex", "viewinstruction"});
        }
    }

    public static boolean isShowSightTab(Long billId) {
        DynamicObject[] returnRegList;
        DynamicObject[] lendOutObjList;
        boolean isShowSightTab = false;
        for (DynamicObject certLendOutReg : lendOutObjList = CERTIFICATE_QUERY_SERVICE.queryLentOutRegByFaIds(billId)) {
            String registerState = certLendOutReg.getString("registerstate");
            if ("0".equals(registerState) && !CERT_LEND_OUT_MAP.containsKey(certLendOutReg.getString("certificate.managestatus"))) continue;
            isShowSightTab = true;
        }
        for (DynamicObject certReturnReg : returnRegList = CERTIFICATE_QUERY_SERVICE.queryReturnRegByFaIds(billId)) {
            String registerState = certReturnReg.getString("registerstate");
            if (!"0".equals(registerState) && !"1".equals(registerState)) continue;
            isShowSightTab = true;
        }
        return isShowSightTab;
    }

    public static void downFAMaterial(CellClickEvent cellClickEvent, IFormView view) {
        String fieldKey = cellClickEvent.getFieldKey();
        int entryCurrentRowIndex = view.getModel().getEntryCurrentRowIndex("famaterialentity");
        DynamicObject materialDy = view.getModel().getEntryRowEntity("famaterialentity", entryCurrentRowIndex);
        if ("materialdownload".equals(fieldKey)) {
            if ("".equals(view.getModel().getValue("materialdownload", entryCurrentRowIndex))) {
                return;
            }
            List materialAttachments = AttachmentServiceHelper.getAttachments((String)"soefam_famaterialtpl", (Object)materialDy.getLong("famaterialtpl.id"), (String)"materialattachment");
            if (materialAttachments.size() != 0) {
                String url = ((Map)materialAttachments.get(0)).get("url").toString();
                view.download(url);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FAMaterialTplListPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static void afterDoOperationFormHandle(AfterDoOperationEventArgs afterDoOperationEventArgs, IFormView view, AbstractFormPlugin plugin) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            view.invokeOperation("refresh");
        }
        if (operationResult != null) {
            if (operationResult.isSuccess() && "donothing_termination".equals(operateKey)) {
                String processStatus = view.getModel().getDataEntity().getString("processstatus");
                if (processStatus == null || ForAffProcessStatusEnum.STATUS_COMP.getKey().equals(processStatus) || ForAffProcessStatusEnum.STATUS_TERM.getKey().equals(processStatus)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u7ec8\u6b62\u6d41\u7a0b\u72b6\u6001=\u5f85\u63d0\u4ea4\u7533\u8bf7/\u7533\u8bf7\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u3002", (String)"NotGACApplyListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                } else {
                    FAApplicationService.showTerFAProcessPage(view, plugin);
                }
            } else if (operationResult.isSuccess() && "donothing_viewflowchart".equals(operateKey)) {
                WorkflowServiceHelper.viewFlowchart((String)view.getPageId(), (Object)view.getModel().getValue("id"));
            } else if (operationResult.isSuccess() && ("save".equals(operateKey) || "submit".equals(operateKey))) {
                FAApplicationService.synAttachment(view);
            }
        }
    }

    public static void synAttachment(IFormView view) {
        String currentEntityId = view.getEntityId();
        Object billId = view.getModel().getValue("id");
        List currentAttachment = AttachmentServiceHelper.getAttachments((String)currentEntityId, (Object)billId, (String)"attachmentpanel");
        try {
            FAApplicationService.modifyAttachment(currentAttachment);
        }
        catch (Exception ex) {
            LOGGER.info("FAApplicationService.afterDoOperationFormHandle.ex:{}", (Object)ex);
        }
        if (currentEntityId.contains("_self")) {
            AttachmentServiceHelper.upload((String)currentEntityId.replaceAll("_self", ""), (Object)billId, (String)"attachmentpanel", (List)currentAttachment);
        } else {
            AttachmentServiceHelper.upload((String)(currentEntityId + "_self"), (Object)billId, (String)"attachmentpanel", (List)currentAttachment);
        }
    }

    public static void showTerFAProcessPage(IFormView view, AbstractFormPlugin plugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("soefam_terfaprocess");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "terProcess"));
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
        view.showForm(formShowParameter);
    }

    public static void modifyAttachment(List<Map<String, Object>> currentAttachment) throws IOException {
        for (Map<String, Object> attachment : currentAttachment) {
            attachment.put("lastModified", null);
            attachment.put("url", FAApplicationService.getPathfromDownloadUrl(URLDecoder.decode(String.valueOf(attachment.get("url")), "UTF-8")));
            String uid = attachment.get("uid").toString();
            if (uid.contains("-other")) {
                attachment.put("uid", uid.replaceAll("-other", ""));
                continue;
            }
            attachment.put("uid", uid + "-other");
        }
    }

    public static void tabSelectedHandle(TabSelectEvent tabSelectEvent, IFormView view) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("insighttab".equals(tabKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("soefam_handleinsight");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("insighttab");
            showParameter.setCustomParam("id", view.getModel().getValue("id"));
            view.showForm(showParameter);
        } else if ("approvaltab".equals(tabKey)) {
            view.updateView("approvaltab");
        }
    }

    public static void setEntryNotChanged(DynamicObject dataEntity, String entryName) {
        DynamicObjectCollection empPosEntry = dataEntity.getDynamicObjectCollection(entryName);
        for (DynamicObject entry : empPosEntry) {
            DataEntityState dataEntityStateIntvCanDate = entry.getDataEntityState();
            DataEntityPropertyCollection propertiesIntvCanDate = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : propertiesIntvCanDate) {
                if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
                dataEntityStateIntvCanDate.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
        }
    }

    public static void selfBeforeBindDataHandle(IFormView view, String metaNumber) {
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Map<String, Object> personModel = HrmpExternalService.getPersonModelId();
            boolean isSuccess = (Boolean)personModel.get("success");
            if (isSuccess) {
                Map data = (Map)personModel.get("data");
                Long personId = (Long)data.get("person");
                Map<String, Object> primaryEmpposorgrel = HrmpExternalService.getPrimaryEmpposorgrel(personId);
                HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(16);
                paramMap.put((Long)primaryEmpposorgrel.get("adminorg_id"), Collections.singleton(HRCSRpcConstants.BIZ_TYPE));
                List<Map<String, Long>> resultList = HrmpExternalService.getHrBuByBusinessType(paramMap, HRCSRpcConstants.BIZ_OBJ_TYPE);
                for (Map<String, Long> result : resultList) {
                    Long hrBuId = result.get("hrBuId");
                    view.getModel().setValue("org", (Object)hrBuId);
                }
                view.getModel().setValue("depemp", primaryEmpposorgrel.get("depemp_id"));
            }
            String codeRuleStr = CodeRuleService.generateNumber(metaNumber);
            view.getModel().setValue("billno", (Object)codeRuleStr);
        }
    }

    public static void prSelfBeforeDoOperationFormHandle(BeforeDoOperationEventArgs args, IFormView view) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject prOutBApplyBill = PROutBApplyDomainService.getPROutboundApplyBillByBillNo((String)view.getModel().getValue("billno"));
            Long billId = (Long)view.getModel().getValue("id");
            if (prOutBApplyBill != null && billId.longValue() != prOutBApplyBill.getLong("id")) {
                String codeRuleStr = CodeRuleService.generateNumber("soefam_proutbapply");
                view.getModel().setValue("billno", (Object)codeRuleStr);
            }
        }
    }

    public static void notGacSelfBeforeDoOperationFormHandle(BeforeDoOperationEventArgs args, IFormView view) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject notGACApplyBill = NotGACApplyDomainService.getNotGACApplyBillByBillNo((String)view.getModel().getValue("billno"));
            Long billId = (Long)view.getModel().getValue("id");
            if (notGACApplyBill != null && billId.longValue() != notGACApplyBill.getLong("id")) {
                String codeRuleStr = CodeRuleService.generateNumber("soefam_notgacapply");
                view.getModel().setValue("billno", (Object)codeRuleStr);
            }
        }
    }

    public static void selfSetFilterHandle(SetFilterEvent evt) {
        Map<String, Object> personModel = HrmpExternalService.getPersonModelId();
        boolean isSuccess = (Boolean)personModel.get("success");
        if (!isSuccess) {
            evt.addCustomQFilter(new QFilter("id", "=", null));
        } else {
            Map data = (Map)personModel.get("data");
            Long personId = (Long)data.get("person");
            evt.addCustomQFilter(new QFilter("vispersonentity.visperson", "=", (Object)personId));
        }
    }

    public static void clickHandle(EventObject evt, IFormView view) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("viewinstruction".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("soefam_instruction");
            formShowParameter.setCustomParam("applyformtype", view.getModel().getValue("applyformtype"));
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
            view.showForm(formShowParameter);
        }
    }

    public static void afterRemoveHandle(UploadEvent evt, IFormView view) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String uid = ((HashMap)urls[0]).get("uid").toString();
            uid = uid.contains("-other") ? uid.replaceAll("-other", "") : uid + "-other";
            String currentEntityId = view.getEntityId();
            Object billId = view.getModel().getValue("id");
            if (currentEntityId.contains("_self")) {
                AttachmentServiceHelper.remove((String)currentEntityId.replaceAll("_self", ""), (Object)billId, (Object)uid);
            } else {
                AttachmentServiceHelper.remove((String)(currentEntityId + "_self"), (Object)billId, (Object)uid);
            }
        }
    }

    public static String getPathfromDownloadUrl(String url) throws IOException {
        String path = StringUtils.substringAfter((String)url, (String)"path=");
        path = URLDecoder.decode(path, "UTF-8");
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }

    public static void isCanBeViewed(HyperLinkClickArgs args, ListView view) {
        DynamicObject faBill = FA_APPLY_QUERY_SERVICE.getFaBillById((Long)view.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        if (faBill != null) {
            long creatorId = faBill.getLong("creator.id");
            String auditStatus = faBill.getString("auditstatus");
            if ("A".equals(auditStatus) && creatorId != UserServiceHelper.getCurrentUserId()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u67e5\u770b\u672c\u4eba\u521b\u5efa\u7684\u6682\u5b58\u5355\u636e\u3002", (String)"FAApplicationService_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public static void clearFieldValue(IFormView view, String applyFormType) {
        if ("A".equals(applyFormType)) {
            view.getModel().setValue("businesstype", (Object)Character.valueOf('0'));
            view.getModel().setValue("idno", null);
            view.getModel().setValue("planlenddate", null);
            view.getModel().setValue("planreturndate", null);
        } else if ("B".equals(applyFormType)) {
            view.getModel().setValue("roadcountry", null);
            view.getModel().setValue("abroadphone", null);
            view.getModel().setValue("planleavedate", null);
            view.getModel().setValue("planbackdate", null);
            view.getModel().setValue("gotocountry", null);
        }
        view.getModel().setValue("abrreasonprivate", null);
        view.getModel().setValue("concerttype", null);
        view.getModel().setValue("certrecmethod", (Object)"0");
        view.getModel().setValue("country", null);
        view.getModel().setValue("mailaddress", null);
        view.getModel().setValue("telephone", null);
        view.getModel().setValue("applyreason", null);
        view.getModel().setValue("recipient", null);
        AttachmentPanel attachmentpanel = (AttachmentPanel)view.getControl("attachmentpanel");
        List attachmentData = attachmentpanel.getAttachmentData();
        for (Map attachmentDatum : attachmentData) {
            attachmentpanel.remove(attachmentDatum);
        }
    }

    public static void showMobPersonInfoPage(IFormView view) {
        DynamicObject faBill = FA_APPLY_QUERY_SERVICE.getFaBillById((Long)view.getModel().getValue("id"));
        if (faBill == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FAApplicationService_1", (String)"sihc-soefam-business", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("soefam_personinfo_m");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", view.getModel().getValue("id"));
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("position", "center");
        showParameter.getOpenStyle().setCustParam(map);
        view.showForm((FormShowParameter)showParameter);
    }

    static {
        CERT_LEND_OUT_MAP.put(CertManageStatusEnum.STATUS_TOLENTOUT.getKey(), CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
        CERT_LEND_OUT_MAP.put(CertManageStatusEnum.STATUS_TORETURN.getKey(), CertManageStatusEnum.STATUS_TORETURN.getKey());
        LOGGER = LogFactory.getLog(FAApplicationService.class);
    }
}

