/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.formservice.print;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.DateField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class PrintPageDataService {
    private static final Log LOG = LogFactory.getLog(PrintPageDataService.class);

    public DataRowSet getDataRowSet(Long applyId) {
        DataRowSet dataRowSet = new DataRowSet();
        this.setPerAuditInfo(applyId, dataRowSet);
        return dataRowSet;
    }

    public void setPerAuditInfo(Long applyId, DataRowSet dataRowSet) {
        List<String> bizKey = Arrays.asList("a1", "a2", "a3");
        List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)applyId.toString());
        for (IApprovalRecordGroup approvalRecord : allApprovalRecord) {
            List children = approvalRecord.getChildren();
            for (IApprovalRecordItem item : children) {
                String lastChar;
                String bizIdentifyKey = item.getBizIdentifyKey();
                if (StringUtils.isEmpty((String)bizIdentifyKey)) continue;
                LOG.info("PrintPageData.PerAuditInfo.HandleState:{};bizIdentifyKey:{}", (Object)item.getHandleState(), (Object)bizIdentifyKey);
                if ("willApproval".equals(item.getHandleState()) || "dismissed".equals(item.getHandleState())) {
                    lastChar = bizIdentifyKey.substring(bizIdentifyKey.length() - 1);
                    if ("1".equals(lastChar)) {
                        this.setNullFieldValue(1, dataRowSet);
                        this.setNullFieldValue(2, dataRowSet);
                        this.setNullFieldValue(3, dataRowSet);
                    } else if ("2".equals(lastChar)) {
                        this.setNullFieldValue(2, dataRowSet);
                        this.setNullFieldValue(3, dataRowSet);
                    } else if ("3".equals(lastChar)) {
                        this.setNullFieldValue(3, dataRowSet);
                    }
                }
                if ("terminate".equals(item.getHandleState())) {
                    lastChar = bizIdentifyKey.substring(bizIdentifyKey.length() - 1);
                    if ("1".equals(lastChar)) {
                        this.setNullFieldValue(2, dataRowSet);
                        this.setNullFieldValue(3, dataRowSet);
                    } else if ("2".equals(lastChar)) {
                        this.setNullFieldValue(3, dataRowSet);
                    }
                }
                if (bizKey.get(0).equals(bizIdentifyKey)) {
                    this.setFieldValue(1, dataRowSet, item);
                }
                if (bizKey.get(1).equals(bizIdentifyKey)) {
                    this.setFieldValue(2, dataRowSet, item);
                }
                if (!bizKey.get(2).equals(bizIdentifyKey)) continue;
                this.setFieldValue(3, dataRowSet, item);
            }
        }
    }

    private void setFieldValue(int num, DataRowSet dataRowSet, IApprovalRecordItem item) {
        String activityName = item.getActivityName();
        TextField actField = new TextField();
        actField.setValue(activityName);
        if (activityName != null) {
            dataRowSet.put("nodename" + num, (Field)actField);
        }
        String message = item.getMessage();
        TextField mesField = new TextField();
        mesField.setValue(message);
        if (message == null) {
            return;
        }
        dataRowSet.put("appropinions" + num, (Field)mesField);
        String[] split = item.getAssignee().split("\\|");
        if (split.length > 0) {
            TextField curUserField = new TextField();
            curUserField.setValue(split[0]);
            dataRowSet.put("apprperson" + num, (Field)curUserField);
        }
        try {
            String time = item.getTime();
            Date date = HRDateTimeUtils.parseDate((String)time);
            DateField timeField = new DateField();
            timeField.setValue((Object)date);
            if (time != null) {
                dataRowSet.put("apprdate" + num, (Field)timeField);
            }
        }
        catch (ParseException parseException) {
            LOG.error("parseException.message", (Throwable)parseException);
        }
    }

    private void setNullFieldValue(int num, DataRowSet dataRowSet) {
        TextField actField = new TextField();
        actField.setValue("");
        dataRowSet.put("nodename" + num, (Field)actField);
        TextField mesField = new TextField();
        mesField.setValue("");
        dataRowSet.put("appropinions" + num, (Field)mesField);
        TextField curUserField = new TextField();
        curUserField.setValue("");
        dataRowSet.put("apprperson" + num, (Field)curUserField);
        DateField timeField = new DateField();
        timeField.setValue((Object)new Date());
        timeField.setDisplayVal("");
        dataRowSet.put("apprdate" + num, (Field)timeField);
    }
}

