/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.message.consumer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soebs.business.domain.msgwhitelist.MsgWhiteListDomainService;
import kd.sihc.soebs.business.message.apiconsumer.helper.CadreInfoConsumerHelper;

public class PersonCadreInfoChangeConsumer
implements MessageConsumer {
    private static final Log LOG = LogFactory.getLog(PersonCadreInfoChangeConsumer.class);
    private static final String MSG_TYPE = "msgtype";
    private static final String MSG_CONTENT = "msgcontent";
    private static final HRBaseServiceHelper FILING_PER_BASE_HELPER = new HRBaseServiceHelper("soefam_filingperbase");
    private static final MsgWhiteListDomainService MSG_WHITE_LIST_DOMAIN_SERVICE = new MsgWhiteListDomainService();

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        LOG.info("PersonCadreInfoChangeConsumer.onMessage body : {} messageId : {}  resend : {}", new Object[]{body.toString(), messageId, resend});
        Map bodyMap = (Map)SerializationUtils.fromJsonString((String)body.toString(), Map.class);
        Object msgType = bodyMap.get(MSG_TYPE);
        if ("createCadreFile".equals(msgType)) {
            this.setCadreInfo(bodyMap, acker, messageId);
        } else if ("quitCadreFile".equals(msgType)) {
            this.exitCadre(bodyMap, acker, messageId);
        }
    }

    private void exitCadre(Map<String, Object> bodyMap, MessageAcker acker, String messageId) {
        DynamicObject[] filingPerBases;
        Object personPidList = bodyMap.get(MSG_CONTENT);
        QFilter qFilter = new QFilter("person", "in", personPidList);
        for (DynamicObject filingPerBase : filingPerBases = FILING_PER_BASE_HELPER.query("cadrefile,person,iscadre", qFilter.toArray())) {
            filingPerBase.set("cadrefile", (Object)0L);
            filingPerBase.set("iscadre", (Object)0);
        }
        try (TXHandle tx = TX.required();){
            try {
                FILING_PER_BASE_HELPER.update(filingPerBases);
                MSG_WHITE_LIST_DOMAIN_SERVICE.updateCadreFileNull((List)personPidList);
                acker.ack(messageId);
            }
            catch (Exception ex) {
                LOG.error("PersonCadreInfoChangeConsumer.exitCadre error :", (Throwable)ex);
                tx.markRollback();
            }
        }
    }

    private void setCadreInfo(Map<String, Object> bodyMap, MessageAcker acker, String messageId) {
        DynamicObject[] filingPerBases;
        Object personIdList = bodyMap.get(MSG_CONTENT);
        List cadreInfoList = Arrays.stream(CadreInfoConsumerHelper.getCadreByPersonIds((List)((List)personIdList))).filter(dy -> "1".equals(dy.getString("businessstatus"))).collect(Collectors.toList());
        HashMap<Long, Long> cadreMap = new HashMap<Long, Long>(cadreInfoList.size());
        for (DynamicObject cadreInfo : cadreInfoList) {
            cadreMap.put(cadreInfo.getLong("person.id"), cadreInfo.getLong("id"));
        }
        LOG.info("PersonCadreInfoChangeConsumer.onMessage cadreMap : {}", cadreMap);
        QFilter qFilter = new QFilter("person", "in", personIdList);
        for (DynamicObject filingPerBase : filingPerBases = FILING_PER_BASE_HELPER.query("cadrefile,person,iscadre", qFilter.toArray())) {
            Long cadreId = (Long)cadreMap.get(filingPerBase.getLong("person.id"));
            Optional.ofNullable(cadreId).ifPresent(id -> {
                filingPerBase.set("cadrefile", (Object)cadreId);
                filingPerBase.set("iscadre", (Object)1);
            });
        }
        try (TXHandle tx = TX.required();){
            try {
                FILING_PER_BASE_HELPER.update(filingPerBases);
                MSG_WHITE_LIST_DOMAIN_SERVICE.updateCadreFile(cadreMap);
                acker.ack(messageId);
            }
            catch (Exception ex) {
                LOG.error("PersonCadreInfoChangeConsumer.setCadreInfo error :", (Throwable)ex);
                tx.markRollback();
            }
        }
    }
}

