/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.queryservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertlentoutregHelper;
import kd.sihc.soefam.business.domain.certificate.helper.CertreturnregHelper;
import kd.sihc.soefam.business.queryservice.InitQueryService;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class CertificateQueryService
implements CertificateConstants {
    private static final HRBaseServiceHelper CERTIFICATE_HELPER = new HRBaseServiceHelper("soefam_certificate");
    private static final HRBaseServiceHelper CERTINFO_HELPER = new HRBaseServiceHelper("soefam_certinfo");
    private static final HRBaseServiceHelper CERTNOTINREG_HELPER = new HRBaseServiceHelper("soefam_certnotinreg");
    private static final HRBaseServiceHelper CERTOUTREG_HELPER = new HRBaseServiceHelper("soefam_certoutreg");
    private static final HRBaseServiceHelper CERTREPLACEREG_HELPER = new HRBaseServiceHelper("soefam_certreplacereg");
    private static final HRBaseServiceHelper CERTINREG_HELPER = new HRBaseServiceHelper("soefam_certinreg");
    private static final CertlentoutregHelper CERTLENTOUTREGHELPER = CertlentoutregHelper.init();
    private static final CertreturnregHelper CERTRETURNREGHELPER = CertreturnregHelper.init();

    public DynamicObject[] queryByPersonIdAndConCertType(List<Long> personIds, List<Long> conCertTypeIds) {
        QFilter qFilter = new QFilter("person", "in", personIds);
        QFilter qFilter1 = new QFilter("concerttype", "in", conCertTypeIds);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        return CERTIFICATE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1, qFilter2});
    }

    public DynamicObject[] queryByFilPersonAndConCertType(List<Long> filPersonIds, List<Long> conCertTypeIds) {
        QFilter qFilter = new QFilter("filperson", "in", filPersonIds);
        QFilter qFilter1 = new QFilter("concerttype", "in", conCertTypeIds);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        return CERTIFICATE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1, qFilter2});
    }

    public DynamicObject[] queryAllByFilPerson(List<Long> filPersonIds) {
        QFilter qFilter = new QFilter("filperson", "in", filPersonIds);
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        return CERTIFICATE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] queryPermissionByFilPerson(List<Long> filPersonIds) {
        QFilter permission = PermissionUtils.getPermissionQFilter((String)"soefam_certificate");
        QFilter qFilter = new QFilter("person", "in", filPersonIds);
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        String selectProperties = "id,concerttype,,managestatus,filperson,certinfo,stockstatus";
        String orderBys = "certinfo.effectivestatus desc,concerttype.number asc";
        return CERTIFICATE_HELPER.query(selectProperties, new QFilter[]{qFilter, qFilter1, permission}, orderBys);
    }

    public DynamicObject[] queryById(String selectProperties, List<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        return CERTIFICATE_HELPER.query(selectProperties, qFilter.toArray());
    }

    public DynamicObject[] queryOrderNumById(String selectProperties, List<Long> idList, String manStatus) {
        QFilter qFilter = new QFilter("id", "in", idList);
        if (StringUtils.isNotEmpty((CharSequence)manStatus)) {
            qFilter.and(new QFilter("managestatus", "=", (Object)manStatus));
        }
        return CERTIFICATE_HELPER.query(selectProperties, qFilter.toArray(), "filperson.person.number");
    }

    public DynamicObject[] queryCertificateById(String selectProperties, List<Long> idList, List<String> manStatus, List<String> stockStatus, String effStatus) {
        QFilter qFilter = new QFilter("id", "in", idList);
        if (manStatus.size() != 0) {
            qFilter.and(new QFilter("managestatus", "in", manStatus));
        }
        if (stockStatus.size() != 0) {
            qFilter.and(new QFilter("stockstatus", "in", stockStatus));
        }
        if (StringUtils.isNotEmpty((CharSequence)effStatus)) {
            qFilter.and(new QFilter("certinfo.effectivestatus", "=", (Object)effStatus));
        }
        return CERTIFICATE_HELPER.query(selectProperties, qFilter.toArray(), "filperson.person.number");
    }

    public DynamicObject[] queryById(String selectProperties, List<Long> idList, QFilter qFilter, String orderBy) {
        if (qFilter != null) {
            qFilter.and(new QFilter("id", "in", idList));
        } else {
            qFilter = new QFilter("id", "in", idList);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            return CERTIFICATE_HELPER.query(selectProperties, qFilter.toArray(), orderBy);
        }
        return CERTIFICATE_HELPER.query(selectProperties, qFilter.toArray());
    }

    public DynamicObject[] queryToLentOutRegByCertIds(List<Long> certIds) {
        QFilter qFilter = new QFilter("certificate.id", "in", certIds);
        QFilter qFilter1 = new QFilter("registerstate", "=", (Object)"0");
        return CERTLENTOUTREGHELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] queryUnUseLentOutRegByFaIds(Long faId) {
        QFilter qFilter = new QFilter("faid", "=", (Object)faId);
        QFilter qFilter1 = new QFilter("registerstate", "=", (Object)" ");
        return CERTLENTOUTREGHELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] queryReturnRegByFaIds(Long faId) {
        QFilter qFilter = new QFilter("faid", "=", (Object)faId);
        return CERTRETURNREGHELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryLentOutRegByCertIds(Long certId) {
        QFilter qFilter = new QFilter("certificate.id", "=", (Object)certId);
        String selectProperties = "id,faid,,lenddate";
        String orderBys = "lenddate asc";
        return CERTLENTOUTREGHELPER.query(selectProperties, new QFilter[]{qFilter}, orderBys);
    }

    public DynamicObject[] queryLentOutRegByFaIds(Long faId) {
        QFilter qFilter = new QFilter("faid", "=", (Object)faId);
        String[] stockStatus = new String[]{CertStockStatusEnum.STATUS_IN.getKey(), CertStockStatusEnum.STATUS_TOOUT.getKey(), CertStockStatusEnum.STATUS_OUT.getKey()};
        QFilter qFilter1 = new QFilter("certificate.stockstatus", "in", (Object)stockStatus);
        return CERTLENTOUTREGHELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] queryLentOutRegByFilPersonId(Long personId, List<Long> faIds) {
        QFilter qFilter = new QFilter("certificate.person", "=", (Object)personId);
        QFilter qFilter1 = new QFilter("faid", "in", faIds);
        String selectProperties = "id,faid,lenddate,certificate,receiver";
        String orderBys = "lenddate asc";
        return CERTLENTOUTREGHELPER.query(selectProperties, new QFilter[]{qFilter, qFilter1}, orderBys);
    }

    public DynamicObject[] queryReturnRegByFilPersonId(Long personId, List<Long> faIds) {
        QFilter qFilter = new QFilter("certificate.person", "=", (Object)personId);
        QFilter qFilter1 = new QFilter("faid", "in", faIds);
        String selectProperties = "id,faid,returndate,certificate";
        String orderBys = "returndate asc";
        return CERTRETURNREGHELPER.query(selectProperties, new QFilter[]{qFilter, qFilter1}, orderBys);
    }

    public DynamicObject[] queryReturnRegByPersonIdAndFaIds(Long personId, List<Long> faIds) {
        QFilter qFilter = new QFilter("certificate.person", "=", (Object)personId);
        QFilter qFilter1 = new QFilter("faid", "in", faIds);
        QFilter qFilter2 = new QFilter("registerstate", "=", (Object)"0");
        String selectProperties = "id,faid,concerttype.name,certificate";
        return CERTRETURNREGHELPER.query(selectProperties, new QFilter[]{qFilter, qFilter1, qFilter2});
    }

    public DynamicObject[] queryEffCertInfoByCertificateIds(List<Long> certificateIds) {
        QFilter qFilter = new QFilter("certificate", "in", certificateIds);
        QFilter qFilter1 = new QFilter("effectivestatus", "=", (Object)"1");
        return CERTINFO_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] queryAllCertInfoByCertificateIds(Long certificateId) {
        QFilter qFilter = new QFilter("certificate", "=", (Object)certificateId);
        String selectProperties = "id,certificate,,certnumber,signdate,pervaldate,signorg,signplace,remarks,effectivestatus";
        String orderBys = "effectivestatus desc,pervaldate desc";
        return CERTINFO_HELPER.query(selectProperties, new QFilter[]{qFilter}, orderBys);
    }

    public List<String> getCertificateData(IListView listView) {
        Object[] primaryKeyValue = listView.getSelectedRows().getPrimaryKeyValues();
        ArrayList<Long> selectIdList = new ArrayList<Long>(primaryKeyValue.length);
        for (Object id : primaryKeyValue) {
            selectIdList.add((Long)id);
        }
        DynamicObject[] certificateObjList = this.queryById("filperson", selectIdList);
        return Arrays.stream(certificateObjList).map(dynamicObject -> dynamicObject.getString("filperson.person.number")).distinct().collect(Collectors.toList());
    }

    public DynamicObject[] queryCertificateByPersonId(Long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        return CERTIFICATE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter2});
    }

    public DynamicObject[] queryCertInfoByCertIds(List<Long> certIds) {
        QFilter qFilter = new QFilter("certificate", "in", certIds);
        return CERTINFO_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject queryCertInfoByFid(Long fid) {
        QFilter qFilter = new QFilter("id", "=", (Object)fid);
        return CERTINFO_HELPER.loadDynamicObject(qFilter.toArray());
    }

    public DynamicObject[] queryCertNotInRegByCertId(Long certificateId) {
        QFilter qFilter = new QFilter("certificate", "=", (Object)certificateId);
        return CERTNOTINREG_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryCertInRegByCertId(Long certificateId) {
        QFilter qFilter = new QFilter("certificate", "=", (Object)certificateId);
        return CERTINREG_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryCertReplaceRegByCertId(Long certificateId) {
        QFilter qFilter = new QFilter("certificate", "=", (Object)certificateId);
        return CERTREPLACEREG_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryCertOutRegByCertId(Long certificateId) {
        QFilter qFilter = new QFilter("certificate", "=", (Object)certificateId);
        return CERTOUTREG_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getCertIfiCateByPersonNumber(List<Object> personNumber) {
        QFilter filter = new QFilter("filperson.person.number", "in", personNumber);
        return CERTIFICATE_HELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getEffectCertIfiCateByPersonNumber(List<Object> personNumber) {
        QFilter filter = new QFilter("filperson.person.number", "in", personNumber);
        filter.and(new QFilter("certinfo.effectivestatus", "=", (Object)"1"));
        return CERTIFICATE_HELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getCertIfiCateByPersonIds(List<Long> personIds) {
        QFilter filter = new QFilter("person", "in", personIds);
        return CERTIFICATE_HELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getCertIfiCateByBatchNumber(Long batchNumber) {
        QFilter filter = new QFilter("initbatch", "=", (Object)batchNumber);
        return CERTIFICATE_HELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getCertIfiCateByFilPerIds(List<Long> filPerIds) {
        QFilter filter = new QFilter("filperson", "in", filPerIds);
        return CERTIFICATE_HELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getCertInfoByBatchNumber(Long batchNumber) {
        QFilter filter = new QFilter("initbatch", "=", (Object)batchNumber);
        return CERTINFO_HELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject[] getCertificateDidNo() {
        QFilter qFilter = new QFilter("stockstatus", "=", (Object)CertStockStatusEnum.STATUS_NOTIN.getKey());
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.query(new QFilter[]{qFilter});
    }

    public int getCertificateDidNoCount() {
        QFilter qFilter = new QFilter("stockstatus", "=", (Object)CertStockStatusEnum.STATUS_NOTIN.getKey());
        this.getPermissionQFilter(qFilter);
        int count = CERTIFICATE_HELPER.count("soefam_certificate", new QFilter[]{qFilter});
        return count;
    }

    public DynamicObject[] getCertificateReceive() {
        QFilter qFilter = new QFilter("stockstatus", "in", (Object)new String[]{CertStockStatusEnum.STATUS_IN.getKey(), CertStockStatusEnum.STATUS_TOOUT.getKey()});
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.query(new QFilter[]{qFilter});
    }

    public int getCertificateReceiveCount() {
        QFilter qFilter = new QFilter("stockstatus", "in", (Object)new String[]{CertStockStatusEnum.STATUS_IN.getKey(), CertStockStatusEnum.STATUS_TOOUT.getKey()});
        this.getPermissionQFilter(qFilter);
        int count = CERTIFICATE_HELPER.count("soefam_certificate", new QFilter[]{qFilter});
        return count;
    }

    public DynamicObject[] getCerReceiveType() {
        QFilter qFilter = new QFilter("stockstatus", "in", (Object)new String[]{CertStockStatusEnum.STATUS_IN.getKey(), CertStockStatusEnum.STATUS_TOOUT.getKey()});
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.query("concerttype.controlclassify", new QFilter[]{qFilter});
    }

    public DynamicObject[] getCertificateLend() {
        QFilter qFilter = new QFilter("managestatus", "in", (Object)CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.query(new QFilter[]{qFilter});
    }

    public int getCertificateLendCount() {
        QFilter qFilter = new QFilter("managestatus", "in", (Object)CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.count("soefam_certificate", new QFilter[]{qFilter});
    }

    public DynamicObject[] getCertificateReturn() {
        QFilter qFilter = new QFilter("managestatus", "in", (Object)CertManageStatusEnum.STATUS_TORETURN.getKey());
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.query(new QFilter[]{qFilter});
    }

    public int getCertificateReturnCount() {
        QFilter qFilter = new QFilter("managestatus", "in", (Object)CertManageStatusEnum.STATUS_TORETURN.getKey());
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.count("soefam_certificate", new QFilter[]{qFilter});
    }

    public DynamicObject[] getCertificateShipOut() {
        QFilter qFilter = new QFilter("stockstatus", "in", (Object)new String[]{CertStockStatusEnum.STATUS_TOOUT.getKey()});
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.query(new QFilter[]{qFilter});
    }

    public int getCertificateShipOutCount() {
        QFilter qFilter = new QFilter("stockstatus", "in", (Object)new String[]{CertStockStatusEnum.STATUS_TOOUT.getKey()});
        this.getPermissionQFilter(qFilter);
        return CERTIFICATE_HELPER.count("soefam_certificate", new QFilter[]{qFilter});
    }

    private void getPermissionQFilter(QFilter qFilter) {
        QFilter permOrgs;
        QFilter initFilter = InitQueryService.getInitFilter();
        qFilter.and(initFilter);
        QFilter permission = PermissionUtils.getPermissionQFilter((String)"soefam_certificate");
        if (permission != null) {
            qFilter.and(permission);
        }
        if ((permOrgs = PermissionUtils.getUserHasPermOrgs((String)"soefam_certificate", (String)"org")) != null) {
            qFilter.and(permOrgs);
        }
    }

    public DynamicObject[] getCertificateByConType(String controlClassFy) {
        QFilter qFilter = new QFilter("concerttype.controlclassify", "=", (Object)controlClassFy);
        return CERTIFICATE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryNotInReasonByCertIds(List<Object> certIds) {
        QFilter qFilter = new QFilter("certificate", "in", certIds);
        QFilter qFilter1 = new QFilter("latestrecord", "=", (Object)"1");
        String selectFields = "id,certificate,nostorereason";
        return CERTNOTINREG_HELPER.query(selectFields, new QFilter[]{qFilter, qFilter1});
    }
}

