/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.queryservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.faapply.FaApplyConstants;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class FaApplyQueryService
implements FaApplyConstants {
    private static final HRBaseServiceHelper FAAPPLICATIONHELPER = new HRBaseServiceHelper("soefam_faapplication");
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = ServiceFactory.getService(CertificateQueryService.class);

    public DynamicObject getFaBillById(Long billId) {
        QFilter filter = new QFilter("id", "=", (Object)billId);
        return FAAPPLICATIONHELPER.loadDynamicObject(filter);
    }

    public DynamicObject[] getFaBillByIdList(List<Long> billIdList) {
        QFilter filter = new QFilter("id", "in", billIdList);
        return FAAPPLICATIONHELPER.loadDynamicObjectArray(filter.toArray());
    }

    public DynamicObject getFaBillByBillNo(String billNo) {
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        return FAAPPLICATIONHELPER.loadDynamicObject(filter);
    }

    public DynamicObject[] getFaApplyByCertId(Long certId) {
        DynamicObject[] lentOutRegs = CERTIFICATE_QUERY_SERVICE.queryLentOutRegByCertIds(certId);
        List faIds = Arrays.stream(lentOutRegs).map(object -> object.getLong("faid")).collect(Collectors.toList());
        Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)"soefam").getId(), "soefam_faapplication", "47150e89000000ac", Collections.emptyMap()};
        QFilter permission = PermissionUtils.getPermissionQFilter((Object[])params);
        QFilter qFilter = new QFilter("id", "in", faIds);
        QFilter qFilter1 = new QFilter("billstatus", "=", (Object)"C");
        QFilter permOrg = PermissionUtils.getUserHasPermOrgs((String)"org");
        return FAAPPLICATIONHELPER.loadDynamicObjectArray(new QFilter[]{qFilter, qFilter1, permission, permOrg});
    }

    public DynamicObject[] getFaApplyByFilPersonId(Long personId, List<Long> manageOrgInfo, List<Long> manageOrgInfo0, List<Long> manageOrgInfo1) {
        Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)"soefam").getId(), "soefam_faapplication", "47150e89000000ac", Collections.emptyMap()};
        QFilter permission = PermissionUtils.getPermissionQFilter((Object[])params);
        QFilter qFilter = new QFilter("vispersonentity.visperson", "=", (Object)personId);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("vispersonentity.visfilpermanage", "!=", (Object)0));
        qFilter.and(new QFilter("businesstype", "!=", (Object)"1"));
        if (manageOrgInfo0.size() == 0) {
            qFilter.and(new QFilter("applyformtype", "!=", (Object)"C"));
        }
        if (manageOrgInfo1.size() == 0) {
            qFilter.and(new QFilter("applyformtype", "not in", Arrays.asList("A", "B")));
        }
        qFilter.and(new QFilter("vispersonentity.visfilpermanage.manageorg.fbasedataid", "in", manageOrgInfo));
        QFilter permOrg = PermissionUtils.getUserHasPermOrgs((String)"org");
        return FAAPPLICATIONHELPER.loadDynamicObjectArray(new QFilter[]{qFilter, permission, permOrg});
    }

    public DynamicObject isExistSameApplicant(Long personId, String applyFormType, Long currentBillId) {
        QFilter filter = new QFilter("person", "=", (Object)personId);
        filter.and(new QFilter("applyformtype", "=", (Object)applyFormType));
        QFilter statusFilter = new QFilter("auditstatus", "=", (Object)"B");
        statusFilter.or(new QFilter("auditstatus", "=", (Object)"D"));
        statusFilter.or(new QFilter("auditstatus", "=", (Object)"A"));
        filter.and(statusFilter);
        if (currentBillId != null) {
            filter.and(new QFilter("id", "!=", (Object)currentBillId));
        }
        return FAAPPLICATIONHELPER.loadDynamicObject(filter);
    }

    public DynamicObject[] getExistOnBusAbrApplicant(List<Long> demIds, String applyFormType, Long currentBillId) {
        QFilter filter = new QFilter("vispersonentity.visdepemp", "in", demIds);
        filter.and(new QFilter("applyformtype", "=", (Object)applyFormType));
        QFilter statusFilter = new QFilter("auditstatus", "=", (Object)"B");
        statusFilter.or(new QFilter("auditstatus", "=", (Object)"D"));
        statusFilter.or(new QFilter("auditstatus", "=", (Object)"A"));
        filter.and(statusFilter);
        if (currentBillId != null) {
            filter.and(new QFilter("id", "!=", (Object)currentBillId));
        }
        DynamicObject[] dynamicObject = FAAPPLICATIONHELPER.loadDynamicObjectArray(filter.toArray());
        return dynamicObject;
    }

    public DynamicObject[] getExistOnBusAbrApplicant(Long personId, String applyFormType, Long currentBillId) {
        QFilter filter = new QFilter("vispersonentity.visperson", "in", (Object)personId);
        filter.and(new QFilter("applyformtype", "=", (Object)applyFormType));
        QFilter statusFilter = new QFilter("auditstatus", "=", (Object)"B");
        statusFilter.or(new QFilter("auditstatus", "=", (Object)"D"));
        statusFilter.or(new QFilter("auditstatus", "=", (Object)"A"));
        filter.and(statusFilter);
        if (currentBillId != null) {
            filter.and(new QFilter("id", "!=", (Object)currentBillId));
        }
        DynamicObject[] dynamicObject = FAAPPLICATIONHELPER.loadDynamicObjectArray(filter.toArray());
        return dynamicObject;
    }

    public DynamicObject[] getDepEmpInfo(List<Long> demIds) {
        HRBaseServiceHelper depEmpHelper = new HRBaseServiceHelper("hrpi_depemp");
        QFilter qFilter = new QFilter("id", "in", demIds);
        return depEmpHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public Map<String, List<DynamicObject>> getInAppFABill() {
        QFilter filter = new QFilter("auditstatus", "=", (Object)"D");
        filter.or(new QFilter("auditstatus", "=", (Object)"B"));
        return this.queryAndSortFABills(filter);
    }

    public Map<String, List<DynamicObject>> getApprovedFABillByDateRange(Date startDate, Date endDate) {
        QFilter filter = new QFilter("auditstatus", "=", (Object)"C");
        filter.and(new QFilter("auditdate", ">=", (Object)startDate));
        filter.and("auditdate", "<=", (Object)endDate);
        return this.queryAndSortFABills(filter);
    }

    public QFilter getFABillsByPerm(String applyFormType, QFilter filter) {
        QFilter applyFormTypeFilter = new QFilter("applyformtype", "=", (Object)applyFormType);
        if ("A".equals(applyFormType)) {
            QFilter notOrgFilter;
            QFilter notDataFilter = PermissionUtils.getPermissionQFilter((String)"soefam_notgacapply");
            if (notDataFilter != null) {
                applyFormTypeFilter.and(notDataFilter);
            }
            if ((notOrgFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_notgacapply", (String)"org")) != null) {
                applyFormTypeFilter.and(notOrgFilter);
            }
        } else if ("B".equals(applyFormType)) {
            QFilter prOrgFilter;
            QFilter prDataFilter = PermissionUtils.getPermissionQFilter((String)"soefam_proutbapply");
            if (prDataFilter != null) {
                applyFormTypeFilter.and(prDataFilter);
            }
            if ((prOrgFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_proutbapply", (String)"org")) != null) {
                applyFormTypeFilter.and(prOrgFilter);
            }
        } else if ("C".equals(applyFormType)) {
            QFilter onBusOrgFilter;
            QFilter onBusFilter = PermissionUtils.getPermissionQFilter((String)"soefam_onbusabroad");
            if (onBusFilter != null) {
                applyFormTypeFilter.and(onBusFilter);
            }
            if ((onBusOrgFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_onbusabroad", (String)"org")) != null) {
                applyFormTypeFilter.and(onBusOrgFilter);
            }
        }
        return applyFormTypeFilter.and(filter);
    }

    public Map<String, List<DynamicObject>> queryAndSortFABills(QFilter filter) {
        DynamicObject[] notFABills = FAAPPLICATIONHELPER.loadDynamicObjectArray(this.getFABillsByPerm("A", filter).toArray());
        DynamicObject[] prFABills = FAAPPLICATIONHELPER.loadDynamicObjectArray(this.getFABillsByPerm("B", filter).toArray());
        DynamicObject[] onBusFABills = FAAPPLICATIONHELPER.loadDynamicObjectArray(this.getFABillsByPerm("C", filter).toArray());
        HashMap<String, List<DynamicObject>> fABillMap = new HashMap<String, List<DynamicObject>>(16);
        boolean hasPerm = PermissionUtils.checkPermission((String)"soefam_notgacapply", (String)"47150e89000000ac");
        if (hasPerm) {
            fABillMap.put("A", Arrays.asList(notFABills));
        } else {
            fABillMap.put("A", new ArrayList(10));
        }
        hasPerm = PermissionUtils.checkPermission((String)"soefam_proutbapply", (String)"47150e89000000ac");
        if (hasPerm) {
            fABillMap.put("B", Arrays.asList(prFABills));
        } else {
            fABillMap.put("B", new ArrayList(10));
        }
        hasPerm = PermissionUtils.checkPermission((String)"soefam_onbusabroad", (String)"47150e89000000ac");
        if (hasPerm) {
            fABillMap.put("C", Arrays.asList(onBusFABills));
        } else {
            fABillMap.put("C", new ArrayList(10));
        }
        return fABillMap;
    }
}

