/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.queryservice;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.queryservice.InitQueryService;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonConstants;
import kd.sihc.soefam.common.enums.FilingStatusEnum;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class FilPersonQueryService
implements FilPersonConstants {
    private static final Log LOG = LogFactory.getLog(FilPersonQueryService.class);
    private static final HRBaseServiceHelper HRBASESERVICEHELPER = new HRBaseServiceHelper("soefam_filperlist");
    private static final HRBaseServiceHelper FILPERMANAGESERVICEHELPER = new HRBaseServiceHelper("soefam_filpermanage");
    private static final HRBaseServiceHelper HRPIBASESERVICEHELPER = new HRBaseServiceHelper("hrpi_empposorgrel");

    public DynamicObject[] getEmpPersonInfo(List<Long> employeeIds) {
        QFilter qFilter = new QFilter("employee.id", "in", employeeIds);
        qFilter.and("hrpi_empposorgrel.iscurrentversion", "=", (Object)"1");
        qFilter.and("hrpi_empposorgrel.isprimary", "=", (Object)"1");
        qFilter.and("hrpi_empposorgrel.datastatus", "=", (Object)"1");
        qFilter.and("hrpi_empposorgrel.businessstatus", "=", (Object)"1");
        return HRPIBASESERVICEHELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getFilPersonInfos(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return HRBASESERVICEHELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] getFilPersonInfosOrderBy(List<Long> ids, String orderBy) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return HRBASESERVICEHELPER.query("id,employee,recpersontype,cadrefile", new QFilter[]{qFilter}, orderBy);
    }

    public DynamicObject[] queryFilPerByIds(List<Object> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return HRBASESERVICEHELPER.query("id,employee,person", new QFilter[]{qFilter});
    }

    public DynamicObject[] getEmpFilPersonInfos(List<Long> employees) {
        QFilter qFilter = new QFilter("employee", "in", employees);
        QFilter statusQf = new QFilter("effstatus", "=", (Object)"1");
        QFilter staNullQf = new QFilter("effstatus", "=", (Object)" ");
        QFilter orQf = statusQf.or(staNullQf);
        qFilter.and(orQf);
        return HRBASESERVICEHELPER.query("id,employee,person,effstatus", new QFilter[]{qFilter});
    }

    public DynamicObject[] getEmpFilPersonInfo() {
        QFilter statusQf = new QFilter("effstatus", "=", (Object)"1");
        QFilter staNullQf = new QFilter("effstatus", "=", (Object)" ");
        QFilter orQf = statusQf.or(staNullQf);
        return HRBASESERVICEHELPER.query("employee,person,effstatus", new QFilter[]{orQf});
    }

    public DynamicObject[] getAllPenFilPersonInfos() {
        QFilter statusQf = new QFilter("listtype", "=", (Object)"2");
        return HRBASESERVICEHELPER.query(new QFilter[]{statusQf});
    }

    public DynamicObject[] getPenFilPersonInfos(List<Long> filPerIds) {
        QFilter qFilter = new QFilter("id", "in", filPerIds);
        QFilter statusQf = new QFilter("listtype", "=", (Object)"2");
        QFilter staNullQf = new QFilter("effstatus", "=", (Object)"0");
        QFilter orQf = statusQf.or(staNullQf);
        qFilter.and(orQf);
        return HRBASESERVICEHELPER.query("id,employee,person,effstatus,listtype", new QFilter[]{qFilter});
    }

    public DynamicObject[] getAllAuditFilPersonInfo() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        QFilter qFilter1 = new QFilter("effstatus", "=", (Object)"1");
        return HRBASESERVICEHELPER.query("id,employee,person,org,manageorg,primanageorg", new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject getFilPersonByPerIndexId(Long personId) {
        String properties = "empposorgrel,effstatus,person,recpersontype,filingstatus";
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        return FILPERMANAGESERVICEHELPER.queryOne(properties, qFilter.toArray(), "iregscopedate desc");
    }

    public DynamicObject[] getFilManNoFil(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "=", (Object)FilingStatusEnum.UNREGISTERED.code);
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter});
    }

    public int getFilManNoFilCount(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "=", (Object)FilingStatusEnum.UNREGISTERED.code);
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter});
    }

    public DynamicObject[] getFilManLarFil(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter});
    }

    public int getFilManLarFilCount(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter});
    }

    public DynamicObject[] getFilManLarTerFil(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "=", (Object)FilingStatusEnum.CANCEL_FILING.code);
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter});
    }

    public int getFilManLarTerFilCount(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "=", (Object)FilingStatusEnum.CANCEL_FILING.code);
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter});
    }

    public DynamicObject[] getLeaderType(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        QFilter qFilter1 = new QFilter("recpersontype", "=", (Object)1010L);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter, qFilter1});
    }

    public int getLeaderTypeCount(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        QFilter qFilter1 = new QFilter("recpersontype", "=", (Object)1010L);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] getSpecialType(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        QFilter qFilter1 = new QFilter("recpersontype", "=", (Object)1020L);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter, qFilter1});
    }

    public int getSpecialTypeCount(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        QFilter qFilter1 = new QFilter("recpersontype", "=", (Object)1020L);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] getToBeReleased(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter, qFilter});
    }

    public int getToBeReleasedCount(String pageNum) {
        QFilter qFilter = new QFilter("filingstatus", "in", (Object)new String[]{FilingStatusEnum.PEND_TERM_FILING.code});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter, qFilter});
    }

    public DynamicObject[] getToBeEntered(String pageNum) {
        QFilter qFilter = new QFilter("listtype", "in", (Object)new String[]{"1"});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter, qFilter});
    }

    public int getToBeEnteredCount(String pageNum) {
        QFilter qFilter = new QFilter("listtype", "in", (Object)new String[]{"1"});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter, qFilter});
    }

    public DynamicObject[] getPendingExit(String pageNum) {
        QFilter qFilter = new QFilter("listtype", "in", (Object)new String[]{"2"});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.query(new QFilter[]{qFilter, qFilter});
    }

    public int getPendingExitCount(String pageNum) {
        QFilter qFilter = new QFilter("listtype", "in", (Object)new String[]{"2"});
        this.getQFilter(qFilter, pageNum);
        return FILPERMANAGESERVICEHELPER.count("soefam_filpermanage", new QFilter[]{qFilter, qFilter});
    }

    private void getQFilter(QFilter qFilter, String pageNum) {
        QFilter permOrg;
        QFilter initFilter = InitQueryService.getInitFilter();
        qFilter.and(initFilter);
        QFilter permission = PermissionUtils.getPermissionQFilter((String)pageNum);
        if (permission != null) {
            qFilter.and(permission);
        }
        if ((permOrg = PermissionUtils.getUserHasPermOrgs((String)pageNum, (String)"org")) != null) {
            qFilter.and(permOrg);
        }
    }

    public DynamicObjectCollection queryOriginalCollection(String selectFields, QFilter[] filters) {
        return FILPERMANAGESERVICEHELPER.queryOriginalCollection(selectFields, filters);
    }
}

