/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.queryservice.ConCertTypeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;

public class ConCertTypeAsyTask
extends AbstractTask
implements ManageOrgConstants {
    private static final Log LOGGER = LogFactory.getLog(ConCertTypeAsyTask.class);
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE = ServiceFactory.getService(CertificateApplicationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("ConCertTypeAsyTask.execute.map:{}", map);
        String operationKey = map.get("operationKey") != null ? map.get("operationKey").toString() : "";
        Object conCertIdObj = map.get("conCertIds");
        List<Long> conCertIds = new ArrayList<Long>(16);
        if (conCertIdObj != null) {
            conCertIds = (List)conCertIdObj;
        }
        DynamicObject[] dataEntity = ConCertTypeQueryService.getSortedConCertTypesByIds(conCertIds);
        if (HRStringUtils.isNotEmpty((String)operationKey)) {
            CERTIFICATE_APPLICATION_SERVICE.initCertificateForConType(operationKey, dataEntity);
        }
    }

    public void dispatchRuleTask(String operationKey, List<Long> conCertIds) {
        LOGGER.info("ConCertTypeAsyTask.dispatchRuleTask.operationKey:{},dataEntity:{}", (Object)operationKey, conCertIds);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("soefam");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(ResManager.loadKDString((String)"\u8bc1\u7167\u4fe1\u606f\u4fdd\u5b58", (String)"ConCertTypeAsyTask_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.sihc.soefam.business.task.ConCertTypeAsyTask");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("operationKey", operationKey);
        params.put("conCertIds", conCertIds);
        jobInfo.setParams(params);
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }
}

