/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sihc.soebs.common.constants.rpc.HRCSRpcConstants;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.application.service.filingsperson.FilPerScopeApplicationService;
import kd.sihc.soefam.business.queryservice.ManageOrgRangeQueryService;
import kd.sihc.soefam.common.constants.dto.EmployeeMatchDTO;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;

public class FilPerRuleTask
extends AbstractTask
implements ManageOrgConstants {
    private static final Log LOGGER = LogFactory.getLog(FilPerRuleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("FilPerRuleTask.execute.map:{}", map);
        Object ruleType = map.get("ruleType");
        if ("0".equals(ruleType)) {
            Object manageOrgIds = map.get("manageOrgIds");
            if (manageOrgIds != null) {
                this.manageOrgSaveRule((List)manageOrgIds);
            }
        } else if ("2".equals(ruleType)) {
            Object employeeIds = map.get("employeeIds");
            if (employeeIds != null) {
                this.filPerAuditRule((List)employeeIds);
            }
        } else {
            this.manageOrgTaskRule();
        }
    }

    public void manageOrgSaveRule(List<Long> manageOrgIds) {
        LOGGER.info("FilPerRuleTask.manageOrgSaveRule.manageOrgIds:{}", manageOrgIds);
        if (manageOrgIds.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "in", manageOrgIds);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("controlclass", "=", (Object)"1"));
        DynamicObject[] manOrgRangeList = ManageOrgRangeQueryService.getManOrgRangeByFilter(filter);
        DynamicObject[] depEmps = HrpiQueryServiceHelper.getDepEmpByManOrgRanges(manOrgRangeList);
        List<Long> employeeIds = Arrays.stream(depEmps).map(depEmp -> depEmp.getLong("employee.id")).collect(Collectors.toList());
        LOGGER.info("FilPerRuleTask.manageOrgSaveRule.employeeIds:{}", employeeIds);
        DynamicObject[] empJobRels = HrpiQueryServiceHelper.getEmpJobRelByEmployee(employeeIds);
        DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(employeeIds);
        List<Long> latestRecordEmployeeIds = HrpiQueryServiceHelper.filterLatestRecordEmployeeIds(employeeIds);
        LOGGER.info("FilPerRuleTask.manageOrgSaveRule.latestRecordEmployeeIds:{}", latestRecordEmployeeIds);
        LOGGER.info("FilPerRuleTask.manageOrgSaveRule.matchStart");
        List<EmployeeMatchDTO> matchEmployeeMatchDTOS = this.matchDataAssemble(manOrgRangeList, depEmps, empJobRels, empCadres, latestRecordEmployeeIds);
        List<Long> allMatchPersonIds = Arrays.stream(depEmps).map(depEmp -> depEmp.getLong("person.id")).collect(Collectors.toList());
        this.afterMatchFilPerHandle(matchEmployeeMatchDTOS, allMatchPersonIds, manOrgRangeList, false);
    }

    public void manageOrgTaskRule() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("controlclass", "=", (Object)"1"));
        DynamicObject[] manOrgRangeList = ManageOrgRangeQueryService.getManOrgRangeByFilter(filter);
        List<Long> modifiedEmployeeIds = HrpiQueryServiceHelper.getModifiedEmployeeIds();
        LOGGER.info("FilPerRuleTask.manageOrgTaskRule.modifiedEmployeeIds:{}", modifiedEmployeeIds);
        DynamicObject[] depEmps = HrpiQueryServiceHelper.getDepEmpByEmployee(modifiedEmployeeIds);
        DynamicObject[] empJobRels = HrpiQueryServiceHelper.getEmpJobRelByEmployee(modifiedEmployeeIds);
        DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(modifiedEmployeeIds);
        List<Long> latestRecordEmployeeIds = HrpiQueryServiceHelper.filterLatestRecordEmployeeIds(modifiedEmployeeIds);
        LOGGER.info("FilPerRuleTask.manageOrgTaskRule.latestRecordEmployeeIds:{}", latestRecordEmployeeIds);
        LOGGER.info("FilPerRuleTask.manageOrgTaskRule.matchStart");
        List<EmployeeMatchDTO> matchEmployeeMatchDTOS = this.matchDataAssemble(manOrgRangeList, depEmps, empJobRels, empCadres, latestRecordEmployeeIds);
        List<Long> allMatchPersonIds = Arrays.stream(depEmps).map(depEmp -> depEmp.getLong("person.id")).collect(Collectors.toList());
        this.afterMatchFilPerHandle(matchEmployeeMatchDTOS, allMatchPersonIds, manOrgRangeList, true);
    }

    public void filPerAuditRule(List<Long> employeeIds) {
        LOGGER.info("FilPerRuleTask.filPerAuditRule.employeeIds:{}", employeeIds);
        List<Long> latestRecordEmployeeIds = HrpiQueryServiceHelper.getLatestRecordEmployeeIds(employeeIds);
        LOGGER.info("FilPerRuleTask.manageOrgTaskRule.latestRecordEmployeeIds:{}", latestRecordEmployeeIds);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("controlclass", "=", (Object)"1"));
        DynamicObject[] manOrgRangeList = ManageOrgRangeQueryService.getManOrgRangeByFilter(filter);
        DynamicObject[] depEmps = HrpiQueryServiceHelper.getDepEmpByEmployee(latestRecordEmployeeIds);
        DynamicObject[] empJobRels = HrpiQueryServiceHelper.getEmpJobRelByEmployee(latestRecordEmployeeIds);
        DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(latestRecordEmployeeIds);
        LOGGER.info("FilPerRuleTask.filPerAuditRule.matchStart");
        List<EmployeeMatchDTO> matchEmployeeMatchDTOS = this.matchDataAssemble(manOrgRangeList, depEmps, empJobRels, empCadres, latestRecordEmployeeIds);
        List<Long> allMatchPersonIds = Arrays.stream(depEmps).map(depEmp -> depEmp.getLong("person.id")).collect(Collectors.toList());
        this.afterMatchFilPerHandle(matchEmployeeMatchDTOS, allMatchPersonIds, manOrgRangeList, true);
    }

    public void afterMatchFilPerHandle(List<EmployeeMatchDTO> matchEmployeeMatchDTOS, List<Long> allMatchPersonIds, DynamicObject[] manOrgRangeList, boolean hasDefinitePersons) {
        List<Long> matchedPersonIdList = matchEmployeeMatchDTOS.stream().map(matchEmployeeMatchDTO -> matchEmployeeMatchDTO.getPerson().getLong("id")).collect(Collectors.toList());
        LOGGER.info("FilPerRuleTask.afterMatchFilPerHandle.matchedPersonIdList:{}", matchedPersonIdList);
        List<Long> matchedDepEmpIdList = matchEmployeeMatchDTOS.stream().map(matchEmployeeMatchDTO -> matchEmployeeMatchDTO.getDepEmp().getLong("id")).collect(Collectors.toList());
        DynamicObject[] empPosOrgRels = HrpiQueryServiceHelper.getEmpPosOrgRelByDepEmpIds(matchedDepEmpIdList);
        HashMap<Long, DynamicObject> matchedEmpPosOrgRelMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject empPosOrgRel : empPosOrgRels) {
            paramMap.put(empPosOrgRel.getLong("adminorg.id"), Collections.singleton(HRCSRpcConstants.BIZ_TYPE));
            matchedEmpPosOrgRelMap.put(empPosOrgRel.getLong("person.id"), empPosOrgRel);
        }
        LOGGER.info("FilPerRuleTask.afterMatchFilPerHandle.paramMap.size:{},paramMap:{}", (Object)paramMap.size(), paramMap);
        List<Map<String, Long>> resultList = HrmpExternalService.getHrBuByBusinessType(paramMap, HRCSRpcConstants.BIZ_OBJ_TYPE);
        LOGGER.info("FilPerRuleTask.afterMatchFilPerHandle.resultList:{}", resultList);
        HashMap<Long, Long> matchedEmployeeMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> personRecPersonTypeMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> personManageOrgMap = new HashMap<Long, DynamicObject>(16);
        for (EmployeeMatchDTO matchEmployeeMatchDTO2 : matchEmployeeMatchDTOS) {
            DynamicObject employee = matchEmployeeMatchDTO2.getEmployee();
            DynamicObject person = matchEmployeeMatchDTO2.getPerson();
            if (employee == null || person == null) continue;
            matchedEmployeeMap.put(person.getLong("id"), employee.getLong("id"));
            personRecPersonTypeMap.put(person.getLong("id"), matchEmployeeMatchDTO2.getRecPersonType());
            personManageOrgMap.put(person.getLong("id"), matchEmployeeMatchDTO2.getManOrgRange().getDynamicObject("manageorg"));
        }
        FilPerScopeApplicationService.toInvalidateFilPer(matchedPersonIdList, allMatchPersonIds, manOrgRangeList, hasDefinitePersons);
        FilPerScopeApplicationService.toAddFilPer(matchedPersonIdList, matchedEmployeeMap, matchedEmpPosOrgRelMap, personRecPersonTypeMap, personManageOrgMap, resultList);
    }

    public List<EmployeeMatchDTO> matchDataAssemble(DynamicObject[] manOrgRangeList, DynamicObject[] depEmps, DynamicObject[] empJobRels, DynamicObject[] empCadres, List<Long> latestRecordEmployeeIds) {
        DynamicObject[] erManFiles = HrpiQueryServiceHelper.getErManFileByDepEmp(depEmps);
        HashMap<Long, DynamicObject> depEmpErManFileMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject erManFile : erManFiles) {
            depEmpErManFileMap.put(erManFile.getLong("depemp.id"), erManFile);
        }
        Map<Long, DynamicObject> depEmpAdminOrgMap = HrpiQueryServiceHelper.getDepEmpAdminOrgMap(depEmps);
        HashMap<Long, List> allEmpjobrelMap = new HashMap<Long, List>(16);
        for (DynamicObject empJobRel : empJobRels) {
            long eEmployeeId = empJobRel.getLong("employee.id");
            List empjobrelList = (List)allEmpjobrelMap.get(eEmployeeId);
            if (empjobrelList == null) {
                ArrayList<DynamicObject> newEmpjobrelList = new ArrayList<DynamicObject>(10);
                newEmpjobrelList.add(empJobRel);
                allEmpjobrelMap.put(eEmployeeId, newEmpjobrelList);
                continue;
            }
            empjobrelList.add(empJobRel);
            allEmpjobrelMap.put(eEmployeeId, empjobrelList);
        }
        HashMap<Long, DynamicObject> allEmpCadreMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject empCadre : empCadres) {
            long eEmployeeId = empCadre.getLong("employee.id");
            allEmpCadreMap.put(eEmployeeId, empCadre);
        }
        ArrayList<EmployeeMatchDTO> matchEmployeeMatchDTOList = new ArrayList<EmployeeMatchDTO>(10);
        int count = 0;
        double numberOfOnce = (double)depEmps.length / 100.0;
        int feedBackNumber = 1;
        LOGGER.info("FilPerRuleTask.matchDataAssemble.matchStart");
        for (DynamicObject depEmp : depEmps) {
            DynamicObject erManFile = (DynamicObject)depEmpErManFileMap.get(depEmp.getLong("id"));
            if (erManFile == null) continue;
            DynamicObject person = depEmp.getDynamicObject("person");
            DynamicObject employee = depEmp.getDynamicObject("employee");
            if (employee == null || !latestRecordEmployeeIds.contains(employee.getLong("id"))) continue;
            List empJobRelList = (List)allEmpjobrelMap.get(employee.getLong("id"));
            DynamicObject empCadre = (DynamicObject)allEmpCadreMap.get(employee.getLong("id"));
            DynamicObject adminOrg = depEmpAdminOrgMap.get(depEmp.getLong("adminorg.id"));
            if (empJobRelList != null) {
                for (DynamicObject empJobRel : empJobRelList) {
                    EmployeeMatchDTO employeeMatchDTO = new EmployeeMatchDTO();
                    employeeMatchDTO.setPerson(person);
                    employeeMatchDTO.setEmployee(employee);
                    employeeMatchDTO.setDepEmp(depEmp);
                    employeeMatchDTO.setAdminOrg(adminOrg);
                    employeeMatchDTO.setCadreType(empCadre == null ? null : empCadre.getDynamicObject("cadretype"));
                    employeeMatchDTO.setIsCadre(empCadre == null ? "false" : empCadre.getString("iscadre"));
                    employeeMatchDTO.setPositionType(depEmp.getString("apositiontype"));
                    employeeMatchDTO.setJob(empJobRel.getDynamicObject("job"));
                    employeeMatchDTO.setPosition(depEmp.getDynamicObject("position"));
                    employeeMatchDTO.setStdPosition(depEmp.getDynamicObject("stdposition"));
                    employeeMatchDTO.setJobLevel(empJobRel.getDynamicObject("joblevel"));
                    employeeMatchDTO.setJobGrade(empJobRel.getDynamicObject("jobgrade"));
                    boolean isMatch = this.employeeMatchLogic(employeeMatchDTO, manOrgRangeList);
                    if (!isMatch) continue;
                    matchEmployeeMatchDTOList.add(employeeMatchDTO);
                    break;
                }
            } else {
                EmployeeMatchDTO employeeMatchDTO = new EmployeeMatchDTO();
                employeeMatchDTO.setPerson(person);
                employeeMatchDTO.setEmployee(employee);
                employeeMatchDTO.setDepEmp(depEmp);
                employeeMatchDTO.setAdminOrg(adminOrg);
                employeeMatchDTO.setCadreType(empCadre == null ? null : empCadre.getDynamicObject("cadretype"));
                employeeMatchDTO.setIsCadre(empCadre == null ? "false" : empCadre.getString("iscadre"));
                employeeMatchDTO.setPositionType(depEmp.getString("apositiontype"));
                employeeMatchDTO.setPosition(depEmp.getDynamicObject("position"));
                employeeMatchDTO.setStdPosition(depEmp.getDynamicObject("stdposition"));
                boolean isMatch = this.employeeMatchLogic(employeeMatchDTO, manOrgRangeList);
                if (isMatch) {
                    matchEmployeeMatchDTOList.add(employeeMatchDTO);
                }
            }
            if ((double)count >= numberOfOnce * (double)feedBackNumber) {
                this.feedbackProgress(100 * count / depEmps.length, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c", (String)"FilPerRuleTask_1", (String)"sihc-soefam-business", (Object[])new Object[0]), null);
                ++feedBackNumber;
                this.checkIsStop();
            }
            ++count;
        }
        return matchEmployeeMatchDTOList;
    }

    public boolean employeeMatchLogic(EmployeeMatchDTO employeeMatchDTO, DynamicObject[] manOrgRangeList) {
        for (DynamicObject manOrgRange : manOrgRangeList) {
            if (this.cadreGroupMatchLogic(employeeMatchDTO, manOrgRange)) {
                return true;
            }
            if (!this.specialGroupMatchLogic(employeeMatchDTO, manOrgRange)) continue;
            return true;
        }
        return false;
    }

    public boolean cadreGroupMatchLogic(EmployeeMatchDTO employeeMatchDTO, DynamicObject manOrgRange) {
        DynamicObjectCollection cadreGroupEntry = manOrgRange.getDynamicObjectCollection("cadregroupentry");
        for (DynamicObject cadreGroup : cadreGroupEntry) {
            DynamicObjectCollection cadreEntry;
            boolean isOrgMatch = false;
            boolean isCadreType = false;
            boolean isJobLevel = false;
            boolean isJobGrade = false;
            boolean isCadre = false;
            DynamicObjectCollection cadreOrgEntry = cadreGroup.getDynamicObjectCollection("cadreorgentry");
            DynamicObject adminOrg = employeeMatchDTO.getAdminOrg();
            if (adminOrg != null) {
                for (DynamicObject cadreOrg : cadreOrgEntry) {
                    long admOrgId;
                    DynamicObject cadreAdmOrg = cadreOrg.getDynamicObject("cadreadmorg");
                    String cadreIncludeSub = cadreOrg.getString("cadreincludesub");
                    if ("true".equals(cadreIncludeSub)) {
                        String structNumber;
                        String structLongNumber = adminOrg.getString("structlongnumber");
                        if (!structLongNumber.contains(structNumber = cadreAdmOrg.getString("structnumber"))) continue;
                        isOrgMatch = true;
                        break;
                    }
                    long adminOrgId = adminOrg.getLong("id");
                    if (adminOrgId != (admOrgId = cadreAdmOrg.getLong("id"))) continue;
                    isOrgMatch = true;
                    break;
                }
            }
            if ((cadreEntry = cadreGroup.getDynamicObjectCollection("cadreentry")).size() > 0) {
                DynamicObjectCollection cadreCategorys = ((DynamicObject)cadreEntry.get(0)).getDynamicObjectCollection("cadrecategory");
                String cadreNoLimit = ((DynamicObject)cadreEntry.get(0)).getString("cadrenolimit");
                DynamicObject cadreType = employeeMatchDTO.getCadreType();
                if (cadreType != null) {
                    if ("true".equals(cadreNoLimit)) {
                        isCadreType = true;
                    } else {
                        for (DynamicObject cadreCategory : cadreCategorys) {
                            long cadreTypeId;
                            long cadreCategoryId = cadreCategory.getLong("fbasedataid.id");
                            if (cadreCategoryId != (cadreTypeId = cadreType.getLong("id"))) continue;
                            isCadreType = true;
                            break;
                        }
                    }
                }
                DynamicObjectCollection cadreJobLevels = ((DynamicObject)cadreEntry.get(0)).getDynamicObjectCollection("cadrejoblevel");
                String cadreJobLevelNoLimit = ((DynamicObject)cadreEntry.get(0)).getString("cadrejoblevelnolimit");
                DynamicObject jobLevel = employeeMatchDTO.getJobLevel();
                if ("true".equals(cadreJobLevelNoLimit)) {
                    isJobLevel = true;
                } else if (jobLevel != null) {
                    for (DynamicObject cadreJobLevel : cadreJobLevels) {
                        long jobLevelId;
                        long cadreJobLevelId = cadreJobLevel.getLong("fbasedataid.id");
                        if (cadreJobLevelId != (jobLevelId = jobLevel.getLong("id"))) continue;
                        isJobLevel = true;
                        break;
                    }
                }
                DynamicObjectCollection cadreJobGrades = ((DynamicObject)cadreEntry.get(0)).getDynamicObjectCollection("cadrejobgrade");
                String cadreJobGradeNoLimit = ((DynamicObject)cadreEntry.get(0)).getString("cadrejobgradenolimit");
                DynamicObject jobGrade = employeeMatchDTO.getJobGrade();
                if ("true".equals(cadreJobGradeNoLimit)) {
                    isJobGrade = true;
                } else if (jobGrade != null) {
                    for (DynamicObject cadreJobGrade : cadreJobGrades) {
                        long jobGradeId;
                        long cadreJobGradeId = cadreJobGrade.getLong("fbasedataid.id");
                        if (cadreJobGradeId != (jobGradeId = jobGrade.getLong("id"))) continue;
                        isJobGrade = true;
                        break;
                    }
                }
                if ("true".equals(employeeMatchDTO.getIsCadre())) {
                    isCadre = true;
                }
            }
            if (!isOrgMatch || !isCadreType || !isJobLevel || !isJobGrade || !isCadre) continue;
            employeeMatchDTO.setManOrgRange(manOrgRange);
            employeeMatchDTO.setRecPersonType(1010L);
            return true;
        }
        return false;
    }

    public boolean specialGroupMatchLogic(EmployeeMatchDTO employeeMatchDTO, DynamicObject manOrgRange) {
        DynamicObjectCollection specialGroupEntry = manOrgRange.getDynamicObjectCollection("specialgroupentry");
        for (DynamicObject specialGroup : specialGroupEntry) {
            DynamicObjectCollection specialEntry;
            boolean isOrgMatch = false;
            boolean isPositionType = false;
            boolean isJobLevel = false;
            boolean isJobGrade = false;
            boolean isNotCadre = false;
            DynamicObjectCollection specialOrgEntry = specialGroup.getDynamicObjectCollection("specialorgentry");
            DynamicObject adminOrg = employeeMatchDTO.getAdminOrg();
            if (adminOrg != null) {
                for (DynamicObject specialOrg : specialOrgEntry) {
                    long admOrgId;
                    DynamicObject specialAdmOrg = specialOrg.getDynamicObject("specialadmorg");
                    String specialIncludeSub = specialOrg.getString("specialincludesub");
                    if ("true".equals(specialIncludeSub)) {
                        String structNumber;
                        String structLongNumber = adminOrg.getString("structlongnumber");
                        if (!structLongNumber.contains(structNumber = specialAdmOrg.getString("structnumber"))) continue;
                        isOrgMatch = true;
                        break;
                    }
                    long adminOrgId = adminOrg.getLong("id");
                    if (adminOrgId != (admOrgId = specialAdmOrg.getLong("id"))) continue;
                    isOrgMatch = true;
                    break;
                }
            }
            if ((specialEntry = specialGroup.getDynamicObjectCollection("specialentry")).size() > 0) {
                String positionType;
                String specialPositionType = ((DynamicObject)specialEntry.get(0)).getString("positiontype");
                if (specialPositionType.equals(positionType = employeeMatchDTO.getPositionType())) {
                    String positionTypeNoLimit = ((DynamicObject)specialEntry.get(0)).getString("positiontypenolimit");
                    if ("true".equals(positionTypeNoLimit)) {
                        isPositionType = true;
                    } else if ("0".equals(specialPositionType)) {
                        DynamicObjectCollection specialStPositions = ((DynamicObject)specialEntry.get(0)).getDynamicObjectCollection("stposition");
                        DynamicObject stdPosition = employeeMatchDTO.getStdPosition();
                        if (stdPosition != null) {
                            for (DynamicObject specialStPosition : specialStPositions) {
                                long stdPositionId;
                                long specialStPositionId = specialStPosition.getLong("fbasedataid.id");
                                if (specialStPositionId != (stdPositionId = stdPosition.getLong("id"))) continue;
                                isPositionType = true;
                                break;
                            }
                        }
                    } else if ("1".equals(specialPositionType)) {
                        DynamicObjectCollection specialPositions = ((DynamicObject)specialEntry.get(0)).getDynamicObjectCollection("position");
                        DynamicObject position = employeeMatchDTO.getPosition();
                        if (position != null) {
                            for (DynamicObject specialPosition : specialPositions) {
                                long positionId;
                                long specialPositionId = specialPosition.getLong("fbasedataid.id");
                                if (specialPositionId != (positionId = position.getLong("id"))) continue;
                                isPositionType = true;
                                break;
                            }
                        }
                    } else if ("2".equals(specialPositionType)) {
                        DynamicObjectCollection specialJobs = ((DynamicObject)specialEntry.get(0)).getDynamicObjectCollection("job");
                        DynamicObject job = employeeMatchDTO.getJob();
                        if (job != null) {
                            for (DynamicObject specialJob : specialJobs) {
                                long jobId;
                                long specialJobId = specialJob.getLong("fbasedataid.id");
                                if (specialJobId != (jobId = job.getLong("id"))) continue;
                                isPositionType = true;
                                break;
                            }
                        }
                    }
                }
                DynamicObjectCollection specialJobLevels = ((DynamicObject)specialEntry.get(0)).getDynamicObjectCollection("joblevel");
                String jobLevelNoLimit = ((DynamicObject)specialEntry.get(0)).getString("joblevelnolimit");
                DynamicObject jobLevel = employeeMatchDTO.getJobLevel();
                if ("true".equals(jobLevelNoLimit)) {
                    isJobLevel = true;
                } else if (jobLevel != null) {
                    for (DynamicObject specialJobLevel : specialJobLevels) {
                        long jobLevelId;
                        long specialJobLevelId = specialJobLevel.getLong("fbasedataid.id");
                        if (specialJobLevelId != (jobLevelId = jobLevel.getLong("id"))) continue;
                        isJobLevel = true;
                        break;
                    }
                }
                DynamicObjectCollection specialJobGrades = ((DynamicObject)specialEntry.get(0)).getDynamicObjectCollection("jobgrade");
                String jobGradeNoLimit = ((DynamicObject)specialEntry.get(0)).getString("jobgradenolimit");
                DynamicObject jobGrade = employeeMatchDTO.getJobGrade();
                if ("true".equals(jobGradeNoLimit)) {
                    isJobGrade = true;
                } else if (jobGrade != null) {
                    for (DynamicObject specialJobGrade : specialJobGrades) {
                        long jobGradeId;
                        long specialJobGradeId = specialJobGrade.getLong("fbasedataid.id");
                        if (specialJobGradeId != (jobGradeId = jobGrade.getLong("id"))) continue;
                        isJobGrade = true;
                        break;
                    }
                }
                if ("false".equals(employeeMatchDTO.getIsCadre())) {
                    isNotCadre = true;
                }
            }
            if (!isOrgMatch || !isPositionType || !isJobLevel || !isJobGrade || !isNotCadre) continue;
            employeeMatchDTO.setManOrgRange(manOrgRange);
            employeeMatchDTO.setRecPersonType(1020L);
            return true;
        }
        return false;
    }

    public void dispatchRuleTask(String ruleType, List<Long> manageOrgIds, List<Long> employeeIds, IFormView view) {
        LOGGER.info("FilPerRuleTask.dispatchRuleTask.ruleType:{},manageOrgIds:{},employeeIds:{}", new Object[]{ruleType, manageOrgIds, employeeIds});
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("soefam");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(ResManager.loadKDString((String)"\u6267\u884c\u5916\u4e8b\u7ba1\u7406\u8303\u56f4\u89c4\u5219", (String)"FilPerRuleTask_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.sihc.soefam.business.task.FilPerRuleTask");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("ruleType", ruleType);
        params.put("manageOrgIds", manageOrgIds);
        params.put("employeeIds", employeeIds);
        jobInfo.setParams(params);
        if ("2".equals(ruleType)) {
            ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        } else {
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u5916\u4e8b\u7ba1\u7406\u8303\u56f4\u89c4\u5219", (String)"FilPerRuleTask_0", (String)"sihc-soefam-business", (Object[])new Object[0]));
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setClickClassName("kd.sihc.soefam.business.task.FilPerRuleClickTask");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)view);
        }
    }
}

