/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.Pair;
import kd.sihc.soefam.business.application.external.task.SscTaskExternalService;
import kd.sihc.soefam.business.application.external.task.SscTaskQueryServiceHelper;
import kd.sihc.soefam.common.utils.BaseDataConfigUtil;

public class SscTaskService {
    private static final Log LOG = LogFactory.getLog(SscTaskService.class);

    public static List<Long> shareTaskHandle(List<Long> billIds, String pageSource, String entityNumber) {
        boolean openHrSsc = BaseDataConfigUtil.getOpenHrSsc();
        if (!openHrSsc) {
            return Lists.newArrayListWithExpectedSize((int)2);
        }
        LOG.info("SscTaskService.shareTaskHandle.billIds:{}", billIds);
        Pair<Map<Long, Long>, Map<Long, Long>> tasks = SscTaskQueryServiceHelper.getTasksByBillId(billIds, entityNumber);
        Map toAllocationTaskMap = (Map)tasks.getKey();
        Map processTaskMap = (Map)tasks.getValue();
        LOG.info("SscTaskService.shareTaskHandle.toAllocationTaskMap:{}", (Object)toAllocationTaskMap);
        LOG.info("SscTaskService.shareTaskHandle.processTaskMap:{}", (Object)processTaskMap);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        ArrayList paramList = new ArrayList(10);
        if ("1".equals(pageSource)) {
            processTaskMap.forEach((taskId, personId) -> {
                HashMap<String, Long> certMap = new HashMap<String, Long>(16);
                certMap.put("taskId", (Long)taskId);
                certMap.put("currentPersonId", (Long)personId);
                paramList.add(certMap);
            });
            paramMap.put("list", paramList);
            LOG.info("SscTaskService.shareTaskHandle.complete.paramMap:{}", paramMap);
            Map<String, Object> completeResultMap = SscTaskExternalService.taskApproveByComplete(paramMap);
            LOG.info("SscTaskService.shareTaskHandle.complete.completeResultMap:{}", completeResultMap);
        } else {
            toAllocationTaskMap.forEach((taskId, personId) -> {
                HashMap<String, Long> certMap = new HashMap<String, Long>(16);
                certMap.put("taskId", (Long)taskId);
                certMap.put("currentPersonId", UserServiceHelper.getCurrentUserId());
                paramList.add(certMap);
            });
            paramMap.put("list", paramList);
            LOG.info("SscTaskService.shareTaskHandle.delete.paramMap:{}", paramMap);
            Map<String, Object> deleteResultMap = SscTaskExternalService.taskDeleteByTaskId(paramMap);
            LOG.info("SscTaskService.shareTaskHandle.delete.deleteResultMap:{}", deleteResultMap);
            paramMap.clear();
            paramList.clear();
            processTaskMap.forEach((taskId, personId) -> {
                HashMap<String, Long> certMap = new HashMap<String, Long>(16);
                certMap.put("taskId", (Long)taskId);
                certMap.put("currentPersonId", (Long)personId);
                certMap.put("operatorId", UserServiceHelper.getCurrentUserId());
                paramList.add(certMap);
            });
            paramMap.put("list", paramList);
            LOG.info("SscTaskService.shareTaskHandle.terminate.paramMap:{}", paramMap);
            Map<String, Object> terminateResultMap = SscTaskExternalService.taskApproveByTerminate(paramMap);
            LOG.info("SscTaskService.shareTaskHandle.terminate.terminateResultMap:{}", terminateResultMap);
        }
        return new ArrayList<Long>(processTaskMap.keySet());
    }
}

