/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;

public class CertInfoDetPlugin
extends AbstractFormPlugin
implements CertificateConstants {
    private static final Log LOG = LogFactory.getLog(CertInfoDetPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        List<DynamicObject> dynamicObjectList = this.queryPermission();
        this.initEntity(dynamicObjectList);
    }

    private void initEntity(List<DynamicObject> dynamicObjects) {
        this.getView().getModel().deleteEntryData("entryentity");
        this.getModel().setValue("certnum", (Object)dynamicObjects.size());
        int notinNum = 0;
        int inNum = 0;
        int outNum = 0;
        if (!ObjectUtils.isEmpty(dynamicObjects)) {
            this.getView().getModel().batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int num = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                long fid = dynamicObject.getLong("id");
                this.getView().getModel().setValue("fid", (Object)fid, num);
                if (dynamicObject.getDynamicObject("certinfo") != null) {
                    this.getView().getModel().setValue("certnumber", (Object)dynamicObject.getDynamicObject("certinfo").getString("certnumber"), num);
                    this.getView().getModel().setValue("signorg", (Object)dynamicObject.getDynamicObject("certinfo").getString("signorg"), num);
                    Date signDate = dynamicObject.getDynamicObject("certinfo").getDate("signdate");
                    Date perValDate = dynamicObject.getDynamicObject("certinfo").getDate("pervaldate");
                    try {
                        if (signDate != null) {
                            this.getView().getModel().setValue("signdate", (Object)HRDateTimeUtils.format((Date)signDate), num);
                        }
                        if (perValDate != null) {
                            this.getView().getModel().setValue("pervaldate", (Object)HRDateTimeUtils.format((Date)perValDate), num);
                        }
                    }
                    catch (Exception exception) {
                        String exceptionMeg = ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01", (String)"CertInfoDetPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
                        throw new KDException((Throwable)exception, new ErrorCode("CertInfoDetPlugin", exceptionMeg), new Object[0]);
                    }
                    this.getView().getModel().setValue("remarks", (Object)dynamicObject.getDynamicObject("certinfo").getString("remarks"), num);
                    this.getView().getModel().setValue("effectivestatus", (Object)dynamicObject.getDynamicObject("certinfo").getString("effectivestatus"), num);
                }
                this.getView().getModel().setValue("stockstatus", (Object)dynamicObject.getString("stockstatus"), num);
                this.getView().getModel().setValue("concerttype", dynamicObject.getDynamicObject("concerttype") == null ? null : dynamicObject.getDynamicObject("concerttype").get("id"), num);
                ++num;
                if (CertStockStatusEnum.STATUS_NOTIN.getKey().equals(dynamicObject.getString("stockstatus"))) {
                    ++notinNum;
                    continue;
                }
                if (CertStockStatusEnum.STATUS_IN.getKey().equals(dynamicObject.getString("stockstatus")) || CertStockStatusEnum.STATUS_TOOUT.getKey().equals(dynamicObject.getString("stockstatus"))) {
                    ++inNum;
                    continue;
                }
                if (!CertStockStatusEnum.STATUS_OUT.getKey().equals(dynamicObject.getString("stockstatus"))) continue;
                ++outNum;
            }
        }
        this.setLabVisible(notinNum, inNum, outNum);
    }

    private void setLabVisible(int notinNum, int inNum, int outNum) {
        this.getModel().setValue("notinnum", (Object)notinNum);
        this.getModel().setValue("innum", (Object)inNum);
        this.getModel().setValue("outnum", (Object)outNum);
    }

    private List<DynamicObject> queryPermission() {
        CertificateQueryService certificateQueryService = new CertificateQueryService();
        List personIds = (List)this.getView().getFormShowParameter().getCustomParam("id");
        LOG.info("CertinfodetPlugin info queryPermission fail , personIds is not exist {} ", (Object)personIds);
        DynamicObject[] dynamicObjects = certificateQueryService.queryPermissionByFilPerson(personIds);
        List<Object> dynamicObjectList = Arrays.asList(dynamicObjects);
        dynamicObjectList = dynamicObjectList.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDynamicObject("certinfo") == null)).collect(Collectors.toList());
        return dynamicObjectList;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"checkboxfield", (CharSequence)name)) {
            Boolean newValue1 = (Boolean)newValue;
            List<Object> dynamicObjectList = this.queryPermission();
            if (newValue1.booleanValue()) {
                dynamicObjectList = dynamicObjectList.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("certinfo") != null && "1".equals(dynamicObject.getDynamicObject("certinfo").get("effectivestatus"))).collect(Collectors.toList());
            }
            this.initEntity(dynamicObjectList);
        }
    }
}

