/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.domain.certificate.CertificateOutRegDomainService;
import kd.sihc.soefam.business.formservice.CertificateserFormService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.constants.certificate.CertificateOutRegConstants;

public class CertOutRegBoxPlugin
extends SoeAbstractFormPlugin
implements CertificateConstants,
CertificateOutRegConstants,
TipsListener {
    private static final CertificateserFormService CERTIFICATESERFORMSERVICE = (CertificateserFormService)ServiceFactory.getService(CertificateserFormService.class);
    private static final FilPersonListFormService FIL_PERSON_LIST_FORM_SERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final CertificateOutRegDomainService CERTIFICATEOUTREGDOMAINSERVICE = CertificateOutRegDomainService.init();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"batch"});
        Button batch = (Button)this.getControl("batch");
        batch.addTipsListener((TipsListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.entryAssignment();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("deleteentry".equals(operate.getOperateKey()) && (entryEntity = FIL_PERSON_LIST_FORM_SERVICE.checkEntityRow(this.getView(), "entryentity"))) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("addline".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List certificateIds = entryEntity.stream().map(entry -> entry.getLong("certificateentity.id")).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "not in", certificateIds);
            filter.and(new QFilter("stockstatus", "=", (Object)"C"));
            ListShowParameter certificateShowParam = CERTIFICATESERFORMSERVICE.getCertificateListShowParameter(new CloseCallBack((IFormPlugin)this, "close_addcertifcate"), ResManager.loadKDString((String)"\u5f85\u51fa\u5e93\u8bc1\u7167", (String)"CertOutRegBoxPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), filter);
            certificateShowParam.setCustomParam("isShowCertNumber", (Object)"1");
            this.getView().showForm((FormShowParameter)certificateShowParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("close_addcertifcate".equals(actionId) && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            List ids = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
            this.getView().getFormShowParameter().setCustomParam("idList", ids);
            this.entryAssignment();
        }
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            eventArgs.setOperationKey("outreg");
            eventArgs.setEntityNumber("soefam_certificate");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            List certificateIdList = entity.stream().map(obj -> obj.getLong("certificateentity.id")).collect(Collectors.toList());
            eventArgs.setIds(certificateIdList.toArray());
        }
    }

    public void updateOperationResult(OperationResult operationResult, String operationKey) {
        super.updateOperationResult(operationResult, operationKey);
        if (operationResult == null || operationResult.getBillCount() == 1) {
            return;
        }
        ArrayList pkValueList = Lists.newArrayListWithCapacity((int)operationResult.getBillCount());
        Optional.ofNullable(operationResult.getAllErrorOrValidateInfo()).ifPresent(errorValidate -> errorValidate.forEach(result -> {
            OperateInfo operateInfo = (OperateInfo)result;
            Object pkValue = operateInfo.getPkValue();
            pkValueList.add(pkValue);
        }));
        CERTIFICATEMGDOMAINSERVICE.updateOperationResult(operationResult, pkValueList.toArray());
    }

    public void doRemoveFailRow(OperationResult operationResult, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.doRemoveFailRow(operationResult, afterDoOperationEventArgs);
        if ("sihc_precheck".equals(afterDoOperationEventArgs.getOperateKey())) {
            Map successIdMap = operationResult.getSuccessPkIds().stream().collect(Collectors.toMap(obj -> obj, Function.identity(), (v1, v2) -> v1));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            dynamicObjectCollection.removeIf(nextObj -> !successIdMap.containsKey(nextObj.getDynamicObject("certificateentity").get("id")));
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("confirm");
    }

    public void beforeShowTips(BeforeShowTipsEvent beforeShowTipsEvent) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CertificateInRegPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            beforeShowTipsEvent.setCancel(true);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void entryAssignment() {
        DynamicObject[] dynamicObjects = CERTIFICATEOUTREGDOMAINSERVICE.getCertificateArray(this.getView());
        int rows = this.getModel().getEntryRowCount("entryentity");
        try {
            for (DynamicObject dynamicObject : dynamicObjects) {
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("certificateentity", (Object)dynamicObject, rows);
                this.getModel().setValue("filpermanage", dynamicObject.get("filperson"), rows);
                DynamicObject certInfo = dynamicObject.getDynamicObject("certinfo");
                if (certInfo != null) {
                    this.getModel().setValue("certnumber", certInfo.get("certnumber"), rows);
                }
                ++rows;
            }
        }
        catch (Exception e) {
            this.getModel().deleteEntryRow("entryentity", rows);
        }
    }
}

