/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.common.constants.CommonPageConstants;

public class CertificateBatchConfigPlugin
extends AbstractFormPlugin
implements CommonPageConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        String key = bt.getKey();
        if (key.equals("btnok")) {
            IFormView parentView = this.getView().getParentView();
            String formId = parentView.getFormShowParameter().getFormId();
            IDataModel parentModel = parentView.getModel();
            EntryGrid entryGrid = (EntryGrid)parentView.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entryEntity = parentModel.getDataEntity(true).getDynamicObjectCollection("entryentity");
            switch (formId) {
                case "soefam_certinregbox": {
                    this.batchFill(Arrays.asList("remark", "storagedate", "storagelocation", "onfilenum"), selectRows, entryEntity);
                    break;
                }
                case "soefam_certlentoutregbox": {
                    this.batchFill(Arrays.asList("remark", "lenddate", "receiver"), selectRows, entryEntity);
                    break;
                }
                case "soefam_certreturnregbox": {
                    this.batchFill(Arrays.asList("remark", "returndate", "goabroad"), selectRows, entryEntity);
                    break;
                }
                case "soefam_certreplaceregbox": {
                    this.batchFill(Arrays.asList("replacedate", "newonfilenum", "remark"), selectRows, entryEntity);
                    break;
                }
                case "soefam_certoutregbox": {
                    this.batchFill(Arrays.asList("outdate", "receiver", "remark", "outreason"), selectRows, entryEntity);
                    break;
                }
                case "soefam_certoverregbox": {
                    this.batchFill(Collections.singletonList("remark"), selectRows, entryEntity);
                    break;
                }
                case "soefam_certnotinregbox": {
                    this.batchFill(Arrays.asList("nostorereason", "remark"), selectRows, entryEntity);
                }
            }
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void batchFill(List<String> fieldList, int[] selectRows, DynamicObjectCollection entryEntity) {
        for (int index = 0; index < selectRows.length; ++index) {
            for (String field : fieldList) {
                if (null == this.getModel().getValue(field) || HRStringUtils.isEmpty((String)this.getModel().getValue(field).toString()) || HRStringUtils.isEmpty((String)this.getModel().getValue(field).toString().trim())) continue;
                ((DynamicObject)entryEntity.get(selectRows[index])).set(field, this.getModel().getValue(field));
                this.getView().getParentView().updateView(field, selectRows[index]);
            }
        }
    }
}

