/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Image;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonConstants;
import kd.sihc.soefam.formplugin.web.filingspersonmg.FilPersonManageInfoHeadPlugin;

public class CertificateDetHeadPlugin
extends AbstractFormPlugin
implements CertificateConstants,
FilPersonConstants {
    private static final Log LOG = LogFactory.getLog(FilPersonManageInfoHeadPlugin.class);
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = (FilPersonQueryService)ServiceFactory.getService(FilPersonQueryService.class);

    public void beforeBindData(EventObject eventObject) {
        Long certId;
        DynamicObject[] dynamicObjects;
        super.beforeBindData(eventObject);
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("map");
        Long personId = (Long)map.get("personId");
        LOG.info("certificateDetHead info beforeBindData fail , filpersonId is not exist {} ", (Object)personId);
        DynamicObject personMgObj = FIL_PERSON_QUERY_SERVICE.getFilPersonByPerIndexId(personId);
        Image image = (Image)this.getControl("userphoto");
        if (personMgObj != null) {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)personMgObj.getString("person.headsculpture")));
            try {
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonBaseInfo", (Object[])new Object[]{personMgObj.getLong("person.id")});
                this.getModel().setValue("gender", resultMap.get("gender"));
            }
            catch (Exception ex) {
                LOG.error("FilPersonManageInfoHeadPlugin.beforeBindData error ", (Throwable)ex);
            }
            this.getModel().setValue("company", (Object)personMgObj.getString("empposorgrel.company.name"));
            this.getModel().setValue("department", (Object)personMgObj.getString("empposorgrel.adminorg.name"));
            this.getModel().setValue("job", (Object)personMgObj.getString("empposorgrel.position.name"));
            this.getModel().getDataEntity().set("filingspersonbase", (Object)personMgObj);
            if (StringUtils.isEmpty((CharSequence)personMgObj.getString("recpersontype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"recpersontypefle"});
            }
            if (StringUtils.isEmpty((CharSequence)personMgObj.getString("filingstatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"filingstatusfle"});
            }
        }
        if ((dynamicObjects = CERTIFICATE_QUERY_SERVICE.queryById("stockstatus", Collections.singletonList(certId = (Long)map.get("certId")))) != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            this.getView().getModel().setValue("stockstatus", (Object)dynamicObject.getString("stockstatus"));
        }
        this.getView().getModel().setValue("concerttype", map.get("concertTypeId"));
    }
}

