/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;

public class CertificateDetPlugin
extends SoeAbstractFormPlugin
implements CertificateConstants {
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if ("hstc".equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"checkboxfield"});
        }
        DynamicObject[] dynamicObjects = this.queryPermission();
        List<DynamicObject> dynamicObjectList = Arrays.asList(dynamicObjects);
        this.initEntity(dynamicObjectList);
    }

    private void initEntity(List<DynamicObject> dynamicObjects) {
        this.getView().getModel().deleteEntryData("entryentity");
        if (!ObjectUtils.isEmpty(dynamicObjects)) {
            this.getView().getModel().batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int num = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                long fid = dynamicObject.getLong("id");
                this.getView().getModel().setValue("fid", (Object)fid, num);
                this.getView().getModel().setValue("certnumber", (Object)dynamicObject.getString("certnumber"), num);
                this.getView().getModel().setValue("signorg", (Object)dynamicObject.getString("signorg"), num);
                this.getView().getModel().setValue("signdate", (Object)dynamicObject.getDate("signdate"), num);
                this.getView().getModel().setValue("pervaldate", (Object)dynamicObject.getDate("pervaldate"), num);
                this.getView().getModel().setValue("remarks", (Object)dynamicObject.getString("remarks"), num);
                this.getView().getModel().setValue("effectivestatus", (Object)dynamicObject.getString("effectivestatus"), num);
                this.getView().getModel().setValue("concerttype", dynamicObject.getDynamicObject("certificate").getDynamicObject("concerttype") == null ? null : dynamicObject.getDynamicObject("certificate").getDynamicObject("concerttype").get("id"), num);
                ++num;
            }
        }
    }

    private DynamicObject[] queryPermission() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("map");
        Long certId = (Long)map.get("certId");
        return CERTIFICATE_QUERY_SERVICE.queryAllCertInfoByCertificateIds(certId);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"edit"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        if ("savecertinfo".equals(actionId) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            view.invokeOperation("refresh");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CertificateDetPlugin.setSlidePreviewForm(this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "donothing_edit".equals(operateKey)) {
            Long fid = (Long)this.getView().getModel().getValue("fid");
            DynamicObject dynamicObject = CERTIFICATE_QUERY_SERVICE.queryCertInfoByFid(fid);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CertificateDetPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                return;
            }
            String pageId = this.getView().getPageId();
            IAppCache iAppCache = AppCache.get((String)"cache_soefam_editinfo");
            iAppCache.put("fid", (Object)fid);
            iAppCache.put("pageId", (Object)pageId);
            CertificateDetPlugin.showSlidePreviewForm(this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"checkboxfield", (CharSequence)name)) {
            Boolean newValue1 = (Boolean)newValue;
            DynamicObject[] dynamicObjects = this.queryPermission();
            List<Object> dynamicObjectList = Arrays.asList(dynamicObjects);
            if (newValue1.booleanValue()) {
                dynamicObjectList = dynamicObjectList.stream().filter(dynamicObject -> dynamicObject != null && "1".equals(dynamicObject.get("effectivestatus"))).collect(Collectors.toList());
            }
            this.initEntity(dynamicObjectList);
        }
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            eventArgs.setOperationKey("edit");
            eventArgs.setEntityNumber("soefam_certificate");
            Map map = (Map)this.getView().getFormShowParameter().getCustomParam("map");
            Long certId = (Long)map.get("certId");
            ArrayList<Long> certificateIdList = new ArrayList<Long>(1);
            if (certId != null) {
                certificateIdList.add(certId);
            }
            eventArgs.setIds(certificateIdList.toArray());
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("donothing_edit");
    }

    public static void setSlidePreviewForm(IFormView iFormView) {
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("dc", "top");
        map.put("formId", "soefam_certificateser");
        map.put("offset", 0);
        proxy.addAction("setSlideBillFormId", map);
    }

    public static void showSlidePreviewForm(IFormView iFormView) {
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("formId", "soefam_certificateser");
        map.put("show", "false");
        proxy.addAction("showSlideBill", map);
    }
}

