/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.AnimationType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.domain.certificate.CertificateDomainService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;

public class CertificateDetailsPlugin
extends AbstractFormPlugin
implements CertificateConstants {
    private static final CertificateDomainService CERTIFICATE_DOMAIN_SERVICE = (CertificateDomainService)ServiceFactory.getService(CertificateDomainService.class);
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("soefam_certificate");
    private static final Log LOG = LogFactory.getLog(CertificateDetailsPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BaseShowParameter baseShowParameter = (BaseShowParameter)args.getFormShowParameter();
        Object pkId = baseShowParameter.getPkId();
        LOG.info("CertificateDetailsPlugin.preOpenForm.pkId:{}", pkId);
        DynamicObject dynamicObject = SERVICE_HELPER.queryOne("filperson", (Object)Long.valueOf(pkId.toString()));
        String tileName = ResManager.loadKDString((String)"\u8bc1\u7167\u8be6\u60c5-{0}", (String)"CertificateDetailsPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        if (dynamicObject != null) {
            String name = dynamicObject.getString("filperson.person.name");
            tileName = MessageFormat.format(tileName, name);
        }
        args.getFormShowParameter().setCaption(tileName);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if ("hstc".equals(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"savestoplace", "cancel"});
        this.initHead();
        this.initCertificate();
        this.initForeignRecords();
        this.initRegRecords();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"storageplace"});
        Object storagePlace = this.getView().getModel().getValue("storageplace");
        this.getView().getPageCache().put("storagePlaceCache", storagePlace == null ? "" : storagePlace.toString());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"onfilenum"});
        Object onFileNum = this.getView().getModel().getValue("onfilenum");
        this.getView().getPageCache().put("onFileNumCache", onFileNum == null ? "" : onFileNum.toString());
    }

    private void initRegRecords() {
        FormShowParameter headForm = new FormShowParameter();
        headForm.setFormId("soefam_certregrecord");
        headForm.getOpenStyle().setShowType(ShowType.InContainer);
        headForm.getOpenStyle().setTargetKey("certregrecord");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Long certId = dataEntity.getLong("id");
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        map.put("certId", certId == 0L ? null : certId);
        headForm.setCustomParam("map", map);
        this.getView().showForm(headForm);
    }

    private void initHead() {
        FormShowParameter headForm = new FormShowParameter();
        headForm.setFormId("soefam_certificatedethead");
        headForm.getOpenStyle().setShowType(ShowType.InContainer);
        headForm.getOpenStyle().setTargetKey("certhead");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Long concertTypeId = dataEntity.getLong("concerttype.id");
        Long personId = dataEntity.getLong("filperson.person.id");
        Long certId = dataEntity.getLong("id");
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        map.put("personId", personId == 0L ? null : personId);
        map.put("certId", certId == 0L ? null : certId);
        map.put("concertTypeId", concertTypeId == 0L ? null : concertTypeId);
        headForm.setCustomParam("map", map);
        this.getView().showForm(headForm);
    }

    private void initCertificate() {
        FormShowParameter headForm = new FormShowParameter();
        headForm.setFormId("soefam_certificatedet");
        headForm.getOpenStyle().setShowType(ShowType.InContainer);
        headForm.getOpenStyle().setTargetKey("certinfoflex");
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Long certId = dataEntity.getLong("id");
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        map.put("certId", certId == 0L ? null : certId);
        headForm.setCustomParam("map", map);
        this.getView().showForm(headForm);
    }

    private void initForeignRecords() {
        FormShowParameter headForm = new FormShowParameter();
        headForm.setFormId("soefam_certificatedetfrec");
        headForm.getOpenStyle().setShowType(ShowType.InContainer);
        headForm.getOpenStyle().setTargetKey("foreignrecords");
        headForm.setAnimationType(AnimationType.none);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        Long personId = dataEntity.getLong("person.id");
        Long certId = dataEntity.getLong("id");
        HashMap<String, Long> map = new HashMap<String, Long>(8);
        map.put("personId", personId == 0L ? null : personId);
        map.put("certId", certId == 0L ? null : certId);
        headForm.setCustomParam("map", map);
        this.getView().showForm(headForm);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"savestoplace"});
        this.addClickListeners(new String[]{"edit"});
        this.addClickListeners(new String[]{"cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("cancel".equals(controlKey)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"storageplace"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"onfilenum"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"savestoplace", "cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"edit"});
            String storagePlaceCache = this.getView().getPageCache().get("storagePlaceCache");
            this.getView().getModel().setValue("storageplace", (Object)storagePlaceCache);
            String onFileNumCache = this.getView().getPageCache().get("onFileNumCache");
            this.getView().getModel().setValue("onfilenum", (Object)onFileNumCache);
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("donothing_stoedit".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"storageplace"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"onfilenum"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"savestoplace", "cancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
        } else if ("savedonothing".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            Object storagePlace = this.getView().getModel().getValue("storageplace");
            Object onFileNum = this.getView().getModel().getValue("onfilenum");
            this.getView().getPageCache().put("storagePlaceCache", storagePlace.toString());
            this.getView().getPageCache().put("onFileNumCache", onFileNum.toString());
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            dataEntity.set("storageplace", storagePlace);
            CERTIFICATE_DOMAIN_SERVICE.saveCertificate(new DynamicObject[]{dataEntity});
            this.getView().setEnable(Boolean.FALSE, new String[]{"storageplace"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"onfilenum"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"savestoplace", "cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"edit"});
        }
    }
}

