/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soefam.business.application.external.PrintTemplateExternalService;
import kd.sihc.soefam.business.domain.certificate.CertificateInRegDomainService;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.formservice.CertificateserFormService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertificateInRegPlugin
extends SoeAbstractFormPlugin
implements TabSelectListener,
TipsListener {
    private static final CertificateserFormService CERTIFICATESERFORMSERVICE = (CertificateserFormService)ServiceFactory.getService(CertificateserFormService.class);
    private static final CertificateInRegDomainService CERTIFICATEINREGDOMAINSERVICE = CertificateInRegDomainService.init();
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final FilPersonListFormService FIL_PERSON_LIST_FORM_SERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"certnumber", "btnok", "cancelreg", "okreg", "batch", "flexpanelap42"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Button batch = (Button)this.getControl("batch");
        batch.addTipsListener((TipsListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("certnumber".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabinreg", "flexprompt"});
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabinreg");
            this.getView().setEnable(Boolean.FALSE, new String[]{"tabinstorage"});
            this.tabInReg();
            int currentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
            String concerttype = ((DynamicObject)this.getView().getModel().getEntryEntity("entryentity").get(currentRowIndex)).getDynamicObject("certificateentity").getLocaleString("concerttype.name").getLocaleValue();
            TabPage control = (TabPage)this.getView().getControl("tabinreg");
            control.setText(new LocaleString(concerttype));
            this.setCertModify(currentRowIndex);
            TextEdit certNumberRegTextEdit = (TextEdit)this.getControl("certnumberreg");
            certNumberRegTextEdit.setMustInput(true);
            DateEdit perValDateRegDateEdit = (DateEdit)this.getControl("pervaldatereg");
            perValDateRegDateEdit.setMustInput(true);
        } else if ("cancelreg".equals(key)) {
            this.tabCutOne();
            TextEdit certNumberRegTextEdit = (TextEdit)this.getControl("certnumberreg");
            certNumberRegTextEdit.setMustInput(false);
            DateEdit perValDateRegDateEdit = (DateEdit)this.getControl("pervaldatereg");
            perValDateRegDateEdit.setMustInput(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("okreg".equals(key) && afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"tabinstorage"});
            this.setEntityModelValue();
            this.tabCutOne();
        } else if ("addline".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List certificateIds = entryEntity.stream().map(entry -> entry.getLong("certificateentity.id")).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "not in", certificateIds);
            filter.and(new QFilter("stockstatus", "=", (Object)"A"));
            ListShowParameter certificateShowParam = CERTIFICATESERFORMSERVICE.getCertificateListShowParameter(new CloseCallBack((IFormPlugin)this, "close_addcertifcate"), ResManager.loadKDString((String)"\u672a\u5165\u5e93\u8bc1\u7167", (String)"CertificateInRegPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), filter);
            this.getView().showForm((FormShowParameter)certificateShowParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("close_addcertifcate".equals(actionId) && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            List ids = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
            this.getView().getFormShowParameter().setCustomParam("idList", ids);
            this.entryAssignment();
        }
    }

    private void tabCutOne() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabinreg", "flexprompt"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabinstorage");
        this.tabInStorage();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabinstorage".equals(tabKey)) {
            this.tabInStorage();
        } else if ("tabinreg".equals(tabKey)) {
            this.tabInReg();
        }
    }

    private void tabInStorage() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"batch", "addline", "deleteline", "batchs", "labinstorage", "labdeleteline", "btncancel", "btnok"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"labconcerttype", "labinreg", "labinregt", "okreg", "cancelreg"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"tabinstorage"});
        this.getModel().setValue("faceimage", null);
    }

    private void tabInReg() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"batch", "addline", "deleteline", "batchs", "labdeleteline", "labinstorage", "btncancel", "btnok"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"labconcerttype", "labinreg", "labinregt", "okreg", "cancelreg"});
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            eventArgs.setOperationKey("regstore");
            eventArgs.setEntityNumber("soefam_certificate");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            eventArgs.setIds(entity.stream().map(obj -> obj.getLong("certificateentity.id")).toArray());
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("confirm");
    }

    public void doRemoveFailRow(OperationResult operationResult, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.doRemoveFailRow(operationResult, afterDoOperationEventArgs);
        if ("sihc_precheck".equals(afterDoOperationEventArgs.getOperateKey())) {
            Map successIdMap = operationResult.getSuccessPkIds().stream().collect(Collectors.toMap(obj -> obj, Function.identity(), (v1, v2) -> v1));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            dynamicObjectCollection.removeIf(nextObj -> !successIdMap.containsKey(nextObj.getDynamicObject("certificateentity").get("id")));
        }
    }

    public void updateOperationResult(OperationResult operationResult, String operationKey) {
        super.updateOperationResult(operationResult, operationKey);
        if (operationResult == null || operationResult.getBillCount() == 1) {
            return;
        }
        ArrayList pkValueList = Lists.newArrayListWithCapacity((int)operationResult.getBillCount());
        Optional.ofNullable(operationResult.getAllErrorOrValidateInfo()).ifPresent(errorValidate -> errorValidate.forEach(result -> {
            OperateInfo operateInfo = (OperateInfo)result;
            Object pkValue = operateInfo.getPkValue();
            pkValueList.add(pkValue);
        }));
        CERTIFICATEMGDOMAINSERVICE.updateOperationResult(operationResult, pkValueList.toArray());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("deleteentry".equals(operate.getOperateKey()) && (entryEntity = FIL_PERSON_LIST_FORM_SERVICE.checkEntityRow(this.getView(), "entryentity"))) {
            args.setCancel(true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabinreg", "flexprompt", "flexprompt"});
        this.tabInStorage();
        this.entryAssignment();
        Label label = (Label)this.getControl("labconcerttype");
        String labName = ResManager.loadKDString((String)"\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5f80\u6765\u6e2f\u6fb3\u901a\u884c\u8bc1\u3001\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5f80\u6765\u53f0\u6e7e\u901a\u884c\u8bc1", (String)"CertificateSerPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        label.setText(labName);
        this.setNotNull();
    }

    private Map<Long, List<Map<String, Object>>> queryCertInfo(List<String> personIdList) {
        Map employeeInfo = PrintTemplateExternalService.getContactInfoMap(personIdList);
        return PrintTemplateExternalService.getTargetResult((Map)employeeInfo, (String)"hrpi_percre");
    }

    private void initContent(DynamicObject[] certificateArray, Map<Long, List<Map<String, Object>>> perCreInfoMap) {
        Map historyRecordMap = CERTIFICATEINREGDOMAINSERVICE.getEffectiveData(certificateArray);
        int num = this.getModel().getEntryRowCount("entryentity");
        if (certificateArray.length != 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", certificateArray.length);
        }
        for (DynamicObject certificate : certificateArray) {
            List<Map<String, Object>> personInfo = perCreInfoMap.get(certificate.getLong("filperson.person.id"));
            this.updateModelValue(certificate, historyRecordMap, num, personInfo);
            ++num;
        }
    }

    private void updateModelValue(DynamicObject certificate, Map<Long, DynamicObject> historyRecordMap, int index, List<Map<String, Object>> perCreInfo) {
        DynamicObject historyObj = historyRecordMap.get(certificate.getLong("id"));
        if (historyObj != null && historyObj.get("storagedate") != null) {
            this.getModel().setValue("storagedate", historyObj.get("storagedate"), index);
        }
        if (historyObj != null && historyObj.get("remark") != null) {
            this.getModel().setValue("remark", historyObj.get("remark"), index);
        }
        this.getModel().setValue("certificateentity", (Object)certificate, index);
        this.getModel().setValue("filpermanage", certificate.get("filperson"), index);
        this.getModel().setValue("storagelocation", (Object)certificate.getString("storageplace"), index);
        this.getModel().setValue("onfilenum", (Object)certificate.getString("onfilenum"), index);
        DynamicObject certInfoObj = certificate.getDynamicObject("certinfo");
        if (certInfoObj != null && "0".equals(certInfoObj.getString("effectivestatus"))) {
            if (perCreInfo != null) {
                this.setCertinfo(certificate, index, perCreInfo);
            }
            return;
        }
        if (perCreInfo != null) {
            String currentDate = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            for (Map<String, Object> map : perCreInfo) {
                if (!certificate.getString("concerttype.credentialstype.number").equals(map.get("credentialstype_number"))) continue;
                String expirationDate = (String)map.get("expirationdate");
                if (map.get("expirationdate") != null && currentDate.compareTo(expirationDate) < 1) {
                    this.getModel().setValue("certnumber", map.get("number"), index);
                    this.getModel().setValue("signdate", map.get("issuedate"), index);
                    this.getModel().setValue("pervaldate", map.get("expirationdate"), index);
                    this.getModel().setValue("signorg", map.get("issuingauthor"), index);
                    this.getModel().setValue("signplace", map.get("issuingplace"), index);
                    this.getModel().setValue("faceimageentity", map.get("faceimage"), index);
                    return;
                }
                if (map.get("expirationdate") != null) continue;
                this.getModel().setValue("certnumber", map.get("number"), index);
                this.getModel().setValue("signdate", map.get("issuedate"), index);
                this.getModel().setValue("pervaldate", map.get("expirationdate"), index);
                this.getModel().setValue("signorg", map.get("issuingauthor"), index);
                this.getModel().setValue("signplace", map.get("issuingplace"), index);
                this.getModel().setValue("faceimageentity", map.get("faceimage"), index);
                return;
            }
        }
        this.getModel().setValue("certnumber", (Object)certificate.getString("certinfo.certnumber"), index);
        this.getModel().setValue("signdate", certificate.get("certinfo.signdate"), index);
        this.getModel().setValue("pervaldate", certificate.get("certinfo.pervaldate"), index);
        this.getModel().setValue("signorg", certificate.get("certinfo.signorg"), index);
        this.getModel().setValue("signplace", certificate.get("certinfo.signplace"), index);
        this.getModel().setValue("remarks", certificate.get("certinfo.remarks"), index);
    }

    private void setCertinfo(DynamicObject certificate, int index, List<Map<String, Object>> perCreInfo) {
        String currentDate = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        for (Map<String, Object> map : perCreInfo) {
            if (!certificate.getString("concerttype.credentialstype.number").equals(map.get("credentialstype_number"))) continue;
            String expirationDate = (String)map.get("expirationdate");
            if (map.get("expirationdate") != null && currentDate.compareTo(expirationDate) < 1) {
                this.getModel().setValue("certnumber", map.get("number"), index);
                this.getModel().setValue("signdate", map.get("issuedate"), index);
                this.getModel().setValue("pervaldate", map.get("expirationdate"), index);
                this.getModel().setValue("signorg", map.get("issuingauthor"), index);
                this.getModel().setValue("signplace", map.get("issuingplace"), index);
                this.getModel().setValue("faceimageentity", map.get("faceimage"), index);
                break;
            }
            if (map.get("expirationdate") != null) continue;
            this.getModel().setValue("certnumber", map.get("number"), index);
            this.getModel().setValue("signdate", map.get("issuedate"), index);
            this.getModel().setValue("pervaldate", map.get("expirationdate"), index);
            this.getModel().setValue("signorg", map.get("issuingauthor"), index);
            this.getModel().setValue("signplace", map.get("issuingplace"), index);
            this.getModel().setValue("faceimageentity", map.get("faceimage"), index);
            break;
        }
    }

    private void setEntityModelValue() {
        int currentRowIndex = (Integer)this.getModel().getValue("currentrowindex");
        this.getModel().setValue("certnumber", this.getModel().getValue("certnumberreg"), currentRowIndex);
        this.getModel().setValue("signdate", this.getModel().getValue("signdatereg"), currentRowIndex);
        this.getModel().setValue("pervaldate", this.getModel().getValue("pervaldatereg"), currentRowIndex);
        this.getModel().setValue("signorg", this.getModel().getValue("signorgreg"), currentRowIndex);
        this.getModel().setValue("signplace", this.getModel().getValue("signplacereg"), currentRowIndex);
        this.getModel().setValue("remarks", this.getModel().getValue("remarksreg"), currentRowIndex);
        this.getModel().setValue("currentrowindex", null);
        this.getModel().setValue("faceimageentity", this.getModel().getValue("faceimage"), currentRowIndex);
    }

    private void setCertModify(int currentRowIndex) {
        this.getModel().setValue("certnumberreg", this.getModel().getValue("certnumber", currentRowIndex));
        this.getModel().setValue("signdatereg", this.getModel().getValue("signdate", currentRowIndex));
        this.getModel().setValue("pervaldatereg", this.getModel().getValue("pervaldate", currentRowIndex));
        this.getModel().setValue("signorgreg", this.getModel().getValue("signorg", currentRowIndex));
        this.getModel().setValue("signplacereg", this.getModel().getValue("signplace", currentRowIndex));
        this.getModel().setValue("remarksreg", this.getModel().getValue("remarks", currentRowIndex));
        this.getModel().setValue("currentrowindex", (Object)currentRowIndex);
        String imgPath = (String)this.getModel().getValue("faceimageentity", currentRowIndex);
        if (imgPath != null && !imgPath.equals("")) {
            this.getPageCache().put("noChange", "true");
            this.getModel().setValue("faceimage", (Object)imgPath);
            this.getPageCache().put("noChange", "false");
        }
    }

    private void setNotNull() {
        this.getModel().setValue("certnumberreg", (Object)"0");
        this.getModel().setValue("pervaldatereg", (Object)new Date());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        CERTIFICATEMGDOMAINSERVICE.OCRIdentify(args, this.getView());
    }

    public void beforeShowTips(BeforeShowTipsEvent beforeShowTipsEvent) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CertificateInRegPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            beforeShowTipsEvent.setCancel(true);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    public void entryAssignment() {
        DynamicObject[] certificateArray = CERTIFICATEINREGDOMAINSERVICE.getCertificateArray(this.getView());
        List<String> personIdList = Arrays.stream(certificateArray).map(dy -> dy.getString("filperson.person.id")).collect(Collectors.toList());
        Map<Long, List<Map<String, Object>>> perCreInfoMap = this.queryCertInfo(personIdList);
        this.initContent(certificateArray, perCreInfoMap);
    }
}

