/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertRegRecordConstans;

public class CertificateRegRecPlugin
extends AbstractFormPlugin
implements CertRegRecordConstans {
    private static final Log LOG = LogFactory.getLog(CertificateRegRecPlugin.class);
    public static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if ("hstc".equals(appId)) {
            this.getModel().setValue("viewsource", (Object)"2");
        }
        this.queryRegRecList(3);
    }

    private void initEntity(List<DynamicObject> regRecordList) {
        this.getView().getModel().deleteEntryData("entryentity");
        this.getView().getModel().batchCreateNewEntryRow("entryentity", regRecordList.size());
        int num = 0;
        for (DynamicObject dynamicObject : regRecordList) {
            this.getView().getModel().setValue("regid", (Object)dynamicObject.getLong("id"), num);
            this.getView().getModel().setValue("certid", (Object)dynamicObject.getLong("certificate.id"), num);
            this.getView().getModel().setValue("entityid", (Object)dynamicObject.getDataEntityType().getName(), num);
            if (dynamicObject.getDataEntityType().getName().equals("soefam_certnotinreg")) {
                this.getView().getModel().setValue("regdate", (Object)dynamicObject.getDate("modifytime"), num);
                this.getView().getModel().setValue("regstatus", (Object)"A", num);
                this.getView().getModel().setValue("regreason", (Object)dynamicObject.getString("nostorereason"), num);
                this.getView().getModel().setValue("remark", (Object)dynamicObject.getString("remark"), num);
                this.getView().getModel().setValue("operator", (Object)dynamicObject.getDynamicObject("modifier").getString("name"), num);
                this.getView().getModel().setValue("operationtime", (Object)dynamicObject.getDate("modifytime"), num);
            } else if (dynamicObject.getDataEntityType().getName().equals("soefam_certinreg")) {
                this.getView().getModel().setValue("regdate", (Object)dynamicObject.getDate("storagedate"), num);
                this.getView().getModel().setValue("regstatus", (Object)"B", num);
                this.getView().getModel().setValue("regreason", (Object)dynamicObject.getString("storagelocation"), num);
                this.getView().getModel().setValue("remark", (Object)dynamicObject.getString("remark"), num);
                this.getView().getModel().setValue("operator", (Object)dynamicObject.getDynamicObject("modifier").getString("name"), num);
                this.getView().getModel().setValue("operationtime", (Object)dynamicObject.getDate("modifytime"), num);
            } else if (dynamicObject.getDataEntityType().getName().equals("soefam_certreplacereg")) {
                this.getView().getModel().setValue("regdate", (Object)dynamicObject.getDate("replacedate"), num);
                this.getView().getModel().setValue("regstatus", (Object)"C", num);
                this.getView().getModel().setValue("regreason", (Object)ResManager.loadKDString((String)"\u8bc1\u4ef6\u5931\u6548", (String)"CertificateRegRecPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), num);
                this.getView().getModel().setValue("remark", (Object)dynamicObject.getString("remark"), num);
                this.getView().getModel().setValue("operator", (Object)dynamicObject.getDynamicObject("modifier").getString("name"), num);
                this.getView().getModel().setValue("operationtime", (Object)dynamicObject.getDate("modifytime"), num);
            } else if (dynamicObject.getDataEntityType().getName().equals("soefam_certoutreg")) {
                this.getView().getModel().setValue("regdate", (Object)dynamicObject.getDate("outdate"), num);
                this.getView().getModel().setValue("regstatus", (Object)"D", num);
                this.getView().getModel().setValue("regreason", dynamicObject.getDynamicObject("outreason") == null ? null : dynamicObject.getDynamicObject("outreason").getString("name"), num);
                this.getView().getModel().setValue("receiver", (Object)dynamicObject.getString("receiver"), num);
                this.getView().getModel().setValue("remark", (Object)dynamicObject.getString("remark"), num);
                this.getView().getModel().setValue("operator", (Object)dynamicObject.getDynamicObject("modifier").getString("name"), num);
                this.getView().getModel().setValue("operationtime", (Object)dynamicObject.getDate("modifytime"), num);
            }
            ++num;
        }
    }

    private void queryRegRecList(int sum) {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("map");
        Long certId = (Long)map.get("certId");
        LOG.info("CertificateRegRecPlugin info , certId is {} ", (Object)certId);
        DynamicObject[] notInRegList = CERTIFICATE_QUERY_SERVICE.queryCertNotInRegByCertId(certId);
        DynamicObject[] inRegList = CERTIFICATE_QUERY_SERVICE.queryCertInRegByCertId(certId);
        DynamicObject[] outRegList = CERTIFICATE_QUERY_SERVICE.queryCertOutRegByCertId(certId);
        DynamicObject[] replaceRegList = CERTIFICATE_QUERY_SERVICE.queryCertReplaceRegByCertId(certId);
        List regRecordAll = Stream.of(Arrays.asList(notInRegList), Arrays.asList(inRegList), Arrays.asList(outRegList), Arrays.asList(replaceRegList)).flatMap(Collection::stream).collect(Collectors.toList());
        List<DynamicObject> regRecordList = regRecordAll.stream().sorted(Comparator.comparing(obj -> obj.getString("createtime")).reversed()).limit(sum).collect(Collectors.toList());
        if (regRecordAll.size() <= sum) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"more"});
        }
        if (regRecordList.size() != 0) {
            this.initEntity(regRecordList);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"more"});
        this.addClickListeners(new String[]{"viewdata"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String controlKey = ((Control)evt.getSource()).getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = formShowParameter.getAppId();
        if ("more".equals(controlKey)) {
            if ("hstc".equals(appId)) {
                this.getModel().setValue("viewsource", (Object)"2");
                this.getView().updateView();
            }
            this.queryRegRecList(this.getModel().getEntryEntity("entryentity").size() + 5);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("soefam_certinregview".equals(actionId) || "soefam_certnotinregview".equals(actionId) || "soefam_certoutregview".equals(actionId) || "soefam_certreplaceregview".equals(actionId)) {
            int rowCount = this.getView().getModel().getEntryEntity("entryentity").getRowCount();
            this.queryRegRecList(rowCount);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("viewdata".equals(operateKey) && (operationResult = afterDoOperationEventArgs.getOperationResult()) != null && operationResult.isSuccess()) {
            int currentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject regDo = (DynamicObject)this.getView().getModel().getEntryEntity("entryentity").get(currentRowIndex);
            FormShowParameter showParameter = this.getShowParameter(regDo);
            this.getView().showForm(showParameter);
        }
    }

    public FormShowParameter getShowParameter(DynamicObject regDo) {
        FormShowParameter showParameter = new FormShowParameter();
        String entityId = regDo.getString("entityid");
        if (entityId.equals("soefam_certnotinreg")) {
            entityId = "soefam_certnotinregview";
            showParameter.setCustomParam("regreason", (Object)regDo.getString("regreason"));
        } else {
            if (entityId.equals("soefam_certinreg")) {
                entityId = "soefam_certinregview";
            } else if (entityId.equals("soefam_certoutreg")) {
                entityId = "soefam_certoutregview";
            } else if (entityId.equals("soefam_certreplacereg")) {
                entityId = "soefam_certreplaceregview";
            }
            showParameter.setCustomParam("regdate", (Object)HRDateTimeUtils.format((Date)regDo.getDate("regdate")));
        }
        showParameter.setFormId(entityId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, entityId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("regid", (Object)regDo.getLong("regid"));
        showParameter.setCustomParam("certid", (Object)regDo.getLong("certid"));
        showParameter.setCustomParam("remark", (Object)regDo.getString("remark"));
        return showParameter;
    }
}

