/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateDomainService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.constants.ocr.OcrParamConstants;

public class CertificateSerPlugin
extends SoeAbstractFormPlugin
implements OcrParamConstants,
CertificateConstants {
    private static final CertificateApplicationService CERTIFICATE_APPLICATION_SERVICE = (CertificateApplicationService)ServiceFactory.getService(CertificateApplicationService.class);
    public static final String SLIDE_MOTION = "afterShowSlideBill";
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);
    private static final CertificateDomainService DOMAIN_SERVICE = (CertificateDomainService)ServiceFactory.getService(CertificateDomainService.class);
    private static final Log LOG = LogFactory.getLog(CertificateSerPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        String titleName = ResManager.loadKDString((String)"\u8bc1\u7167\u4fe1\u606f", (String)"CertificateSerPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        args.getFormShowParameter().setCaption(titleName);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Label label = (Label)this.getControl("labconcerttype");
        String labName = ResManager.loadKDString((String)"\u652f\u6301\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5f80\u6765\u6e2f\u6fb3\u901a\u884c\u8bc1\u3001\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5f80\u6765\u53f0\u6e7e\u901a\u884c\u8bc1\u7684\u6587\u672c\u5185\u5bb9\u8bc6\u522b\uff0c\u4e0a\u4f20\u8bc1\u7167\u540e\u5c06\u81ea\u52a8\u586b\u5145\u9875\u9762\u4fe1\u606f\uff0c\u652f\u6301\u683c\u5f0f\uff1ajpg/png/jpeg\u3002", (String)"CertificateSerPlugin_6", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        label.setText(labName);
    }

    public void customEvent(CustomEventArgs args) {
        if (SLIDE_MOTION.equals(args.getKey())) {
            this.getView().invokeOperation("refresh");
            IAppCache iAppCache = AppCache.get((String)"cache_soefam_editinfo");
            Long fid = (Long)iAppCache.get("fid", Long.class);
            DynamicObject dynamicObject = CERTIFICATE_QUERY_SERVICE.queryCertInfoByFid(fid);
            this.getView().getModel().setValue("id", (Object)fid);
            this.getView().getModel().setValue("certnumber", (Object)dynamicObject.getString("certnumber"));
            this.getView().getModel().setValue("effectivestatus", (Object)dynamicObject.getString("effectivestatus"));
            this.getView().getModel().setValue("signdate", (Object)dynamicObject.getDate("signdate"));
            this.getView().getModel().setValue("pervaldate", (Object)dynamicObject.getDate("pervaldate"));
            this.getView().getModel().setValue("signorg", (Object)dynamicObject.getString("signorg"));
            this.getView().getModel().setValue("signplace", (Object)dynamicObject.getString("signplace"));
            this.getView().getModel().setValue("remarks", (Object)dynamicObject.getString("remarks"));
            this.getView().getModel().setValue("certificate", (Object)dynamicObject.getDynamicObject("certificate"));
            String imgPath = dynamicObject.getString("faceimage");
            if (imgPath != null && !imgPath.equals("")) {
                this.getPageCache().put("noChange", "true");
                this.getView().getModel().setValue("faceimage", (Object)imgPath);
                this.getPageCache().put("noChange", "false");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object imgPath = changeData.getNewValue();
        if (StringUtils.equals((CharSequence)"faceimage", (CharSequence)name) && imgPath != null && !"true".equals(this.getPageCache().get("noChange"))) {
            Boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"checkCVPLicense", (Object[])new Object[0]);
            if (result.booleanValue()) {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bc1\u7167\u5185\u5bb9\u8bc6\u522b\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"CertificateSerPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0])));
                try {
                    JSONObject jsonObject = CERTIFICATE_APPLICATION_SERVICE.getCertificateInfoByOCR("soefam_certificate", String.valueOf(imgPath));
                    if (jsonObject == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u5361\u8bc1\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u4e2d\u5305\u542b\u5bf9\u5e94\u5361\u8bc1\u3002", (String)"CertificateSerPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                    }
                    String term = jsonObject.getString("term");
                    String[] split = term.split("-");
                    this.getView().getModel().setValue("certnumber", (Object)jsonObject.getString("number"));
                    if (2 == split.length) {
                        this.getView().getModel().setValue("signdate", (Object)HRDateTimeUtils.parseDate((String)split[0], (String)"yyyy.MM.dd"));
                        this.getView().getModel().setValue("pervaldate", (Object)HRDateTimeUtils.parseDate((String)split[1], (String)"yyyy.MM.dd"));
                    }
                    this.getView().getModel().setValue("signorg", (Object)jsonObject.getString("signorg"));
                    this.getView().getModel().setValue("signplace", (Object)jsonObject.getString("signplace"));
                }
                catch (Exception exception) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u5361\u8bc1\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u4e2d\u5305\u542b\u5bf9\u5e94\u5361\u8bc1\u3002", (String)"CertificateSerPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                    LOG.error("CertificateSerPlugin.propertyChanged error ", (Throwable)exception);
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        } else if (StringUtils.equals((CharSequence)"pervaldate", (CharSequence)name)) {
            Object perValDate = this.getView().getModel().getDataEntity().get("pervaldate");
            if (!ObjectUtils.isEmpty((Object)perValDate)) {
                String perVal;
                String currentDate = HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                if (currentDate.compareTo(perVal = HRDateTimeUtils.format((Date)this.getView().getModel().getDataEntity().getDate("pervaldate"), (String)"yyyy-MM-dd")) >= 1) {
                    this.getView().getModel().setValue("effectivestatus", (Object)"0");
                } else {
                    this.getView().getModel().setValue("effectivestatus", (Object)"1");
                }
            } else {
                this.getView().getModel().setValue("effectivestatus", (Object)"");
            }
        }
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            eventArgs.setOperationKey("edit");
            eventArgs.setEntityNumber("soefam_certificate");
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            DynamicObject certificate = dataEntity.getDynamicObject("certificate");
            ArrayList<Long> certificateIdList = new ArrayList<Long>(1);
            if (certificate != null) {
                certificateIdList.add(certificate.getLong("id"));
            }
            eventArgs.setIds(certificateIdList.toArray());
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("savedonothing");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "savedonothing".equals(operateKey)) {
            Long fid = (Long)this.getModel().getValue("id");
            DynamicObject dynamicObject = CERTIFICATE_QUERY_SERVICE.queryCertInfoByFid(fid);
            dynamicObject.set("certnumber", this.getModel().getValue("certnumber"));
            dynamicObject.set("signdate", this.getModel().getValue("signdate"));
            dynamicObject.set("pervaldate", this.getModel().getValue("pervaldate"));
            dynamicObject.set("signorg", (Object)((OrmLocaleValue)this.getModel().getValue("signorg")).getLocaleValue());
            dynamicObject.set("signplace", (Object)((OrmLocaleValue)this.getModel().getValue("signplace")).getLocaleValue());
            dynamicObject.set("remarks", (Object)((OrmLocaleValue)this.getModel().getValue("remarks")).getLocaleValue());
            dynamicObject.set("faceimage", this.getModel().getValue("faceimage"));
            DOMAIN_SERVICE.updateCertInfo(new DynamicObject[]{dynamicObject});
            IAppCache iAppCache = AppCache.get((String)"cache_soefam_editinfo");
            String pageId = (String)iAppCache.get("pageId", String.class);
            IFormView view = this.getView().getView(pageId);
            view.invokeOperation("refresh");
            this.getView().sendFormAction(view);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CertificateSerPlugin_4", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        this.getView().getModel().setDataChanged(false);
        IAppCache iAppCache = AppCache.get((String)"cache_soefam_editinfo");
        String pageId = (String)iAppCache.get("pageId", String.class);
        IFormView view = this.getView().getView(pageId);
        view.invokeOperation("refresh");
        this.getView().sendFormAction(view);
    }
}

