/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soefam.business.domain.certificate.CertificateLendDomainService;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.domain.faapply.FaApplyDomainService;
import kd.sihc.soefam.business.formservice.CertificateserFormService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertloancheckPlugin
extends SoeAbstractFormPlugin
implements RowClickEventListener,
TipsListener {
    private static final CertificateserFormService CERTIFICATESERFORMSERVICE = (CertificateserFormService)ServiceFactory.getService(CertificateserFormService.class);
    private static final FilPersonListFormService FILPERSONLISTFORMSERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);
    private static final CertificateQueryService CERTIFICATEQUERYSERVICE = new CertificateQueryService();
    private static final CertificateLendDomainService CERTIFICATELENDDOMAINSERVICE = new CertificateLendDomainService();
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final FaApplyDomainService FAAPPLYDOMAINSERVICE = new FaApplyDomainService();
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = (FaApplyQueryService)ServiceFactory.getService(FaApplyQueryService.class);
    private static final String CART_CERT_CLOSE = "CART_CERT_CLOSE";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"relevancyapply", "batch"});
        Button batch = (Button)this.getControl("batch");
        batch.addTipsListener((TipsListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.entryAssignment();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("1".equals(formShowParameter.getCustomParam("pageSource"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addline", "deleteline"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            CERTIFICATELENDDOMAINSERVICE.checkEffectLicense(this.getView(), evt);
        }
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            eventArgs.setOperationKey("regloan");
            eventArgs.setEntityNumber("soefam_certificate");
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            List certificateIdList = entity.stream().map(obj -> obj.getLong("certificateentity.id")).collect(Collectors.toList());
            eventArgs.setIds(certificateIdList.toArray());
        }
    }

    public void updateOperationResult(OperationResult operationResult, String operationKey) {
        super.updateOperationResult(operationResult, operationKey);
        if (operationResult == null || operationResult.getBillCount() == 1) {
            return;
        }
        ArrayList pkValueList = Lists.newArrayListWithCapacity((int)operationResult.getBillCount());
        Optional.ofNullable(operationResult.getAllErrorOrValidateInfo()).ifPresent(errorValidate -> errorValidate.forEach(result -> {
            OperateInfo operateInfo = (OperateInfo)result;
            Object pkValue = operateInfo.getPkValue();
            pkValueList.add(pkValue);
        }));
        CERTIFICATEMGDOMAINSERVICE.updateOperationResult(operationResult, pkValueList.toArray());
    }

    public void doRemoveFailRow(OperationResult operationResult, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.doRemoveFailRow(operationResult, afterDoOperationEventArgs);
        if ("sihc_precheck".equals(afterDoOperationEventArgs.getOperateKey())) {
            Map successIdMap = operationResult.getSuccessPkIds().stream().collect(Collectors.toMap(obj -> obj, Function.identity(), (v1, v2) -> v1));
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            dynamicObjectCollection.removeIf(nextObj -> !successIdMap.containsKey(nextObj.getDynamicObject("certificateentity").get("id")));
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("confirm");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("deleteentry".equals(operate.getOperateKey()) && (entryEntity = FILPERSONLISTFORMSERVICE.checkEntityRow(this.getView(), "entryentity"))) {
            args.setCancel(true);
        }
        operate.getOption().setVariableValue("pageSource", (String)this.getView().getFormShowParameter().getCustomParam("pageSource"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("addline".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List certificateIds = entryEntity.stream().map(entry -> entry.getLong("certificateentity.id")).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "not in", certificateIds);
            filter.and(new QFilter("managestatus", "=", (Object)"B"));
            ListShowParameter certificateShowParam = CERTIFICATESERFORMSERVICE.getCertificateListShowParameter(new CloseCallBack((IFormPlugin)this, "close_addcertifcate"), ResManager.loadKDString((String)"\u5f85\u501f\u51fa\u8bc1\u7167", (String)"CertloancheckPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), filter);
            certificateShowParam.setCustomParam("isShowCertNumber", (Object)"1");
            this.getView().showForm((FormShowParameter)certificateShowParam);
        } else if ("confirm".equals(key) && ((FormOperate)afterDoOperationEventArgs.getSource()).getOption().containsVariable("taskIds")) {
            List taskIds = JSON.parseArray((String)((FormOperate)afterDoOperationEventArgs.getSource()).getOption().getVariableValue("taskIds"), Long.class);
            this.getView().returnDataToParent((Object)taskIds);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        int index = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        if ("relevancyapply".equals(key)) {
            Long pkValue = ((DynamicObject)this.getView().getModel().getEntryEntity("entryentity").get(index)).getDynamicObject("certificateentity").getLong("id");
            DynamicObject[] dynamicObjects = CERTIFICATELENDDOMAINSERVICE.getFaidsByCertId(pkValue);
            if (null != dynamicObjects) {
                List<Long> faIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("faid")).collect(Collectors.toList());
                this.showList("soefam_faapplication", faIds);
            } else {
                this.showList("soefam_faapplication", new ArrayList<Long>());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        int index = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        if (CART_CERT_CLOSE.equals(actionId)) {
            if (closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() != "") {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                Object primaryKeyValue = listSelectedRowCollection.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = FAAPPLYDOMAINSERVICE.getApplyformtype(primaryKeyValue);
                this.getView().getModel().setValue("faid", dynamicObject.get("id"), index);
                this.getView().getModel().setValue("applyformtype", dynamicObject.get("applyformtype"), index);
            }
        } else if ("close_addcertifcate".equals(actionId) && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            List ids = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
            this.getView().getFormShowParameter().setCustomParam("idList", ids);
            this.entryAssignment();
        }
    }

    private void showList(String pageName, List<Long> faIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setMultiSelect(false);
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setCustomParam("faIds", faIds);
        listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", faIds));
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("900px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        listShowParameter.setOpenStyle(style);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setHasRight(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5916\u4e8b\u7533\u8bf7", (String)"CertreturnregPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CART_CERT_CLOSE));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeShowTips(BeforeShowTipsEvent beforeShowTipsEvent) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CertificateInRegPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            beforeShowTipsEvent.setCancel(true);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName = args.getProperty().getName();
        if (HRStringUtils.equals((String)propName, (String)"faid")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Long faId = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex)).getLong("faid");
            DynamicObject faObj = FA_APPLY_QUERY_SERVICE.getFaBillById(faId);
            String receiverName = FAAPPLYDOMAINSERVICE.applyFormTypeToString(faObj);
            this.getModel().setValue("receiver", (Object)new LocaleString(receiverName), rowIndex);
        }
    }

    public void entryAssignment() {
        List idList = JSON.parseArray((String)this.getView().getFormShowParameter().getCustomParam("idList").toString(), Long.class);
        List<String> propList = Arrays.asList("certinfo", "filperson", "concerttype", "recentfaid", "onfilenum");
        String properties = String.join((CharSequence)",", propList);
        DynamicObject[] dynamicObjects = CERTIFICATEQUERYSERVICE.queryById(properties, idList, null, "filperson.cadrefile.rulesortnum asc,filperson.cadrefile.usersortnum asc,filperson.recpersontype.number asc,filperson.iregscopedate desc,filperson asc");
        Map newFaidsMap = CERTIFICATELENDDOMAINSERVICE.getnewFaidsByCertId(idList);
        ArrayList faIds = new ArrayList(newFaidsMap.values());
        Map applyFormTypeMap = FAAPPLYDOMAINSERVICE.getApplyformtypes(faIds);
        int rows = this.getModel().getEntryRowCount("entryentity");
        try {
            for (int index = 0; index < idList.size(); ++index) {
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("certificateentity", (Object)dynamicObjects[index], rows);
                this.getModel().setValue("certinfo", (Object)dynamicObjects[index].getDynamicObject("certinfo"), rows);
                this.getModel().setValue("filpermanage", dynamicObjects[index].get("filperson"), rows);
                Long faId = (Long)newFaidsMap.get(dynamicObjects[index].getLong("id"));
                if (faId != null) {
                    this.getModel().setValue("faid", (Object)faId, rows);
                    Object applyFormType = ((DynamicObject)applyFormTypeMap.get(faId)).get("applyformtype");
                    String recentFaIdName = FAAPPLYDOMAINSERVICE.applyFormTypeToString(applyFormType);
                    this.getModel().setValue("relevancyapply", (Object)recentFaIdName, rows);
                    String receiverName = FAAPPLYDOMAINSERVICE.applyFormTypeToString((DynamicObject)applyFormTypeMap.get(faId));
                    this.getModel().setValue("receiver", (Object)receiverName, rows);
                }
                ++rows;
            }
        }
        catch (Exception ex) {
            this.getModel().deleteEntryRow("entryentity", rows);
        }
    }
}

