/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sihc.soefam.business.domain.certificate.CertificateForRegDomainService;
import kd.sihc.soefam.business.formservice.faapplication.FAApplicationService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;
import kd.sihc.soefam.common.constants.certificate.CertificateFRecConstants;

public class ForAffRecPlugin
extends AbstractFormPlugin
implements CertificateConstants,
CertificateFRecConstants {
    private static final Log LOG = LogFactory.getLog(ForAffRecPlugin.class);
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = (FaApplyQueryService)ServiceFactory.getService(FaApplyQueryService.class);
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);
    private static final CertificateForRegDomainService CERTIFICATEFORREG_DOMAIN_SERVICE = (CertificateForRegDomainService)ServiceFactory.getService(CertificateForRegDomainService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"view"});
    }

    public void click(EventObject evt) {
        String billId;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("view".equals(key) && (billId = (String)this.getView().getModel().getValue("billid")) != null) {
            BillShowParameter showParameter = FAApplicationService.getBillShowParameter((Long)Long.valueOf(billId));
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        Long endTime;
        Long starTime;
        Date planBackDate;
        Date planLeaveDate;
        super.beforeBindData(eventObject);
        this.getView().hideLoading();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String faId = (String)customParams.get("faid");
        LOG.info("ForAffRecPlugin info beforeBindData fail , faId is {} ", (Object)faId);
        Long personId = (Long)customParams.get("person");
        LOG.info("ForAffRecPlugin info beforeBindData fail , personId is {} ", (Object)personId);
        DynamicObject[] dynObjLend = CERTIFICATE_QUERY_SERVICE.queryLentOutRegByFilPersonId(personId, Collections.singletonList(Long.valueOf(faId)));
        List lendList = Arrays.stream(dynObjLend).filter(dynamicObject -> dynamicObject.getString("lenddate") != null).collect(Collectors.toList());
        DynamicObject fRec = FA_APPLY_QUERY_SERVICE.getFaBillById(Long.valueOf(faId));
        StringBuffer goToCountry = new StringBuffer();
        DynamicObjectCollection goToCountryCollection = fRec.getDynamicObjectCollection("gotocountry");
        for (DynamicObject object : goToCountryCollection) {
            String str = object.getString("fbasedataid.name");
            if (goToCountry.length() != 0) {
                goToCountry.append(";").append(str);
                continue;
            }
            goToCountry.append(str);
        }
        this.getView().getModel().setValue("billid", (Object)fRec.getString("id"));
        this.getView().getModel().setValue("gotocountry", (Object)goToCountry);
        this.getView().getModel().setValue("applyformtype", (Object)fRec.getString("applyformtype"));
        this.getView().getModel().setValue("processstatus", (Object)fRec.getString("processstatus"));
        long planNum = 0L;
        if ("A".equals(fRec.getString("applyformtype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gotocountry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"verticalline"});
            planLeaveDate = fRec.getDate("planlenddate");
            planBackDate = fRec.getDate("planreturndate");
            this.getView().getModel().setValue("planleavedate", (Object)planLeaveDate);
            this.getView().getModel().setValue("planbackdate", (Object)planBackDate);
            if (planLeaveDate != null && planBackDate != null) {
                starTime = planLeaveDate.getTime();
                endTime = planBackDate.getTime();
                planNum = endTime - starTime;
                planNum = planNum / 24L / 60L / 60L / 1000L + 1L;
            }
        } else {
            planLeaveDate = fRec.getDate("planleavedate");
            planBackDate = fRec.getDate("planbackdate");
            this.getView().getModel().setValue("planleavedate", (Object)planLeaveDate);
            this.getView().getModel().setValue("planbackdate", (Object)planBackDate);
            if (planLeaveDate != null && planBackDate != null) {
                starTime = planLeaveDate.getTime();
                endTime = planBackDate.getTime();
                planNum = endTime - starTime;
                planNum = planNum / 24L / 60L / 60L / 1000L + 1L;
            }
        }
        this.getView().getModel().setValue("plannum", (Object)planNum);
        CERTIFICATEFORREG_DOMAIN_SERVICE.remove(this.getView(), this.getView().getFormShowParameter().getCustomParams().get("later").toString());
        if (lendList.size() != 0) {
            DynamicObject[] returnList = CERTIFICATE_QUERY_SERVICE.queryReturnRegByFilPersonId(personId, Collections.singletonList(Long.valueOf(faId)));
            this.getView().getModel().deleteEntryData("entryentity");
            this.getView().getModel().batchCreateNewEntryRow("entryentity", lendList.size());
            int num = 0;
            for (DynamicObject objLend : lendList) {
                String certId = objLend.getDynamicObject("certificate").getString("id");
                this.getView().getModel().setValue("concerttype", objLend.getDynamicObject("certificate").getDynamicObject("concerttype") == null ? null : objLend.getDynamicObject("certificate").getDynamicObject("concerttype").get("id"), num);
                this.getView().getModel().setValue("lenddate", (Object)objLend.getDate("lenddate"), num);
                this.getView().getModel().setValue("receiver", (Object)objLend.getString("receiver"), num);
                for (DynamicObject objReturn : returnList) {
                    if (!certId.equals(objReturn.getDynamicObject("certificate").getString("id"))) continue;
                    this.getView().getModel().setValue("returndate", (Object)objReturn.getDate("returndate"), num);
                }
                ++num;
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forcardflex"});
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String later = CERTIFICATEFORREG_DOMAIN_SERVICE.getJsonStr(this.getView());
        if (!StringUtils.isEmpty((String)later)) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)8);
            map = (HashMap)JSON.parseObject((String)later, HashMap.class);
            if (map.isEmpty()) {
                this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"forrecflex"});
                this.getView().sendFormAction(this.getView().getParentView());
            }
        }
    }
}

