/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate.list;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.sihc.soefam.business.application.external.inte.InternationService;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.domain.faapply.FaApplyDomainService;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import org.apache.commons.lang3.time.StopWatch;

public class CertificateMgListPlugin
extends AbstractListPlugin
implements HRExportPlugin {
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final FaApplyDomainService APPLYDOMAINSERVICE = new FaApplyDomainService();
    private Map<Object, DynamicObject> inStoreRecordMap = new HashMap<Object, DynamicObject>(1000);
    private Map<Object, DynamicObject> lendRecordMap = new HashMap<Object, DynamicObject>(1000);
    private Map<Object, DynamicObject> returnRecordMap = new HashMap<Object, DynamicObject>(1000);
    private Map<Object, DynamicObject> outRecordMap = new HashMap<Object, DynamicObject>(1000);
    private Map<Object, Long> certAndApplyMap = new HashMap<Object, Long>(1000);
    private Map<Long, String> applyFormTypeMap = new HashMap<Long, String>(1000);
    private static final Log LOG = LogFactory.getLog(CertificateMgListPlugin.class);
    private String defaultDataFormat = "yyyy-MM-dd";
    private SimpleDateFormat SIMPLE_DATE_FORMAT;
    public static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)CertificateMgListPlugin.class.getName(), (int)16);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("filperson.cadrefile.rulesortnum asc,filperson.cadrefile.usersortnum asc,filperson.recpersontype.number asc,filperson.iregscopedate desc,filperson asc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        CERTIFICATEMGDOMAINSERVICE.lockListField(args);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        List pkIdList = e.getPageData().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qFilter = new QFilter("certificate", "in", pkIdList);
        qFilter.and("latestrecord", "=", (Object)"1");
        DynamicObject[] certificateObjList = CERTIFICATEMGDOMAINSERVICE.queryDynamicObjById("recentfaid", pkIdList, null);
        this.certAndApplyMap = Arrays.stream(certificateObjList).filter(dynamicObject -> dynamicObject.getLong("recentfaid") != 0L).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("recentfaid"), (v1, v2) -> v1));
        List recentIdList = Arrays.stream(certificateObjList).map(dynamicObject -> dynamicObject.getLong("recentfaid")).collect(Collectors.toList());
        Future<DynamicObject[]> applicationObjListFuture = EXECUTOR_SERVICE.submit(() -> APPLYDOMAINSERVICE.queryDynamicObjById("applyformtype", recentIdList, null));
        Future<Map<Object, DynamicObject>> inStoreRecordMapFuture = EXECUTOR_SERVICE.submit(() -> CERTIFICATEMGDOMAINSERVICE.queryValidData("soefam_certinreg", qFilter, "storagedate,certificate", "certificate.id"));
        QFilter copyQFilter = qFilter.copy();
        copyQFilter.and("registerstate", "=", (Object)"1");
        Future<Map<Object, DynamicObject>> lendRecordMapFuture = EXECUTOR_SERVICE.submit(() -> CERTIFICATEMGDOMAINSERVICE.queryValidData("soefam_certlentoutreg", copyQFilter, "lenddate,certificate", "certificate.id"));
        Future<Map<Object, DynamicObject>> returnRecordMapFuture = EXECUTOR_SERVICE.submit(() -> CERTIFICATEMGDOMAINSERVICE.queryValidData("soefam_certreturnreg", qFilter, "returndate,certificate", "certificate.id"));
        Future<Map<Object, DynamicObject>> outRecordMapFuture = EXECUTOR_SERVICE.submit(() -> CERTIFICATEMGDOMAINSERVICE.queryValidData("soefam_certoutreg", qFilter, "outdate,certificate", "certificate.id"));
        DynamicObject[] applicationObjList = new DynamicObject[]{};
        try {
            applicationObjList = applicationObjListFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateMgListPlugin.beforePackageData applicationObjList InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateMgListPlugin.beforePackageData applicationObjList ExecutionException", (Throwable)ex);
        }
        this.applyFormTypeMap = Arrays.stream(applicationObjList).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getString("applyformtype"), (v1, v2) -> v1));
        this.inStoreRecordMap = this.getFuture(inStoreRecordMapFuture);
        this.lendRecordMap = this.getFuture(lendRecordMapFuture);
        this.returnRecordMap = this.getFuture(returnRecordMapFuture);
        this.outRecordMap = this.getFuture(outRecordMapFuture);
        String dataFormat = InternationService.getDateFormat();
        Optional.ofNullable(dataFormat).ifPresent(format -> {
            this.defaultDataFormat = format;
        });
        this.SIMPLE_DATE_FORMAT = new SimpleDateFormat(this.defaultDataFormat);
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertificateMgListPlugin.class, (String)"beforePackageData", null);
    }

    public Map<Object, DynamicObject> getFuture(Future<Map<Object, DynamicObject>> future) {
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateMgListPlugin.beforePackageData InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateMgListPlugin.beforePackageData ExecutionException", (Throwable)ex);
        }
        return Maps.newHashMap();
    }

    public void packageData(PackageDataEvent pkd) {
        super.packageData(pkd);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)pkd.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Object pkValue = pkd.getRowData().getPkValue();
        this.setPackageData(pkd, fieldKey, pkValue);
    }

    public void setPackageData(PackageDataEvent pkd, String fieldKey, Object pkValue) {
        switch (fieldKey) {
            case "recentfatext": {
                CERTIFICATEMGDOMAINSERVICE.setForeignApplicationData(pkd, pkValue, this.certAndApplyMap, this.applyFormTypeMap);
                break;
            }
            case "warehousingdate": {
                CERTIFICATEMGDOMAINSERVICE.setWareHousingDateData(pkd, pkValue, this.inStoreRecordMap, this.SIMPLE_DATE_FORMAT);
                break;
            }
            case "receivedate": {
                CERTIFICATEMGDOMAINSERVICE.setReceiveDateData(pkd, pkValue, this.lendRecordMap, this.SIMPLE_DATE_FORMAT);
                break;
            }
            case "returndate": {
                CERTIFICATEMGDOMAINSERVICE.setReturnDataData(pkd, pkValue, this.returnRecordMap, this.SIMPLE_DATE_FORMAT);
                break;
            }
            case "outdate": {
                CERTIFICATEMGDOMAINSERVICE.setOutBoundDateData(pkd, pkValue, this.outRecordMap, this.SIMPLE_DATE_FORMAT);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if ("recentfatext".equals(fieldName)) {
            args.setCancel(true);
            CERTIFICATEMGDOMAINSERVICE.showForeignApplicationForm(this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if ("refresh".equals(((FormOperate)args.getSource()).getOperateKey())) {
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if (operationResult == null) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        if (successPkIds != null && successPkIds.size() > 0) {
            operationResult.setSuccess(true);
            operationResult.setAllErrorInfo(Collections.emptyList());
            operationResult.setValidateResult(new ValidateResultCollection());
        }
        if (operationResult.isSuccess()) {
            this.doOperationHelper(args, successPkIds);
        } else {
            Object[] primaryKeyValue = this.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValue.length == 1) {
                return;
            }
            CERTIFICATEMGDOMAINSERVICE.updateOperationResult(operationResult, primaryKeyValue);
        }
    }

    private void doOperationHelper(AfterDoOperationEventArgs args, List<Object> successPkIds) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        FormShowParameter parameter = new FormShowParameter();
        switch (operateKey) {
            case "regloan": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certlentoutregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
            case "regstore": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certinregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
            case "notinreg": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certnotinregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
            case "replace": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certreplaceregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
            case "returnreg": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certreturnregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
            case "regterminloan": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certoverregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
            case "outreg": {
                CERTIFICATEMGDOMAINSERVICE.buildParameter(parameter, "soefam_certoutregbox", (IListView)this.getView(), (IFormPlugin)this, successPkIds);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("CALLBACK_REFRESH".equals(actionId)) {
            this.getView().invokeOperation("refresh");
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        super.beforeWriteData(args);
        List listDataRows = args.getListDataRows();
        List fieldCaptions = args.getFieldCaptions();
        int seq = 0;
        for (int index = 0; index < fieldCaptions.size(); ++index) {
            String key = ((KeyValue)fieldCaptions.get((int)index)).key;
            if (!"recentfatext".equals(key)) continue;
            seq = index;
        }
        for (List listDataRow : listDataRows) {
            String recentFaIdName;
            Object object = listDataRow.get(seq);
            LOG.info("CertificateMgListPlugin , object is {} ", object);
            LOG.info("CertificateMgListPlugin , seq is {} ", (Object)seq);
            if (object == null) continue;
            if ("A".equals(object)) {
                recentFaIdName = ResManager.loadKDString((String)"\u4e0d\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355", (String)"CertificateMgListPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
                listDataRow.set(seq, recentFaIdName);
                continue;
            }
            if ("B".equals(object)) {
                recentFaIdName = ResManager.loadKDString((String)"\u56e0\u79c1\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355", (String)"CertificateMgListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
                listDataRow.set(seq, recentFaIdName);
                continue;
            }
            if (!"C".equals(object)) continue;
            recentFaIdName = ResManager.loadKDString((String)"\u56e0\u516c\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355", (String)"CertificateMgListPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
            listDataRow.set(seq, recentFaIdName);
        }
    }
}

