/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate.list;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.orm.query.QFilter;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;
import kd.sihc.soefam.common.utils.PermissionUtils;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import kd.sihc.soefam.formplugin.web.common.AbstractMenuListPlugin;
import org.apache.commons.lang3.time.StopWatch;

public class CertificateMgMenuPlugin
extends AbstractMenuListPlugin {
    private static final Log LOG = LogFactory.getLog(CertificateMgMenuPlugin.class);
    public static Map<String, String> PAGE_MAPPING = Maps.newHashMapWithExpectedSize((int)8);
    public static Map<String, List<String>> TOTAL_FILTER = Maps.newHashMapWithExpectedSize((int)3);
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final Map<String, Object> CERTIFICATE_MENU_META = EntityMetadataUtil.getBillFieldTreeByNumber((String)"soefam_certificatemenu");
    private static final FilPersonListFormService filPersonListFormService = new FilPersonListFormService();

    @Override
    public Map<String, String> getPageMapping() {
        return PAGE_MAPPING;
    }

    @Override
    public String defaultActiveKey() {
        Object activeMenuKey = this.getView().getFormShowParameter().getCustomParams().get("defaultActiveMenu");
        return activeMenuKey != null ? activeMenuKey.toString() : "flexactive1";
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
    }

    @Override
    public void doTotalData() {
        super.doTotalData();
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        LOG.info("CertificateMgMenuPlugin.doTotalData init");
        Object metaItems = CERTIFICATE_MENU_META.get("Items");
        HashMap<String, String> elementNameMap = new HashMap<String, String>(8);
        for (HashMap item : (List)metaItems) {
            elementNameMap.put((String)item.get("Id"), (String)item.get("Name"));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)(appId != null ? appId : "soefam")).getId(), "soefam_certificate", "47150e89000000ac", Collections.emptyMap()};
        Future<QFilter> permissionFuture = EXECUTOR_SERVICE.submit(() -> PermissionUtils.getPermissionQFilter((Object[])params));
        Future<List> userOrgFilterFuture = EXECUTOR_SERVICE.submit(() -> ((FilPersonListFormService)filPersonListFormService).getUserOrgFilter());
        QFilter permission = null;
        try {
            permission = permissionFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateMgMenuPlugin.doTotalData permission InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateMgMenuPlugin.doTotalData permission ExecutionException", (Throwable)ex);
        }
        List userOrgFilter = null;
        try {
            userOrgFilter = userOrgFilterFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateMgMenuPlugin.doTotalData userOrgFilter InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateMgMenuPlugin.doTotalData userOrgFilter ExecutionException", (Throwable)ex);
        }
        QFilter permFilter = null;
        if (userOrgFilter != null) {
            permFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_certificate", (String)"org");
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertificateMgMenuPlugin.class, (String)"doTotalData", (String)"permission and userOrgFilter");
        QFilter initDataFilter = new QFilter("initdatasource", "=", (Object)"1");
        initDataFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        QFilter notInitDataFilter = new QFilter("initdatasource", "!=", (Object)"1");
        initDataFilter.or(notInitDataFilter);
        initDataFilter.and(permission);
        if (permFilter != null) {
            initDataFilter.and(permFilter);
        }
        stopWatch.reset();
        stopWatch.start();
        DynamicObjectCollection certificateQueryList = CERTIFICATEMGDOMAINSERVICE.queryOriginalCollection("stockstatus", initDataFilter.toArray());
        for (Map.Entry<String, List<String>> next : TOTAL_FILTER.entrySet()) {
            List<String> filterStatusList = next.getValue();
            long totalNum = ((Stream)certificateQueryList.stream().parallel()).filter(dynamicObject -> {
                String stockStatus = dynamicObject.getString("stockstatus");
                return filterStatusList.contains(stockStatus);
            }).count();
            this.callTotalData(elementNameMap, next.getKey(), totalNum);
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertificateMgMenuPlugin.class, (String)"doTotalData", (String)"totalData end");
    }

    private void callTotalData(Map<String, String> elementNameMap, String key, long totalNum) {
        this.getView().getModel().setValue(key, (Object)(elementNameMap.get(key) + " ( " + totalNum + " ) "));
    }

    @Override
    protected void showList(String pageName, String targetKey) {
        if ("soefam_certificaterecmenu".equals(pageName)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("filingslist");
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("activeStatusInMenu")).ifPresent(tabKey -> parameter.setCustomParam("activeStatusInMenu", tabKey));
            parameter.setFormId(pageName);
            this.getView().showForm(parameter);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("filingslist");
            parameter.setBillFormId(pageName);
            parameter.setFormId("bos_list");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh_data".equals(operateKey)) {
            this.doTotalData();
        }
    }

    static {
        PAGE_MAPPING.put("flexactive0", "soefam_certificatedidno");
        PAGE_MAPPING.put("flexactive1", "soefam_certificaterecmenu");
        PAGE_MAPPING.put("flexactive2", "soefam_certificateout");
        TOTAL_FILTER.put("activelabel0", Collections.singletonList(CertStockStatusEnum.STATUS_NOTIN.getKey()));
        TOTAL_FILTER.put("activelabel1", Arrays.asList(CertStockStatusEnum.STATUS_IN.getKey(), CertStockStatusEnum.STATUS_TOOUT.getKey()));
        TOTAL_FILTER.put("activelabel2", Collections.singletonList(CertStockStatusEnum.STATUS_OUT.getKey()));
    }
}

