/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soebs.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.business.domain.messagerecord.MessageRecordDomainService;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.StopWatch;

public class CertificateMgReminderCountListPlugin
extends AbstractListPlugin {
    private Map<Long, Integer> pkIdAndNum = new HashMap<Long, Integer>(0);
    private static final HRBaseServiceHelper REMINDERRECORDSERVICEHELPER = new HRBaseServiceHelper("soefam_reminderrecord");
    private final MessageRecordDomainService MESSAGERECORDDOMAINSERVICE = (MessageRecordDomainService)ServiceFactory.getService(MessageRecordDomainService.class);

    public void beforePackageData(BeforePackageDataEvent e) {
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        super.beforePackageData(e);
        ArrayList<Long> pkIdList = new ArrayList<Long>();
        for (DynamicObject dynamicObject2 : e.getPageData()) {
            Object pkValue = dynamicObject2.getPkValue();
            pkIdList.add(Long.valueOf(pkValue.toString()));
        }
        QFilter qFilter = new QFilter("bizobj", "in", pkIdList);
        DynamicObject[] dynamicObjects = REMINDERRECORDSERVICEHELPER.query("bizObj,msgbatchid", qFilter.toArray());
        Map<String, List<DynamicObject>> bizObj = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("bizObj")));
        for (Long aLong : pkIdList) {
            List<DynamicObject> dynamicObjectList = bizObj.get(aLong.toString());
            if (ObjectUtils.isEmpty(dynamicObjectList)) {
                this.pkIdAndNum.put(aLong, 0);
                continue;
            }
            List msgbatchid = dynamicObjectList.stream().map(dynamicObject -> dynamicObject.getLong("msgbatchid")).distinct().collect(Collectors.toList());
            this.pkIdAndNum.put(aLong, msgbatchid.size());
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertificateMgReminderCountListPlugin.class, (String)"beforePackageData", null);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        CertificateMgReminderCountListPlugin.setSlidePreviewForm(this.getView());
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertificateMgReminderCountListPlugin.class, (String)"beforeBindData", null);
    }

    public void packageData(PackageDataEvent pkd) {
        super.packageData(pkd);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)pkd.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Object pkValue = pkd.getRowData().getPkValue();
        this.setPackageData(pkd, fieldKey, pkValue);
    }

    private void setPackageData(PackageDataEvent pkd, String fieldKey, Object pkValue) {
        switch (fieldKey) {
            case "remindercount": {
                pkd.setFormatValue((Object)this.pkIdAndNum.get(pkValue));
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        Long pkId = Long.valueOf(this.getFocusRowPkId().toString());
        DynamicObject[] dynamicObjects = this.MESSAGERECORDDOMAINSERVICE.getDynamicObjects(pkId);
        String fieldName = args.getFieldName();
        if ("remindercount".equals(fieldName)) {
            args.setCancel(true);
            if (dynamicObjects.length > 0) {
                IAppCache iAppCache = AppCache.get((String)"cache_soefam_pkidlist");
                iAppCache.put("fid", this.getFocusRowPkId());
                CertificateMgReminderCountListPlugin.showSlidePreviewForm(this.getView());
            }
        }
    }

    public static void setSlidePreviewForm(IFormView iFormView) {
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("dc", "top");
        map.put("formId", "soefam_announcement");
        map.put("offset", 0);
        proxy.addAction("setSlideBillFormId", map);
    }

    public static void showSlidePreviewForm(IFormView iFormView) {
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("formId", "soefam_announcement");
        map.put("show", "false");
        proxy.addAction("showSlideBill", map);
    }
}

