/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.certificate.list;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;
import kd.sihc.soefam.common.utils.PermissionUtils;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import kd.sihc.soefam.formplugin.web.common.AbstractMenuListPlugin;
import org.apache.commons.lang3.time.StopWatch;

public class CertificateReceivedMenuPlugin
extends AbstractMenuListPlugin {
    private static final Log LOG = LogFactory.getLog(CertificateReceivedMenuPlugin.class);
    static Map<String, String> PAGE_MAPPING = Maps.newHashMapWithExpectedSize((int)8);
    public static Map<String, Map.Entry<String, List<String>>> TOTAL_FILTER = Maps.newHashMapWithExpectedSize((int)3);
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final FilPersonListFormService filPersonListFormService = new FilPersonListFormService();
    private static final Map<String, Object> PERSON_MG_MENU_META = EntityMetadataUtil.getBillFieldTreeByNumber((String)"soefam_certificaterecmenu");
    public static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)CertificateReceivedMenuPlugin.class.getName(), (int)16);

    @Override
    public Map<String, String> getPageMapping() {
        return PAGE_MAPPING;
    }

    @Override
    public String defaultActiveKey() {
        Object activeMenuKey = this.getView().getFormShowParameter().getCustomParam("activeStatusInMenu");
        return activeMenuKey != null ? activeMenuKey.toString() : "tabnolimit";
    }

    @Override
    public String getActiveStyle() {
        return "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgY29sb3I6IHZhcigtLXRoZW1lLWNvbG9yKTtcbiAgYm9yZGVyLWJvdHRvbTogMnB4IHNvbGlkIHZhcigtLXRoZW1lLWNvbG9yKSAhaW1wb3J0YW50O1xufVxuIn0=";
    }

    @Override
    public String getNoActiveStyle() {
        return "eyJ0eXBlIjowLCJjb250ZW50IjoiJDpob3ZlcntcbiAgY29sb3I6IHZhcigtLXRoZW1lLWNvbG9yKTtcbiAgYm9yZGVyLWJvdHRvbTogMnB4IHNvbGlkIHZhcigtLXRoZW1lLWNvbG9yKSAhaW1wb3J0YW50O1xufVxuIn0=";
    }

    @Override
    public void refreshParentView() {
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    @Override
    public void doTotalData() {
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        Object metaItems = PERSON_MG_MENU_META.get("Items");
        HashMap<String, String> elementNameMap = new HashMap<String, String>(8);
        for (HashMap item : (List)metaItems) {
            elementNameMap.put((String)item.get("Id"), (String)item.get("Name"));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)(appId != null ? appId : "soefam")).getId(), "soefam_certificate", "47150e89000000ac", Collections.emptyMap()};
        Future<QFilter> permissionFuture = EXECUTOR_SERVICE.submit(() -> PermissionUtils.getPermissionQFilter((Object[])params));
        Future<List> userOrgFilterFuture = EXECUTOR_SERVICE.submit(() -> ((FilPersonListFormService)filPersonListFormService).getUserOrgFilter());
        QFilter permission = null;
        try {
            permission = permissionFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData permission InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData permission ExecutionException", (Throwable)ex);
        }
        LOG.info("CertificateReceivedMenuPlugin.doTotalData permission : {}", (Object)permission);
        List userOrgFilter = null;
        try {
            userOrgFilter = userOrgFilterFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData userOrgFilter InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData userOrgFilter ExecutionException", (Throwable)ex);
        }
        QFilter orgFilter = null;
        if (userOrgFilter != null) {
            orgFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_certificate", (String)"org");
        }
        QFilter initDataFilter = new QFilter("initdatasource", "=", (Object)"1");
        initDataFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        QFilter notInitDataFilter = new QFilter("initdatasource", "!=", (Object)"1");
        initDataFilter.or(notInitDataFilter);
        initDataFilter.and(permission);
        if (orgFilter != null) {
            initDataFilter.and(orgFilter);
        }
        DynamicObjectCollection certificateQueryList = CERTIFICATEMGDOMAINSERVICE.queryOriginalCollection("stockstatus,managestatus", initDataFilter.toArray());
        for (Map.Entry<String, Map.Entry<String, List<String>>> next : TOTAL_FILTER.entrySet()) {
            Map.Entry<String, List<String>> filterMap = next.getValue();
            long totalNum = certificateQueryList.stream().filter(dynamicObject -> {
                String status = dynamicObject.getString((String)filterMap.getKey());
                return ((List)filterMap.getValue()).contains(status);
            }).count();
            this.callTotalData(elementNameMap, next.getKey(), totalNum);
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertificateReceivedMenuPlugin.class, (String)"initTabPage", null);
    }

    @Override
    protected void showList(String pageName, String actionKey) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("filingslist");
        parameter.setBillFormId(pageName);
        parameter.setFormId("bos_list");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void callTotalData(Map<String, String> elementNameMap, String key, long totalNum) {
        this.getView().getModel().setValue(key, (Object)(elementNameMap.get(key) + " ( " + totalNum + " ) "));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh_data".equals(operateKey)) {
            this.doTotalData();
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    static {
        PAGE_MAPPING.put("tabnolimit", "soefam_certificatereceive");
        PAGE_MAPPING.put("tablend", "soefam_certificatelend");
        PAGE_MAPPING.put("tabreturn", "soefam_certificatereturn");
        PAGE_MAPPING.put("tabshipout", "soefam_certificateshipout");
        TOTAL_FILTER.put("text_nolimit", Maps.immutableEntry((Object)"stockstatus", Arrays.asList(CertStockStatusEnum.STATUS_IN.getKey(), CertStockStatusEnum.STATUS_TOOUT.getKey())));
        TOTAL_FILTER.put("text_lend", Maps.immutableEntry((Object)"managestatus", Collections.singletonList(CertManageStatusEnum.STATUS_TOLENTOUT.getKey())));
        TOTAL_FILTER.put("text_return", Maps.immutableEntry((Object)"managestatus", Collections.singletonList(CertManageStatusEnum.STATUS_TORETURN.getKey())));
        TOTAL_FILTER.put("text_shipout", Maps.immutableEntry((Object)"stockstatus", Collections.singletonList(CertStockStatusEnum.STATUS_TOOUT.getKey())));
    }
}

