/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.earlywarn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringTemplateParser;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.earlywarn.warnschedule.MessageContent;
import kd.bos.entity.earlywarn.warnschedule.WarnMessageConfig;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiver;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverType;
import kd.bos.entity.earlywarn.warnschedule.messageconfig.WarnMessageReceiverTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.formula.EWFormulaHandler;
import kd.bos.service.earlywarn.var.IVariableMode;
import kd.bos.service.earlywarn.var.SourceFieldVariable;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import org.apache.commons.collections4.CollectionUtils;

public class DataSourceProcess
implements IEarlyWarnDataSource {
    public static final CertificateQueryService CERTIFICATEQUERYSERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = (FaApplyQueryService)ServiceFactory.getService(FaApplyQueryService.class);
    private static final Log logger = LogFactory.getLog(DataSourceProcess.class);

    public List<QFilter> buildFilter(String dataSource, FilterCondition filterCondition, EarlyWarnContext context) {
        if (filterCondition == null) {
            return new ArrayList<QFilter>();
        }
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)dataSource);
        FilterBuilder fBuilder = new FilterBuilder(dataType, filterCondition);
        fBuilder.buildFilter();
        fBuilder.getQFilters();
        QFilter filter2 = fBuilder.getQFilter();
        ArrayList<QFilter> QFilter2 = new ArrayList<QFilter>();
        QFilter2.add(filter2);
        return QFilter2;
    }

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filters, EarlyWarnContext context) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(dataSource);
        DynamicObjectCollection queryResults = new DynamicObjectCollection();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)dataSource);
        EWFormulaHandler formulaHandler = new EWFormulaHandler(context, (BillEntityType)mainType);
        Set<String> selectProperties = this.getSearchFields(mainType, context, filters.toArray(new QFilter[0]), false);
        Set<String> formulaFields = this.addFormulaSourceFields(formulaHandler.getVars(), selectProperties);
        DynamicObject[] baseFilterDynamicObjectProudApply = hrBaseServiceHelper.loadDynamicObjectArray(filters.toArray(new QFilter[0]));
        logger.info("DataSourceProcess.getData.baseFilterDynamicObjectProudApply:{}", (Object)baseFilterDynamicObjectProudApply.length);
        List<Object> appIdObjectList = this.filterAndFillData(formulaFields, baseFilterDynamicObjectProudApply, queryResults, formulaHandler);
        ArrayList<Long> appIdList = new ArrayList<Long>(0);
        for (Object appId : appIdObjectList) {
            appIdList.add(Long.valueOf(appId.toString()));
        }
        logger.info("DataSourceProcess.getData.appIdList:{}", appIdList);
        DynamicObjectCollection dynamicObjectProudApply = new DynamicObjectCollection();
        if (formulaFields.size() != 0) {
            DynamicObject[] faBillByIdList = FA_APPLY_QUERY_SERVICE.getFaBillByIdList(appIdList);
            dynamicObjectProudApply.addAll(Arrays.asList(faBillByIdList));
        } else {
            dynamicObjectProudApply.addAll(Arrays.asList(baseFilterDynamicObjectProudApply));
        }
        if (dynamicObjectProudApply.size() == 0) {
            return new DynamicObjectCollection();
        }
        logger.info("DataSourceProcess.getData.dynamicObjectProudApply:{}", (Object)dynamicObjectProudApply.size());
        DynamicObjectCollection proudApplyDynamicObjects = new DynamicObjectCollection();
        for (DynamicObject dynamicObject2 : dynamicObjectProudApply) {
            DynamicObjectCollection visPersonEntityCollection = dynamicObject2.getDynamicObjectCollection("vispersonentity");
            Iterator iterator = visPersonEntityCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject vispersonEntity = (DynamicObject)iterator.next();
                DynamicObject dynamicObjectCopy = hrBaseServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject2, (DynamicObject)dynamicObjectCopy);
                dynamicObjectCopy.set("person", (Object)vispersonEntity.getDynamicObject("visperson"));
                dynamicObjectCopy.set("id", (Object)dynamicObject2.getLong("id"));
                dynamicObjectCopy.set("depemp", (Object)vispersonEntity.getDynamicObject("visdepemp"));
                dynamicObjectCopy.set("filpermanage", (Object)vispersonEntity.getDynamicObject("visfilpermanage"));
                dynamicObjectCopy.set("recpersontype", (Object)vispersonEntity.getDynamicObject("visrecpersontype"));
                dynamicObjectCopy.set("company", (Object)vispersonEntity.getDynamicObject("affcompany"));
                dynamicObjectCopy.set("adminorg", (Object)vispersonEntity.getDynamicObject("inorg"));
                dynamicObjectCopy.set("position", (Object)vispersonEntity.getDynamicObject("inposition"));
                DynamicObjectCollection vispersonentity = dynamicObjectCopy.getDynamicObjectCollection("vispersonentity");
                vispersonentity.clear();
                vispersonentity.add((Object)vispersonEntity);
                proudApplyDynamicObjects.add((Object)dynamicObjectCopy);
            }
        }
        Map<Long, List<DynamicObject>> visPersonIdAndProudApply = proudApplyDynamicObjects.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("person.id")));
        Set<Map.Entry<Long, List<DynamicObject>>> entries = visPersonIdAndProudApply.entrySet();
        for (Map.Entry entry : entries) {
            List appIds = ((List)entry.getValue()).stream().map(person -> person.getLong("id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = CERTIFICATEQUERYSERVICE.queryReturnRegByPersonIdAndFaIds((Long)entry.getKey(), appIds);
            List certificateList = Arrays.stream(dynamicObjects).map(certificate -> certificate.getDynamicObject("certificate").getDynamicObject("concerttype")).collect(Collectors.toList());
            ((DynamicObject)((List)entry.getValue()).get(0)).set("concerttype", certificateList);
        }
        Collection<List<DynamicObject>> values = visPersonIdAndProudApply.values();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (List<DynamicObject> value : values) {
            if (value.get(0).get("concerttype") == null || ((List)value.get(0).get("concerttype")).size() == 0) continue;
            dynamicObjectCollection.add((Object)value.get(0));
        }
        logger.info("DataSourceProcess.getData.returnDynamicObjects:{}", (Object)dynamicObjectCollection.size());
        return dynamicObjectCollection;
    }

    public List<Map<String, Object>> getCommonFilterColumns(String dataSource) {
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return new ArrayList<Map<String, Object>>();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        EntityTypeUtil helper = new EntityTypeUtil();
        return helper.getFilterColumns((IDataEntityType)mainEntityType);
    }

    public TreeNode getSingleMessageFieldTree(String dataSource) {
        if (StringUtils.isBlank((CharSequence)dataSource)) {
            return new TreeNode();
        }
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)dataSource);
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }

    public TreeNode getMergeMessageFieldTree(String dataSource) {
        return new TreeNode();
    }

    private List<Object> filterAndFillData(Set<String> formulaFields, DynamicObject[] dynamicObjects, DynamicObjectCollection queryResults, EWFormulaHandler formulaHandler) {
        ArrayList<Object> pkList = new ArrayList<Object>(dynamicObjects.length);
        if (dynamicObjects.length != 0 && !StringUtils.isBlank((CharSequence)formulaHandler.getFormula())) {
            HashMap<String, DynamicProperty> fieldProps = new HashMap<String, DynamicProperty>(formulaFields.size());
            IDataEntityType dataEntityType = dynamicObjects[0].getDataEntityType();
            for (String field : formulaFields) {
                DynamicProperty dynamicProperty = this.getFieldProp(field, dataEntityType);
                fieldProps.put(field, dynamicProperty);
            }
            try {
                DynamicObject[] var14 = dynamicObjects;
                int var15 = dynamicObjects.length;
                for (int var13 = 0; var13 < var15; ++var13) {
                    DynamicObject row = var14[var13];
                    if (!((Boolean)formulaHandler.getValue(fieldProps, row)).booleanValue()) continue;
                    queryResults.add((Object)row);
                    pkList.add(row.getPkValue());
                }
                return pkList;
            }
            catch (Exception var12) {
                logger.error((Throwable)var12);
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6267\u884c\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"DefaultEarlyWarnBillDataSource_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            }
        }
        queryResults.addAll(Arrays.asList(dynamicObjects));
        return pkList;
    }

    private DynamicProperty getFieldProp(String field, IDataEntityType dataEntityType) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        String[] keys = StringUtil.split((String)field, (String)".");
        if (keys.length == 1) {
            IDataEntityProperty prop = (IDataEntityProperty)dataEntityType.getProperties().get((Object)field);
            return prop == null ? null : (DynamicProperty)prop;
        }
        IDataEntityType propertyType = dataEntityType;
        IDataEntityProperty property = null;
        for (int i = 0; i < keys.length; ++i) {
            property = (IDataEntityProperty)propertyType.getProperties().get((Object)keys[i]);
            if (i == keys.length - 1) break;
            if (!(property instanceof BasedataProp)) {
                property = null;
                break;
            }
            propertyType = ((BasedataProp)property).getComplexType();
        }
        return property == null ? null : (DynamicProperty)property;
    }

    private Set<String> getSearchFields(MainEntityType mainEntityType, EarlyWarnContext context, QFilter[] filters, boolean isOnlyEntry) {
        WarnMessageConfig messageConfig;
        HashSet<String> fields = new HashSet<String>();
        fields.add(mainEntityType.getPrimaryKey().getName());
        if (null != filters) {
            QFilter[] var6 = filters;
            int var7 = filters.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                QFilter filter = var6[var8];
                if (!StringUtils.isNotBlank((CharSequence)filter.getProperty())) continue;
                this.fetchField(mainEntityType, filter.getProperty(), fields, isOnlyEntry);
            }
        }
        if (null != (messageConfig = context.getWarnSchedule().getMessageConfig())) {
            this.fetchFields(mainEntityType, messageConfig.getSingleContent(), fields, isOnlyEntry);
            if (messageConfig.isMergeSendMessage()) {
                MessageContent messageContent = messageConfig.getMergeMessageContent();
                if (null != messageContent) {
                    this.fetchFields(mainEntityType, messageContent.getMessageHead(), fields, isOnlyEntry);
                    this.fetchFields(mainEntityType, messageContent.getMessageEnd(), fields, isOnlyEntry);
                    List tableColumns = messageContent.getTableColumns();
                    if (CollectionUtils.isNotEmpty((Collection)tableColumns)) {
                        tableColumns.forEach(col -> {
                            if (StringUtils.isNotBlank((CharSequence)col.getField())) {
                                this.fetchField(mainEntityType, col.getField(), fields, isOnlyEntry);
                            }
                        });
                    }
                } else {
                    this.fetchFields(mainEntityType, messageConfig.getMergeContent(), fields, isOnlyEntry);
                }
            }
            List receiverTypes = messageConfig.getReceiverTypes();
            for (WarnMessageReceiverType type : receiverTypes) {
                for (WarnMessageReceiver receiver : type.getReceivers()) {
                    WarnMessageReceiverTypeEnum receiverType;
                    if (!StringUtils.isNotBlank((CharSequence)receiver.getField()) || WarnMessageReceiverTypeEnum.RelationPerson != (receiverType = receiver.getReceiverTypeObj())) continue;
                    this.fetchField(mainEntityType, receiver.getField(), fields, isOnlyEntry);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)messageConfig.getGroupField())) {
                this.fetchField(mainEntityType, messageConfig.getGroupField(), fields, isOnlyEntry);
            }
        }
        return fields;
    }

    private void fetchField(MainEntityType mainEntityType, String macroName, Set<String> fields, boolean isOnlyEntry) {
        IDataEntityProperty property;
        String[] arr;
        if (!StringUtils.isBlank((CharSequence)macroName) && null != (arr = StringUtil.split((String)macroName, (String)".")) && arr.length != 0 && null != (property = mainEntityType.findProperty(arr[0]))) {
            if (!isOnlyEntry) {
                DynamicObjectType type;
                fields.add(macroName);
                if (property instanceof DynamicCollectionProperty && null != (type = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType())) {
                    String id = type.getPrimaryKey().getName();
                    fields.add(StringUtils.join((Object[])new Object[]{arr[0], id}, (String)"."));
                }
            } else {
                DynamicObjectType type;
                if (property instanceof SubEntryProp) {
                    return;
                }
                if (property instanceof EntryProp && null != (type = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType())) {
                    String id = type.getPrimaryKey().getName();
                    fields.add(StringUtils.join((Object[])new Object[]{arr[0], id}, (String)"."));
                }
            }
        }
    }

    private void fetchFields(MainEntityType mainEntityType, String template, Set<String> fields, boolean isOnlyEntry) {
        if (null != mainEntityType && !StringUtils.isBlank((CharSequence)template)) {
            StringTemplateParser parser = new StringTemplateParser();
            parser.parse(template, macroName -> {
                this.fetchField(mainEntityType, (String)macroName, fields, isOnlyEntry);
                return "";
            });
        }
    }

    private Set<String> addFormulaSourceFields(List<IVariableMode> vars, Set<String> selectFldStrings) {
        HashSet<String> formulaFields = new HashSet<String>();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable)) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldString = srcField.getFullPropName();
            selectFldStrings.add(fldString);
            formulaFields.add(fldString);
        }
        return formulaFields;
    }
}

