/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.faapplication;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.sihc.soefam.business.domain.faapply.FaApplyDomainService;

public class FaApplicationMgListPlugin
extends AbstractListPlugin {
    private static final FaApplyDomainService FAAPPLYDOMAINSERVICE = new FaApplyDomainService();
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

    public void packageData(PackageDataEvent pkd) {
        super.packageData(pkd);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)pkd.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Object pkValue = pkd.getRowData().getPkValue();
        List faids = (List)this.getView().getFormShowParameter().getCustomParam("faIds");
        List<String> propList = Arrays.asList("planlenddate", "planreturndate", "planleavedate", "planbackdate", "id");
        String properties = String.join((CharSequence)",", propList);
        DynamicObject[] faApplydynamicObjects = FAAPPLYDOMAINSERVICE.queryDynamicObjById(properties, faids, null);
        Map loanObjMap = Arrays.stream(faApplydynamicObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id") + "", Function.identity(), (v1, v2) -> v1));
        DynamicObject lendRecordObj = (DynamicObject)loanObjMap.get(pkValue.toString());
        if (null != lendRecordObj) {
            this.setPackageData(pkd, fieldKey, lendRecordObj);
        }
    }

    public void setPackageData(PackageDataEvent pkd, String fieldKey, DynamicObject lendRecordObj) {
        switch (fieldKey) {
            case "planlendorleavedate": {
                if (lendRecordObj.get("planlenddate") != null) {
                    pkd.setFormatValue((Object)SIMPLE_DATE_FORMAT.format(lendRecordObj.get("planlenddate")));
                    break;
                }
                if (lendRecordObj.get("planleavedate") == null) break;
                pkd.setFormatValue((Object)SIMPLE_DATE_FORMAT.format(lendRecordObj.get("planleavedate")));
                break;
            }
            case "planreturnorbackdate": {
                if (lendRecordObj.get("planreturndate") != null) {
                    pkd.setFormatValue((Object)SIMPLE_DATE_FORMAT.format(lendRecordObj.get("planreturndate")));
                    break;
                }
                if (lendRecordObj.get("planbackdate") == null) break;
                pkd.setFormatValue((Object)SIMPLE_DATE_FORMAT.format(lendRecordObj.get("planbackdate")));
                break;
            }
        }
    }
}

