/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.faapplication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.queryservice.ConCertTypeQueryService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;

public class HandleInsightPlugin
extends AbstractFormPlugin {
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = (FaApplyQueryService)ServiceFactory.getService(FaApplyQueryService.class);
    public static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);
    private static final Log LOGGER = LogFactory.getLog(HandleInsightPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"certdown1", "certup1", "certdown2", "certup2"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long id = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject faBill = FA_APPLY_QUERY_SERVICE.getFaBillById(id);
        DynamicObjectCollection conCertTypes = faBill.getDynamicObjectCollection("concerttype");
        List conCertTypeIds = conCertTypes.stream().map(conCertType -> conCertType.getLong("fbasedataid.id")).collect(Collectors.toList());
        DynamicObject[] sortedConCertTypes = ConCertTypeQueryService.getSortedConCertTypesByIds(conCertTypeIds);
        DynamicObject[] certLentOutRegs = CERTIFICATE_QUERY_SERVICE.queryLentOutRegByFaIds(id);
        ArrayList<String> manageStatusList = new ArrayList<String>(10);
        manageStatusList.add(CertStockStatusEnum.STATUS_IN.getKey());
        manageStatusList.add(CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
        manageStatusList.add(CertManageStatusEnum.STATUS_TORETURN.getKey());
        List certLentOutRegList = Arrays.stream(certLentOutRegs).filter(certLentOutReg -> !"0".equals(certLentOutReg.getString("registerstate")) || manageStatusList.contains(certLentOutReg.getString("certificate.managestatus"))).collect(Collectors.toList());
        if (certLentOutRegList.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"certflex1"});
        }
        for (DynamicObject conCertType2 : sortedConCertTypes) {
            long conCertTypeId = conCertType2.getLong("id");
            for (DynamicObject certLentOutReg2 : certLentOutRegList) {
                String modifyTimeStr;
                Date modifyTime;
                String modifierName;
                String certName;
                int index;
                long certConCertTypeId = certLentOutReg2.getLong("certificate.concerttype.id");
                if (conCertTypeId != certConCertTypeId) continue;
                String registerState = certLentOutReg2.getString("registerstate");
                if ("0".equals(registerState)) {
                    index = this.getModel().createNewEntryRow("entryentity1");
                    certName = certLentOutReg2.getString("certificate.concerttype.name");
                    this.getModel().setValue("certname1", (Object)certName, index);
                    this.statusLabVisible1(registerState, index);
                    continue;
                }
                if ("1".equals(registerState)) {
                    index = this.getModel().createNewEntryRow("entryentity1");
                    certName = certLentOutReg2.getString("certificate.concerttype.name");
                    modifierName = certLentOutReg2.getString("modifier.name");
                    modifyTime = certLentOutReg2.getDate("modifytime");
                    modifyTimeStr = DateUtils.formatDate((Date)modifyTime, (Object[])new Object[]{"yyyy-MM-dd HH:mm"});
                    this.getModel().setValue("certname1", (Object)certName, index);
                    this.getModel().setValue("certinfo1", (Object)ResManager.loadKDString((String)"%1$s\u4e8e%2$s\u767b\u8bb0\u501f\u51fa\u3002", (String)"HandleInsightPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[]{modifierName, modifyTimeStr}), index);
                    this.statusLabVisible1(registerState, index);
                    continue;
                }
                if (!"2".equals(registerState)) continue;
                index = this.getModel().createNewEntryRow("entryentity1");
                certName = certLentOutReg2.getString("certificate.concerttype.name");
                modifierName = certLentOutReg2.getString("modifier.name");
                modifyTime = certLentOutReg2.getDate("modifytime");
                modifyTimeStr = DateUtils.formatDate((Date)modifyTime, (Object[])new Object[]{"yyyy-MM-dd HH:mm"});
                this.getModel().setValue("certname1", (Object)certName, index);
                this.getModel().setValue("certinfo1", (Object)ResManager.loadKDString((String)"%1$s\u4e8e%2$s\u7ec8\u6b62\u501f\u51fa\u3002", (String)"HandleInsightPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[]{modifierName, modifyTimeStr}), index);
                this.statusLabVisible1(registerState, index);
            }
        }
        DynamicObject[] certReturnRegs = CERTIFICATE_QUERY_SERVICE.queryReturnRegByFaIds(id);
        List certReturnRegList = Arrays.stream(certReturnRegs).filter(certReturnReg -> !certReturnReg.getString("registerstate").equals("2")).filter(certLentOutReg -> !"0".equals(certLentOutReg.getString("registerstate")) || manageStatusList.contains(certLentOutReg.getString("certificate.managestatus"))).collect(Collectors.toList());
        LOGGER.info("HandleInsightPlugin.beforeBindData.certReturnRegList:{}", certReturnRegList);
        if (certReturnRegList.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"certflex2"});
        }
        for (DynamicObject conCertType3 : sortedConCertTypes) {
            long conCertTypeId = conCertType3.getLong("id");
            for (DynamicObject certReturnReg2 : certReturnRegList) {
                String certName;
                int index;
                LOGGER.info("HandleInsightPlugin.beforeBindData.certReturnReg:{}", (Object)certReturnReg2);
                long certConCertTypeId = certReturnReg2.getLong("certificate.concerttype.id");
                if (conCertTypeId != certConCertTypeId) continue;
                String registerState = certReturnReg2.getString("registerstate");
                if ("0".equals(registerState)) {
                    index = this.getModel().createNewEntryRow("entryentity2");
                    certName = certReturnReg2.getString("certificate.concerttype.name");
                    this.getModel().setValue("certname2", (Object)certName, index);
                    this.statusLabVisible2(registerState, index);
                    continue;
                }
                if (!"1".equals(registerState)) continue;
                index = this.getModel().createNewEntryRow("entryentity2");
                certName = certReturnReg2.getString("certificate.concerttype.name");
                String modifierName = certReturnReg2.getString("modifier.name");
                Date modifyTime = certReturnReg2.getDate("modifytime");
                String modifyTimeStr = DateUtils.formatDate((Date)modifyTime, (Object[])new Object[]{"yyyy-MM-dd HH:mm"});
                this.getModel().setValue("certname2", (Object)certName, index);
                this.getModel().setValue("certinfo2", (Object)ResManager.loadKDString((String)"%1$s\u4e8e%2$s\u767b\u8bb0\u5f52\u8fd8\u3002", (String)"HandleInsightPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[]{modifierName, modifyTimeStr}), index);
                this.statusLabVisible2(registerState, index);
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"certdown1", "certdown2"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String clickIcon = key.substring(0, key.length() - 1);
        String whichRegion = key.substring(key.length() - 1);
        this.clickUpDown(clickIcon, whichRegion);
    }

    public void clickUpDown(String clickIcon, String whichRegion) {
        if ("certdown".equals(clickIcon)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"certinfoflex" + whichRegion, "certup" + whichRegion});
            this.getView().setVisible(Boolean.FALSE, new String[]{"certdown" + whichRegion});
        } else if ("certup".equals(clickIcon)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"certinfoflex" + whichRegion, "certup" + whichRegion});
            this.getView().setVisible(Boolean.TRUE, new String[]{"certdown" + whichRegion});
        }
    }

    public void statusLabVisible1(String registerState, int index) {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity1");
        cardEntry.setChildVisible("0".equals(registerState), index, new String[]{"pendinglab1"});
        cardEntry.setChildVisible(!"0".equals(registerState), index, new String[]{"certinfo1"});
        cardEntry.setChildVisible("1".equals(registerState), index, new String[]{"completelab1"});
        cardEntry.setChildVisible("2".equals(registerState), index, new String[]{"terminationlab1"});
    }

    public void statusLabVisible2(String registerState, int index) {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity2");
        cardEntry.setChildVisible("0".equals(registerState), index, new String[]{"pendinglab2"});
        cardEntry.setChildVisible(!"0".equals(registerState), index, new String[]{"certinfo2"});
        cardEntry.setChildVisible("1".equals(registerState), index, new String[]{"completelab2"});
    }
}

