/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingsperson;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.message.apiconsumer.helper.CadreInfoConsumerHelper;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.application.service.manageorg.ManageOrgApplicationService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonListConstants;

public class AddFilPersonPlugin
extends AbstractFormPlugin
implements FilPersonListConstants {
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = (FilPersonQueryService)ServiceFactory.getService(FilPersonQueryService.class);
    private static final FilPersonListFormService FIL_PERSON_LIST_FORM_SERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);
    private static final ManageOrgApplicationService MANAGE_ORG_APPLICATION_SERVICE = (ManageOrgApplicationService)ServiceFactory.getService(ManageOrgApplicationService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"sihc_precheck"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("id");
        if (customParam != null) {
            List employeeIds = (List)customParam;
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            this.entryAssignment(employeeIds, entryRowCount);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            if (FIL_PERSON_LIST_FORM_SERVICE.checkEntityRow(this.getView(), "entryentity")) {
                args.setCancel(true);
            }
        } else if ("sihc_precheck".equals(operateKey)) {
            DynamicObjectCollection dynObjColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            List manageOrgInfos = MANAGE_ORG_APPLICATION_SERVICE.getUsableManageOrgInfo("1", "soefam_filperlist");
            StringBuilder message = new StringBuilder();
            boolean flag = false;
            for (DynamicObject dynObj : dynObjColl) {
                if (manageOrgInfos.contains(dynObj.getLong("manageorg.id"))) continue;
                message.append(dynObj.getDynamicObject("workexpierence").getString("person.name"));
                message.append("\uff0c");
                flag = true;
            }
            if (flag) {
                message.deleteCharAt(message.length() - 1);
                message.append(ResManager.loadKDString((String)"\u6240\u9009\u201c\u5916\u4e8b\u7ba1\u7406\u5355\u4f4d\u201d\u5df2\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AddFilPersonPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                this.getView().showErrorNotification(message.toString());
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObjectCollection entryEntity = this.getView().getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        if ("sihc_precheck".equals(operateKey)) {
            HashMap empIdAndType = new HashMap(16);
            for (DynamicObject entry2 : entryEntity) {
                HashMap<Long, Long> dataMap = new HashMap<Long, Long>(1);
                dataMap.put(entry2.getLong("modrecpersontype.masterid"), entry2.getLong("manageorg.id"));
                empIdAndType.put(entry2.getLong("workexpierence.employee.id"), dataMap);
            }
            this.getView().returnDataToParent(empIdAndType);
            this.getView().close();
        } else if ("addentry".equals(operateKey)) {
            ListShowParameter employeeShowParam = FIL_PERSON_LIST_FORM_SERVICE.getEmployeeShowParam(new CloseCallBack((IFormPlugin)this, "close_addper"));
            List personIds = entryEntity.stream().map(entry -> entry.getLong("workexpierence.person.id")).collect(Collectors.toList());
            employeeShowParam.getListFilterParameter().getQFilters().add(new QFilter("person.id", "not in", personIds));
            this.getView().showForm((FormShowParameter)employeeShowParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("close_addper".equals(actionId) && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            List<Long> employeeIds = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            this.entryAssignment(employeeIds, entryRowCount);
        }
    }

    public void entryAssignment(List<Long> employeeIds, int entryRows) {
        DynamicObject[] filPersonInfos = FIL_PERSON_QUERY_SERVICE.getEmpPersonInfo(employeeIds);
        HashMap<Long, DynamicObject> empIdMatchEmpInfoMap = new HashMap<Long, DynamicObject>(filPersonInfos.length);
        for (DynamicObject filPersonInfo : filPersonInfos) {
            empIdMatchEmpInfoMap.put(filPersonInfo.getLong("employee.id"), filPersonInfo);
        }
        DynamicObject[] cadreInfos = CadreInfoConsumerHelper.getCadreByEmployeeIdsEffect(employeeIds);
        Map<Long, String> cadreInfoMap = Arrays.stream(cadreInfos).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("employee.id"), dynamicObject -> dynamicObject.getString("cadrecategory.name"), (v1, v2) -> v1));
        this.getView().getModel().batchCreateNewEntryRow("entryentity", empIdMatchEmpInfoMap.size());
        List manageOrgInfos = MANAGE_ORG_APPLICATION_SERVICE.getUsableManageOrgInfo("1", "soefam_filperlist");
        DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(employeeIds);
        Map<Long, String> empCadreMap = Arrays.stream(empCadres).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("employee.id"), dynamicObject -> dynamicObject.getString("cadretype.name"), (v1, v2) -> v1));
        int num = entryRows;
        for (Long employeeId : employeeIds) {
            String cadreCateGory;
            this.getView().getModel().setValue("workexpierence", empIdMatchEmpInfoMap.get(employeeId), num);
            if (manageOrgInfos.size() == 1) {
                this.getView().getModel().setValue("manageorg", manageOrgInfos.get(0), num);
            }
            if (HRStringUtils.isEmpty((String)(cadreCateGory = cadreInfoMap.get(employeeId)))) {
                cadreCateGory = empCadreMap.get(Long.parseLong(((Object)employeeId).toString()));
            }
            this.getModel().setValue("cadrecategory", (Object)cadreCateGory, num);
            ++num;
        }
    }
}

