/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingsperson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.domain.filingspersonmg.helper.FilPersonMgHelper;
import kd.sihc.soefam.business.domain.license.LicenseService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.business.task.FilPerRuleTask;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonListConstants;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class FilPersonListPlugin
extends AbstractListPlugin
implements FilPersonListConstants {
    private static final FilPersonListFormService FIL_PERSON_LIST_FORM_SERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = (FilPersonQueryService)ServiceFactory.getService(FilPersonQueryService.class);
    private static final FilPerRuleTask FIL_PER_RULE_TASK = (FilPerRuleTask)ServiceFactory.getService(FilPerRuleTask.class);
    private static final String ORDER_FILTER = ",recpersontype asc,iregscopedate desc,modifytime desc";
    Map<Object, DynamicObject> gradeRankMap = new HashMap<Object, DynamicObject>(1000);
    Map<Long, Long> personMgMap = new HashMap<Long, Long>(20);
    Map<Object, String> empCadreMap = new HashMap<Object, String>(20);
    private static final LicenseService LICENSE_SERVICE = (LicenseService)ServiceFactory.getService(LicenseService.class);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("iscadre desc,cadrefile.rulesortnum asc,cadrefile.usersortnum asc,recpersontype asc,iregscopedate desc,modifytime desc");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String entityId = ((ListView)this.getView()).getBillFormId();
        if ("soefam_filperlist".equals(entityId)) {
            this.addItemClickListeners(new String[]{"tbladd"});
        } else {
            this.addItemClickListeners(new String[]{"tbladdfiling"});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        ArrayList<String> fixedColumnList = new ArrayList<String>(10);
        fixedColumnList.add("person.headsculpture");
        fixedColumnList.add("person.name");
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObject[] empJobRelList;
        super.beforePackageData(e);
        List pkIdList = e.getPageData().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] personMgList = FilPersonMgHelper.init().query("employee", new QFilter("id", "in", pkIdList).toArray());
        this.personMgMap = Arrays.stream(personMgList).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("employee.id")));
        for (DynamicObject dynamicObject2 : empJobRelList = HrpiQueryServiceHelper.getEmpjobrelByEmployeeId(Arrays.asList(this.personMgMap.values().toArray()), (String)"employee,joblevel,jobgrade")) {
            this.gradeRankMap.put(dynamicObject2.getLong("employee.id"), dynamicObject2);
        }
        DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(new ArrayList<Long>(this.personMgMap.values()));
        this.empCadreMap = Arrays.stream(empCadres).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("employee.id"), dynamicObject -> dynamicObject.getString("cadretype.name"), (v1, v2) -> v1));
    }

    public void packageData(PackageDataEvent pkd) {
        String cadreCateGory;
        super.packageData(pkd);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)pkd.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Object pkValue = pkd.getRowData().getPkValue();
        Long empId = this.personMgMap.get(pkValue);
        if (HRStringUtils.equals((String)"rank", (String)fieldKey)) {
            DynamicObject empJobRelObj = this.gradeRankMap.get(empId);
            Optional.ofNullable(empJobRelObj).ifPresent(dynamicObject -> pkd.setFormatValue((Object)empJobRelObj.getString("joblevel.name")));
        } else if (HRStringUtils.equals((String)"grade", (String)fieldKey)) {
            DynamicObject empJobRelObj = this.gradeRankMap.get(empId);
            Optional.ofNullable(empJobRelObj).ifPresent(dynamicObject -> pkd.setFormatValue((Object)empJobRelObj.getString("jobgrade.name")));
        } else if (HRStringUtils.equals((String)"cadrefile.cadrecategory.name", (String)fieldKey) && HRStringUtils.isEmpty((String)(cadreCateGory = pkd.getRowData().getString("cadrefile.cadrecategory.name")))) {
            pkd.setFormatValue((Object)this.empCadreMap.get(empId));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tbladd".equals(itemKey)) {
            boolean hasPerm = PermissionUtils.checkPermission((String)"soefam_filperlist", (String)"47156aff000000ac");
            if (!hasPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5f85\u8fdb\u5165\u540d\u5355\u7ba1\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonListPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            } else {
                ListShowParameter employeeShowParam = FIL_PERSON_LIST_FORM_SERVICE.getEmployeeShowParam(new CloseCallBack((IFormPlugin)this, "close_addper"));
                this.getView().showForm((FormShowParameter)employeeShowParam);
            }
            evt.setCancel(true);
        } else if ("tbladdfiling".equals(itemKey)) {
            boolean hasPerm = PermissionUtils.checkPermission((String)"soefam_filingperpenter", (String)"47156aff000000ac");
            if (!hasPerm) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5f85\u9000\u51fa\u540d\u5355\u7ba1\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            } else {
                boolean manHasPerm = PermissionUtils.checkPermission((String)"soefam_filpermanage", (String)"47150e89000000ac");
                if (!manHasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5907\u6848\u4eba\u5458\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonListPlugin_4", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                } else {
                    ListShowParameter employeeShowParam = FIL_PERSON_LIST_FORM_SERVICE.getListShowParameter(new CloseCallBack((IFormPlugin)this, "close_addfiling"));
                    this.getView().showForm((FormShowParameter)employeeShowParam);
                }
            }
            evt.setCancel(true);
        } else if ("tblauditeff".equals(itemKey) && LICENSE_SERVICE.isOverLicenseNum(this.getView(), "soefam_filperlist")) {
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh".equals(operateKey) && this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if ((operationResult = afterDoOperationEventArgs.getOperationResult()) == null) {
            return;
        }
        if ("modpertype".equals(operateKey) && operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() > 0) {
            operationResult.setSuccess(true);
            operationResult.setAllErrorInfo(Collections.emptyList());
            operationResult.setValidateResult(new ValidateResultCollection());
        }
        if ("preignore".equals(operateKey) || "preexitignore".equals(operateKey) || "preauditeff".equals(operateKey) || "preauditloseeff".equals(operateKey)) {
            operationResult.setSuccess(true);
            operationResult.setAllErrorInfo(Collections.emptyList());
            operationResult.setValidateResult(new ValidateResultCollection());
        }
        if ("modpertype".equals(operateKey) && operationResult.isSuccess()) {
            List selectIds = operationResult.getSuccessPkIds().stream().map(id -> id != null ? Long.parseLong(id.toString()) : 0L).collect(Collectors.toList());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "close_modpertype");
            String entityId = ((ListView)this.getView()).getBillFormId();
            FormShowParameter showParameter = FIL_PERSON_LIST_FORM_SERVICE.getFormShowParameter("soefam_modpertype", closeCallBack, selectIds, entityId);
            this.getView().showForm(showParameter);
        } else if ("preignore".equals(operateKey) && operationResult.isSuccess()) {
            this.setPopIgnPrompts("close_ignore", operationResult);
        } else if ("preexitignore".equals(operateKey) && operationResult.isSuccess()) {
            this.setPopIgnPrompts("close_exitignore", operationResult);
        } else if ("preauditeff".equals(operateKey) && operationResult.isSuccess()) {
            this.setPopAudPrompts("close_preauditeff", operationResult);
        } else if ("preauditloseeff".equals(operateKey) && operationResult.isSuccess()) {
            this.setPopAudPrompts("close_preauditloseeff", operationResult);
        } else if ("auditeff".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        } else if ("auditloseeff".equals(operateKey)) {
            List selectIds = operationResult.getSuccessPkIds().stream().map(id -> id != null ? Long.parseLong(id.toString()) : 0L).collect(Collectors.toList());
            DynamicObject[] filPersonInfo = FIL_PERSON_QUERY_SERVICE.getFilPersonInfos(selectIds);
            List employeeId = Arrays.stream(filPersonInfo).map(filPer -> filPer.getLong("employee.id")).collect(Collectors.toList());
            FIL_PER_RULE_TASK.dispatchRuleTask("2", null, employeeId, this.getView());
            this.getView().invokeOperation("refresh");
        } else if ("ignore".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        } else if ("exitignore".equals(operateKey) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("close_ignore".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("ignore");
        } else if ("close_exitignore".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("exitignore");
        } else if ("close_preauditeff".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if (!FIL_PERSON_LIST_FORM_SERVICE.checkEffectLicense(this.getView())) {
                return;
            }
            this.getView().invokeOperation("auditeff");
        } else if ("close_preauditloseeff".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("auditloseeff");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (key) {
            case "close_addper": {
                if (returnData == null) break;
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                List employeeIds = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "chanage_addper");
                String entityId = ((ListView)this.getView()).getBillFormId();
                FormShowParameter showParameter = FIL_PERSON_LIST_FORM_SERVICE.getModPersonFormShowParameter("soefam_addfilper", closeCallBack, employeeIds, entityId);
                this.getView().showForm(showParameter);
                break;
            }
            case "close_addfiling": {
                if (returnData == null) break;
                boolean hasPerm = PermissionUtils.checkPermission((String)"soefam_filingperpenter", (String)"47156aff000000ac");
                if (!hasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5f85\u9000\u51fa\u540d\u5355\u7ba1\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                List filPerIds = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
                FIL_PERSON_LIST_FORM_SERVICE.addFilingPerOperate(this.getView(), filPerIds);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "chanage_addper": {
                if (returnData == null) break;
                boolean hasPerm = PermissionUtils.checkPermission((String)"soefam_filperlist", (String)"47156aff000000ac");
                if (!hasPerm) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5f85\u8fdb\u5165\u540d\u5355\u7ba1\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonListPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map empIdAndTypeId = (Map)returnData;
                List employeeIds = empIdAndTypeId.keySet().stream().collect(Collectors.toList());
                FIL_PERSON_LIST_FORM_SERVICE.addEmpPerOperate(this.getView(), employeeIds, empIdAndTypeId);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "close_modpertype": {
                if (returnData == null) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void setPopIgnPrompts(String closeFlag, OperationResult operationResult) {
        int billCount = operationResult.getBillCount();
        String message = billCount == 1 ? ResManager.loadKDString((String)"\u5ffd\u7565\u8be5\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5ffd\u7565\uff1f", (String)"FilPersonListPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u5ffd\u7565\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5ffd\u7565\uff1f", (String)"FilPersonListPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), billCount);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(closeFlag, (IFormPlugin)this);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }

    private void setPopAudPrompts(String closeFlag, OperationResult operationResult) {
        int billCount = operationResult.getBillCount();
        String message = billCount == 1 ? ("close_preauditeff".equals(closeFlag) ? ResManager.loadKDString((String)"\u5ba1\u6838\u8be5\u8bb0\u5f55\u540e\uff0c\u8be5\u4eba\u5458\u5c06\u6210\u4e3a\u5907\u6848\u4eba\u5458\uff0c\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5ba1\u6838\uff1f", (String)"FilPersonListPlugin_5", (String)"sihc-soefam-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6838\u8be5\u8bb0\u5f55\u540e\uff0c\u8be5\u4eba\u5458\u5c06\u9000\u51fa\u5907\u6848\u4eba\u5458\uff0c\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5ba1\u6838\uff1f", (String)"FilPersonListPlugin_6", (String)"sihc-soefam-formplugin", (Object[])new Object[0])) : ("close_preauditeff".equals(closeFlag) ? ResManager.loadKDString((String)"\u5ba1\u6838\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\uff0c\u9009\u4e2d\u4eba\u5458\u5c06\u6210\u4e3a\u5907\u6848\u4eba\u5458\uff0c\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5ba1\u6838\uff1f", (String)"FilPersonListPlugin_7", (String)"sihc-soefam-formplugin", (Object[])new Object[]{billCount}) : ResManager.loadKDString((String)"\u5ba1\u6838\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\uff0c\u9009\u4e2d\u4eba\u5458\u5c06\u9000\u51fa\u5907\u6848\u4eba\u5458\uff0c\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5ba1\u6838\uff1f", (String)"FilPersonListPlugin_8", (String)"sihc-soefam-formplugin", (Object[])new Object[]{billCount}));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(closeFlag, (IFormPlugin)this);
        this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
    }
}

