/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingsperson;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.application.service.filingsperson.FilPersonApplicationService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.queryservice.RecPersonTypeQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class ModPersonTypePlugin
extends SoeAbstractFormPlugin
implements BeforeF7SelectListener {
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = (FilPersonQueryService)ServiceFactory.getService(FilPersonQueryService.class);
    private static final FilPersonListFormService FIL_PERSON_LIST_FORM_SERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);
    private static final FilPersonApplicationService FIL_PERSON_APPLICATION_SERVICE = (FilPersonApplicationService)ServiceFactory.getService(FilPersonApplicationService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit modRecPersonType = (BasedataEdit)this.getView().getControl("modrecpersontype");
        modRecPersonType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.entryAssignment();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject filPerDyn;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("defrecpersontype".equals(propertyName) && (filPerDyn = this.getView().getModel().getDataEntity().getDynamicObject("defrecpersontype")) != null) {
            DynamicObjectCollection entityColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int num = 0; num < entityColl.size(); ++num) {
                DynamicObject recPersonType = (DynamicObject)this.getView().getModel().getValue("recpersontype", num);
                if (filPerDyn.getLong("id") == recPersonType.getLong("id")) {
                    this.getView().getModel().setValue("modrecpersontype", null, num);
                    continue;
                }
                this.getView().getModel().setValue("modrecpersontype", (Object)filPerDyn.getLong("id"), num);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentry".equals(operateKey) && FIL_PERSON_LIST_FORM_SERVICE.checkEntityRow(this.getView(), "entryentity")) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List filPersonIds = entryEntity.stream().map(entry -> entry.getLong("filpersonid")).collect(Collectors.toList());
        if ("donothing_determine".equals(operateKey) && operationResult.isSuccess()) {
            FIL_PERSON_APPLICATION_SERVICE.updatePersonInfos(this.getView(), filPersonIds);
            this.getView().returnDataToParent((Object)"btnok");
        } else if ("addline".equals(operateKey)) {
            QFilter filter = new QFilter("id", "not in", filPersonIds);
            ListShowParameter filPersonShowParam = FIL_PERSON_LIST_FORM_SERVICE.getModPerTypeListShowParameter(new CloseCallBack((IFormPlugin)this, "close_addfiling"), filter);
            String billFormId = ((ListView)this.getView().getParentView()).getBillFormId();
            if ("soefam_filperlist".equals(billFormId)) {
                filter.and(new QFilter("listtype", "=", (Object)"1"));
                filPersonShowParam.setCaption(ResManager.loadKDString((String)"\u5f85\u8fdb\u5165\u5907\u6848\u4eba\u5458", (String)"FilPersonListFormService_11", (String)"sihc-soefam-business", (Object[])new Object[0]));
            } else if ("soefam_filingperpenter".equals(billFormId)) {
                filter.and(new QFilter("listtype", "=", (Object)"2"));
                filPersonShowParam.setCaption(ResManager.loadKDString((String)"\u5f85\u9000\u51fa\u5907\u6848\u4eba\u5458", (String)"FilPersonListFormService_12", (String)"sihc-soefam-business", (Object[])new Object[0]));
            } else {
                filter.and(new QFilter("listtype", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "2"})));
                filPersonShowParam.setCaption(ResManager.loadKDString((String)"\u5907\u6848\u4eba\u5458", (String)"FilPersonListFormService_2", (String)"sihc-soefam-business", (Object[])new Object[0]));
            }
            this.getView().showForm((FormShowParameter)filPersonShowParam);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("close_addfiling".equals(actionId) && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            List ids = selectedRows.stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList());
            this.getView().getFormShowParameter().setCustomParam("id", ids);
            this.entryAssignment();
        }
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            eventArgs.setOperationKey("modpertype");
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            eventArgs.setEntityNumber(entityId);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            List certificateIdList = entity.stream().map(obj -> obj.getLong("filpersonid")).collect(Collectors.toList());
            eventArgs.setIds(certificateIdList.toArray());
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("donothing_determine");
    }

    public void doRemoveFailRow(OperationResult operationResult, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.doRemoveFailRow(operationResult, afterDoOperationEventArgs);
        Map successIdMap = operationResult.getSuccessPkIds().stream().collect(Collectors.toMap(obj -> obj, Function.identity(), (v1, v2) -> v1));
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        dynamicObjectCollection.removeIf(nextObj -> !successIdMap.containsKey(nextObj.getLong("filpersonid")));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("modrecpersontype".equals(name)) {
            int entryCurrentRowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject recPersonType = (DynamicObject)this.getView().getModel().getValue("recpersontype", entryCurrentRowIndex);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "!=", (Object)recPersonType.getLong("id")));
        }
    }

    public void entryAssignment() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("id");
        if (customParam != null) {
            List perIds = (List)customParam;
            String orderBy = "iscadre desc,cadrefile.rulesortnum asc,cadrefile.usersortnum asc,recpersontype asc,iregscopedate desc,modifytime desc";
            DynamicObject[] filPersonInfo = FIL_PERSON_QUERY_SERVICE.getFilPersonInfosOrderBy(perIds, orderBy);
            Map<Long, Long> personMgMap = Arrays.stream(filPersonInfo).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("employee.id")));
            DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(new ArrayList<Long>(personMgMap.values()));
            Map<Object, String> empCadreMap = Arrays.stream(empCadres).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("employee.id"), dynamicObject -> dynamicObject.getString("cadretype.name"), (v1, v2) -> v1));
            int num = this.getModel().getEntryRowCount("entryentity");
            this.getView().getModel().batchCreateNewEntryRow("entryentity", filPersonInfo.length);
            DynamicObject[] allRecPersonTypes = RecPersonTypeQueryService.getAllRecPersonType();
            for (DynamicObject dynObj : filPersonInfo) {
                String cadreCateGory;
                this.getView().getModel().setValue("filpersonid", (Object)dynObj.getLong("id"), num);
                this.getView().getModel().setValue("filperson", dynObj.get("employee") != null ? Long.valueOf(dynObj.getLong("employee.id")) : null, num);
                this.getView().getModel().setValue("recpersontype", dynObj.get("recpersontype") != null ? Long.valueOf(dynObj.getLong("recpersontype.id")) : null, num);
                List recPersonTypes = Arrays.stream(allRecPersonTypes).filter(recPersonType -> dynObj.getLong("recpersontype.id") != recPersonType.getLong("id")).collect(Collectors.toList());
                if (recPersonTypes.size() == 1) {
                    this.getView().getModel().setValue("modrecpersontype", (Object)((DynamicObject)recPersonTypes.get(0)).getLong("id"), num);
                }
                if (HRStringUtils.isEmpty((String)(cadreCateGory = dynObj.getString("cadrefile.cadrecategory.name")))) {
                    Long empId = personMgMap.get(dynObj.getLong("id"));
                    cadreCateGory = empCadreMap.get(empId);
                }
                this.getView().getModel().setValue("cadrecategory", (Object)cadreCateGory, num);
                ++num;
            }
        }
    }
}

