/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingspersonmg;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;

public class FilPersonManageInfoHeadPlugin
extends AbstractFormPlugin {
    private static final FilPersonMgDomainService PERSON_MG_DOMAIN_SERVICE = FilPersonMgDomainService.init();
    private static final Log LOG = LogFactory.getLog(FilPersonManageInfoHeadPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long pkId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject personMgObj = PERSON_MG_DOMAIN_SERVICE.queryOne((Object)pkId);
        this.setModelValue(personMgObj);
    }

    private void setModelValue(DynamicObject personMgObj) {
        Long empId;
        DynamicObject[] empCadres;
        Image image = (Image)this.getControl("userphoto");
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)personMgObj.getString("person.headsculpture")));
        try {
            Map resultMap = HrmpExternalService.getPersonBaseInfo((Long)personMgObj.getLong("person.id"));
            this.getModel().setValue("gender", resultMap.get("gender"));
        }
        catch (Exception ex) {
            LOG.error("FilPersonManageInfoHeadPlugin.beforeBindData error ", (Throwable)ex);
        }
        this.getModel().setValue("company", (Object)personMgObj.getString("empposorgrel.company.name"));
        this.getModel().setValue("department", (Object)personMgObj.getString("empposorgrel.adminorg.name"));
        this.getModel().setValue("job", (Object)personMgObj.getString("empposorgrel.position.name"));
        this.getModel().getDataEntity().set("filingspersonbase", (Object)personMgObj);
        this.getView().updateControlMetadata("effstatus", PERSON_MG_DOMAIN_SERVICE.getLabelStyle(personMgObj.getString("effstatus")));
        this.getModel().setValue("labfilingpertype", personMgObj.get("recpersontype.id"));
        String cadreCateGory = personMgObj.getString("cadrefile.cadrecategory.name");
        if (HRStringUtils.isEmpty((String)cadreCateGory) && (empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(Collections.singletonList(empId = Long.valueOf(personMgObj.getLong("employee.id"))))) != null && empCadres.length > 0) {
            cadreCateGory = empCadres[0].getString("cadretype.name");
        }
        if (HRStringUtils.isEmpty((String)cadreCateGory)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cadrecategory"});
        } else {
            Label control = (Label)this.getView().getControl("cadrecategory");
            control.setText(cadreCateGory);
        }
    }
}

