/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingspersonmg;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonConstants;
import kd.sihc.soefam.common.constants.filingspersonmg.FilPersonManageConstants;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class FilPersonManageInfoPlugin
extends AbstractFormPlugin
implements FilPersonConstants,
FilPersonManageConstants,
TabSelectListener {
    private static final FilPersonMgDomainService PERSON_MG_DOMAIN_SERVICE = FilPersonMgDomainService.init();

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        PERSON_MG_DOMAIN_SERVICE.setInfoPageTitle(args);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MutexHelper.release((IFormView)this.getView());
        this.initHead();
        this.initTabContent();
    }

    private void initTabContent() {
        this.initFilingRecord();
        this.initFilForRec();
        this.checkPermission();
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    private void checkPermission() {
        boolean hasPerm = PermissionUtils.checkPermission((String)"soefam_certificate", (String)"47150e89000000ac");
        if (!hasPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"carpanel"});
        } else {
            this.initCardInfo();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        boolean hasPerm;
        String tabKey = tabSelectEvent.getTabKey();
        if ("carpanel".equals(tabKey)) {
            boolean hasPerm2 = PermissionUtils.checkPermission((String)"soefam_certificate", (String)"47150e89000000ac");
            if (!hasPerm2) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8bc1\u7167\u4fe1\u606f\u5361\u7247\uff08\u5907\u6848\u4eba\u5458\uff09\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonManageInfoPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"carpanel"});
            }
        } else if ("foreignpanel".equals(tabKey) && !(hasPerm = PermissionUtils.checkPermission((String)"soefam_filpermanage", (String)"47150e89000000ac"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5907\u6848\u4eba\u5458\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FilPersonManageInfoPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
        }
    }

    private void initCardInfo() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("soefam_certinfodet");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("id", (Object)Lists.newArrayList((Object[])new Long[]{this.getModel().getDataEntity().getLong("person.id")}));
        showParameter.getOpenStyle().setTargetKey("carpanel");
        this.getView().showForm(showParameter);
    }

    private void initFilingRecord() {
        FormShowParameter filRecEntriesForm = new FormShowParameter();
        filRecEntriesForm.setFormId("soefam_filrecentries");
        filRecEntriesForm.getOpenStyle().setShowType(ShowType.InContainer);
        filRecEntriesForm.getOpenStyle().setTargetKey("filingsrecordpanel");
        long personId = this.getModel().getDataEntity().getLong("person.id");
        filRecEntriesForm.setCustomParam("person", (Object)personId);
        this.getView().showForm(filRecEntriesForm);
    }

    private void initFilForRec() {
        FormShowParameter filRecForm = new FormShowParameter();
        filRecForm.setFormId("soefam_filpermanforrec");
        filRecForm.getOpenStyle().setShowType(ShowType.InContainer);
        filRecForm.getOpenStyle().setTargetKey("foreignrecordpanel");
        long filPersonId = this.getModel().getDataEntity().getLong("id");
        long personId = this.getModel().getDataEntity().getLong("person.id");
        HashMap<String, Long> paramMap = new HashMap<String, Long>(8);
        paramMap.put("person", personId == 0L ? null : Long.valueOf(personId));
        paramMap.put("id", filPersonId == 0L ? null : Long.valueOf(filPersonId));
        filRecForm.setCustomParams(paramMap);
        this.getView().showForm(filRecForm);
    }

    private void initHead() {
        FormShowParameter headForm = new FormShowParameter();
        headForm.setFormId("soefam_filpermanbashead");
        headForm.getOpenStyle().setShowType(ShowType.InContainer);
        headForm.getOpenStyle().setTargetKey("headinfopanel");
        long employeeId = this.getModel().getDataEntity().getLong("employee.id");
        headForm.setCustomParam("id", this.getModel().getDataEntity().getPkValue());
        headForm.setCustomParam("employee", (Object)employeeId);
        this.getView().showForm(headForm);
    }
}

