/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingspersonmg.list;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.common.enums.FilingStatusEnum;
import kd.sihc.soefam.common.utils.PermissionUtils;
import kd.sihc.soefam.formplugin.web.common.AbstractMenuListPlugin;

public class FilPersonManageMenuListPlugin
extends AbstractMenuListPlugin {
    private static final Log LOG = LogFactory.getLog(FilPersonManageMenuListPlugin.class);
    public static Map<String, String> PAGE_MAPPING = Maps.newHashMapWithExpectedSize((int)8);
    public static Map<String, Map.Entry<String, QFilter>> TOTAL_FILTER = Maps.newHashMapWithExpectedSize((int)3);
    private static final Map<String, Object> PERSON_MG_MENU_META = EntityMetadataUtil.getBillFieldTreeByNumber((String)"soefam_filpermanagemenu");
    private static final FilPersonListFormService filPersonListFormService = new FilPersonListFormService();
    private volatile String defaultActiveKey = "flexactive0";
    private Map<String, String> hasAuthorPageMap = Maps.newHashMapWithExpectedSize((int)8);

    @Override
    public Map<String, String> getPageMapping() {
        return PAGE_MAPPING;
    }

    @Override
    public String defaultActiveKey() {
        Object activeMenuKey = this.getView().getFormShowParameter().getCustomParams().get("defaultActiveMenu");
        return activeMenuKey != null ? activeMenuKey.toString() : "flexactive0";
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
    }

    @Override
    public void doTotalData() {
        super.doTotalData();
        Object metaItems = PERSON_MG_MENU_META.get("Items");
        HashMap<String, String> elementNameMap = new HashMap<String, String>(8);
        for (HashMap item : (List)metaItems) {
            elementNameMap.put((String)item.get("Id"), (String)item.get("Name"));
        }
        QFilter initDataFilter = new QFilter("initdatasource", "=", (Object)"1");
        initDataFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        QFilter notInitDataFilter = new QFilter("initdatasource", "!=", (Object)"1");
        initDataFilter.or(notInitDataFilter);
        Future<List> userOrgFilterFuture = EXECUTOR_SERVICE.submit(() -> ((FilPersonListFormService)filPersonListFormService).getUserOrgFilter());
        List userOrgFilter = null;
        try {
            userOrgFilter = userOrgFilterFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("FilPersonManageMenuListPlugin.doTotalData userOrgFilter InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("FilPersonManageMenuListPlugin.doTotalData userOrgFilter ExecutionException", (Throwable)ex);
        }
        QFilter permFilter = null;
        if (userOrgFilter != null) {
            permFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_filpermanage", (String)"org");
        }
        int index = 0;
        for (Map.Entry<String, Map.Entry<String, QFilter>> next : TOTAL_FILTER.entrySet()) {
            String key = next.getKey();
            Map.Entry<String, QFilter> entry = next.getValue();
            boolean hasPerm = PermissionUtils.checkPermission((String)entry.getKey(), (String)"47150e89000000ac");
            LOG.info("FilPersonManageMenuListPlugin.doTotalData metaKey : {} , hasPerm : {}", (Object)entry.getKey(), (Object)hasPerm);
            if (this.setDefaultActiveKey(index, hasPerm)) {
                ++index;
                continue;
            }
            ++index;
            if ("soefam_filpermanage".equals(entry.getKey())) {
                this.hasAuthorPageMap.put("soefam_filpermenu", "soefam_filpermenu");
            } else {
                this.hasAuthorPageMap.put(entry.getKey(), entry.getKey());
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)(appId != null ? appId : "soefam")).getId(), entry.getKey(), "47150e89000000ac", Collections.emptyMap()};
            QFilter permission = PermissionUtils.getPermissionQFilter((Object[])params);
            QFilter qFilter = entry.getValue();
            QFilter copyQFilter = qFilter.copy();
            copyQFilter.and(permission);
            if (permFilter != null) {
                copyQFilter.and(permFilter);
            }
            copyQFilter.and(initDataFilter);
            DynamicObjectCollection queryList = QueryServiceHelper.query((String)entry.getKey(), (String)"id", (QFilter[])copyQFilter.toArray());
            this.callTotalData(elementNameMap, key, queryList);
        }
    }

    private void callTotalData(Map<String, String> elementNameMap, String key, DynamicObjectCollection queryList) {
        this.getView().getModel().setValue(key, (Object)(elementNameMap.get(key) + " ( " + queryList.size() + " ) "));
    }

    private boolean setDefaultActiveKey(int index, boolean hasPerm) {
        if (!hasPerm) {
            if (this.defaultActiveKey != null && this.defaultActiveKey.equals("flexactive" + index)) {
                this.defaultActiveKey = null;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexactive" + index});
            LOG.info("FilPersonManageMenuListPlugin.setDefaultActiveKey index : {} ", (Object)index);
            return true;
        }
        if (this.defaultActiveKey == null) {
            this.defaultActiveKey = "flexactive" + index;
        }
        return false;
    }

    @Override
    protected void showList(String pageName, String targetKey) {
        if (!this.hasAuthorPageMap.containsKey(pageName)) {
            return;
        }
        if ("soefam_filpermenu".equals(pageName)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("filingslist");
            parameter.setFormId(pageName);
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("activeTabMenu")).ifPresent(tabKey -> parameter.setCustomParam("activeTabMenu", tabKey));
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("recpersontype")).ifPresent(tabKey -> parameter.setCustomParam("recpersontype", tabKey));
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("filingstatus")).ifPresent(filingStatus -> parameter.setCustomParam("filingstatus", filingStatus));
            this.getView().showForm(parameter);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("filingslist");
            parameter.setBillFormId(pageName);
            parameter.setFormId("bos_list");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh_data".equals(operateKey)) {
            this.doTotalData();
        }
    }

    static {
        PAGE_MAPPING.put("flexactive0", "soefam_filpermenu");
        PAGE_MAPPING.put("flexactive1", "soefam_filperlist");
        PAGE_MAPPING.put("flexactive2", "soefam_filingperpenter");
        TOTAL_FILTER.put("activelabel0", Maps.immutableEntry((Object)"soefam_filpermanage", (Object)new QFilter("filingstatus", "in", Arrays.stream(FilingStatusEnum.values()).map(filingStatusEnum -> filingStatusEnum.code).collect(Collectors.toList()))));
        TOTAL_FILTER.put("activelabel1", Maps.immutableEntry((Object)"soefam_filperlist", (Object)new QFilter("listtype", "=", (Object)"1")));
        TOTAL_FILTER.put("activelabel2", Maps.immutableEntry((Object)"soefam_filingperpenter", (Object)new QFilter("listtype", "=", (Object)"2")));
    }
}

