/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingspersonmg.list;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.common.enums.FilingStatusEnum;
import kd.sihc.soefam.common.utils.PermissionUtils;
import kd.sihc.soefam.formplugin.web.common.AbstractMenuListPlugin;

public class FilPersonManageMenuPlugin
extends AbstractMenuListPlugin {
    private static final Log LOG = LogFactory.getLog(FilPersonManageMenuPlugin.class);
    static Map<String, String> PAGE_MAPPING = Maps.newHashMapWithExpectedSize((int)8);
    public static Map<String, List<String>> TOTAL_FILTER = Maps.newHashMapWithExpectedSize((int)3);
    private static final FilPersonMgDomainService PERSON_MG_DOMAIN_SERVICE = FilPersonMgDomainService.init();
    private static final FilPersonListFormService PERSON_LIST_FORM_SERVICE = new FilPersonListFormService();
    public static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)FilPersonManageMenuPlugin.class.getName(), (int)16);
    private static final Map<String, Object> PERSON_MG_MENU_META;

    @Override
    public Map<String, String> getPageMapping() {
        return PAGE_MAPPING;
    }

    @Override
    public String defaultActiveKey() {
        Object activeMenuKey = this.getView().getFormShowParameter().getCustomParam("activeTabMenu");
        return activeMenuKey != null ? activeMenuKey.toString() : "tab_alldata";
    }

    @Override
    public String getActiveStyle() {
        return "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgY29sb3I6IHZhcigtLXRoZW1lLWNvbG9yKTtcbiAgYm9yZGVyLWJvdHRvbTogMnB4IHNvbGlkIHZhcigtLXRoZW1lLWNvbG9yKSAhaW1wb3J0YW50O1xufVxuIn0=";
    }

    @Override
    public String getNoActiveStyle() {
        return "eyJ0eXBlIjowLCJjb250ZW50IjoiJDpob3ZlcntcbiAgY29sb3I6IHZhcigtLXRoZW1lLWNvbG9yKTtcbiAgYm9yZGVyLWJvdHRvbTogMnB4IHNvbGlkIHZhcigtLXRoZW1lLWNvbG9yKSAhaW1wb3J0YW50O1xufVxuIn0=";
    }

    @Override
    public void refreshParentView() {
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    @Override
    protected void showList(String pageName, String targetKey) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("activeTabMenu")).ifPresent(tabKey -> {
            if (tabKey.equals(targetKey)) {
                Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("recpersontype")).ifPresent(personType -> parameter.setCustomParam("recpersontype", personType));
                Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("filingstatus")).ifPresent(filingStatus -> parameter.setCustomParam("filingstatus", filingStatus));
            }
        });
        parameter.setBillFormId(pageName);
        parameter.getOpenStyle().setTargetKey("filingslist");
        parameter.setFormId("bos_list");
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void doTotalData() {
        Object metaItems = PERSON_MG_MENU_META.get("Items");
        HashMap<String, String> elementNameMap = new HashMap<String, String>(8);
        for (HashMap item : (List)metaItems) {
            elementNameMap.put((String)item.get("Id"), (String)item.get("Name"));
        }
        LOG.info("CertificateReceivedMenuPlugin.doTotalData elementNameMap : {}", elementNameMap);
        String appId = this.getView().getFormShowParameter().getAppId();
        Object[] params = new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)(appId != null ? appId : "soefam")).getId(), "soefam_filpermanage", "47150e89000000ac", Collections.emptyMap()};
        Future<QFilter> permissionFuture = EXECUTOR_SERVICE.submit(() -> PermissionUtils.getPermissionQFilter((Object[])params));
        Future<List> userOrgFilterFuture = EXECUTOR_SERVICE.submit(() -> ((FilPersonListFormService)PERSON_LIST_FORM_SERVICE).getUserOrgFilter());
        QFilter permission = null;
        try {
            permission = permissionFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData permission InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData permission ExecutionException", (Throwable)ex);
        }
        LOG.info("FilPersonManageMenuPlugin.doTotalData permission : {}", (Object)permission);
        List userOrgFilter = null;
        try {
            userOrgFilter = userOrgFilterFuture.get();
        }
        catch (InterruptedException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData userOrgFilter InterruptedException ", (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOG.error("CertificateReceivedMenuPlugin.doTotalData userOrgFilter ExecutionException", (Throwable)ex);
        }
        QFilter permFilter = null;
        if (userOrgFilter != null) {
            permFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_filpermanage", (String)"org");
        }
        QFilter initDataFilter = new QFilter("initdatasource", "=", (Object)"1");
        initDataFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        QFilter notInitDataFilter = new QFilter("initdatasource", "!=", (Object)"1");
        initDataFilter.or(notInitDataFilter);
        initDataFilter.and(permission);
        if (permFilter != null) {
            initDataFilter.and(permFilter);
        }
        DynamicObjectCollection filPersonQueryList = PERSON_MG_DOMAIN_SERVICE.queryOriginalCollection("filingstatus,id", initDataFilter.toArray());
        for (Map.Entry<String, List<String>> next : TOTAL_FILTER.entrySet()) {
            List<String> filterStatusList = next.getValue();
            long totalNum = filPersonQueryList.stream().filter(dynamicObject -> {
                String stockStatus = dynamicObject.getString("filingstatus");
                return filterStatusList.contains(stockStatus);
            }).count();
            this.callTotalData(elementNameMap, next.getKey(), totalNum);
        }
    }

    private void callTotalData(Map<String, String> elementNameMap, String key, long totalNum) {
        LOG.info("CertificateReceivedMenuPlugin.callTotalData key : {}, totalNum : {} , elementNameMap : {}", new Object[]{key, totalNum, elementNameMap});
        this.getView().getModel().setValue(key, (Object)(elementNameMap.get(key) + " ( " + totalNum + " ) "));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("refresh_data".equals(operateKey)) {
            this.doTotalData();
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    static {
        PAGE_MAPPING.put("tab_alldata", "soefam_filpermannolimit");
        PAGE_MAPPING.put("tab_unregistered", "soefam_filpermannofil");
        PAGE_MAPPING.put("tab_recorded", "soefam_filpermanlarfil");
        PAGE_MAPPING.put("tab_pendtermfiling", "soefam_filpermanpenterfil");
        PAGE_MAPPING.put("tab_cancelfiling", "soefam_filpermanlarterfil");
        TOTAL_FILTER.put("text_alldata", Arrays.stream(FilingStatusEnum.values()).map(filingStatusEnum -> filingStatusEnum.code).collect(Collectors.toList()));
        TOTAL_FILTER.put("text_unregistered", Collections.singletonList(FilingStatusEnum.UNREGISTERED.code));
        TOTAL_FILTER.put("text_recorded", Arrays.asList(FilingStatusEnum.RECORDED.code, FilingStatusEnum.PEND_TERM_FILING.code));
        TOTAL_FILTER.put("text_pendtermfiling", Collections.singletonList(FilingStatusEnum.PEND_TERM_FILING.code));
        TOTAL_FILTER.put("text_cancelfiling", Collections.singletonList(FilingStatusEnum.CANCEL_FILING.code));
        PERSON_MG_MENU_META = EntityMetadataUtil.getBillFieldTreeByNumber((String)"soefam_filpermenu");
    }
}

