/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.filingspersonmg.list;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soefam.business.application.external.PrintTemplateExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.domain.filingspersonmg.FilPersonMgDomainService;
import kd.sihc.soefam.business.formservice.FilPersonListFormService;
import kd.sihc.soefam.business.queryservice.FilPersonQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class FilPersonMgListPlugin
extends AbstractListPlugin {
    private static final FilPersonMgDomainService PERSON_MG_DOMAIN_SERVICE = FilPersonMgDomainService.init();
    private static final FilPersonListFormService FIL_PERSON_LIST_FORM_SERVICE = (FilPersonListFormService)ServiceFactory.getService(FilPersonListFormService.class);
    private final Map<Object, DynamicObject> gradeRankMap = new HashMap<Object, DynamicObject>(1000);
    private final Map<Long, String> idNumMap = new HashMap<Long, String>(1000);
    private final Map<Long, String> politicalMap = new HashMap<Long, String>(1000);
    private static final String ORDER_RECPERSONTYPE = ",recpersontype asc";
    Map<Object, String> empCadreMap = new HashMap<Object, String>(20);
    Map<Long, Long> personMgMap = new HashMap<Long, Long>(20);
    private static final String ORDER_FILTER = ",iregscopedate desc,modifytime desc";
    private static final FilPersonQueryService FIL_PERSON_QUERY_SERVICE = (FilPersonQueryService)ServiceFactory.getService(FilPersonQueryService.class);
    private static Log LOG = LogFactory.getLog(FilPersonMgListPlugin.class);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("iscadre desc,cadrefile.rulesortnum asc,cadrefile.usersortnum asc,recpersontype asc,iregscopedate desc,modifytime desc");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblfilings", "tblsecfilings"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getCommonFilterColumns()) {
            if (HRStringUtils.equals((String)filterColumn.getFieldName(), (String)"recpersontype.name")) {
                Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("recpersontype")).ifPresent(recPersonTypeId -> filterColumn.setDefaultValue(recPersonTypeId.toString()));
                continue;
            }
            if (!HRStringUtils.equals((String)filterColumn.getFieldName(), (String)"filingstatus")) continue;
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("filingstatus")).ifPresent(filingStatusId -> filterColumn.setDefaultValues(((JSONArray)filingStatusId).toArray()));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        IListColumn headSculpture = args.getListColumn("person.headsculpture");
        headSculpture.setFixed(true);
        IListColumn personName = args.getListColumn("person.name");
        personName.setFixed(true);
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        List pkIdList = event.getPageData().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List<String> personId = event.getPageData().stream().map(dy -> dy.getString("person.id")).collect(Collectors.toList());
        this.getPercreInfo(personId);
        this.getPoliticalStatus(personId);
        PERSON_MG_DOMAIN_SERVICE.getGradeRankInfo(pkIdList, this.gradeRankMap);
        DynamicObject[] personMgList = FIL_PERSON_QUERY_SERVICE.queryFilPerByIds(pkIdList);
        this.personMgMap = Arrays.stream(personMgList).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("employee.id")));
        DynamicObject[] empCadres = HrpiQueryServiceHelper.getEmpCadreByEmployee(new ArrayList<Long>(this.personMgMap.values()));
        this.empCadreMap = Arrays.stream(empCadres).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("employee.id"), dynamicObject -> dynamicObject.getString("cadretype.name"), (v1, v2) -> v1));
    }

    private void getPercreInfo(List<String> personIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"007"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", personIdList);
        LOG.info("FilPersonMgListPlugin.getEmployeeInfo param :{}", param);
        Map employeeInfo = HrmpExternalService.queryEmployeeInfo(param);
        LOG.info("FilPersonMgListPlugin.getEmployeeInfo result :{}", (Object)employeeInfo.size());
        Map perContact = PrintTemplateExternalService.getTargetResult((Map)employeeInfo, (String)"hrpi_percre");
        perContact.forEach((personId, mapList) -> {
            Optional<Object> numberOption = mapList.stream().filter(itemMap -> "1010".equals(itemMap.get("credentialstype_id").toString())).map(itemMap -> itemMap.get("number")).findFirst();
            numberOption.ifPresent(o -> this.idNumMap.put((Long)personId, o.toString()));
        });
    }

    private void getPoliticalStatus(List<String> personIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"004"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", personIdList);
        LOG.info("FilPersonMgListPlugin.getEmployeeInfo param :{}", param);
        Map employeeInfo = HrmpExternalService.queryEmployeeInfo(param);
        LOG.info("FilPersonMgListPlugin.getEmployeeInfo result :{}", (Object)employeeInfo);
        Map perContact = PrintTemplateExternalService.getTargetResult((Map)employeeInfo, (String)"hrpi_perregion");
        perContact.forEach((personId, mapList) -> {
            Optional<Object> numberOption = mapList.stream().filter(itemMap -> itemMap.get("politicalstatus_name") != null).map(itemMap -> itemMap.get("politicalstatus_name")).findFirst();
            numberOption.ifPresent(o -> this.politicalMap.put((Long)personId, o.toString()));
        });
    }

    public void packageData(PackageDataEvent pkd) {
        super.packageData(pkd);
        String fieldKey = ((AbstractColumnDesc)pkd.getSource()).getFieldKey();
        Object pkValue = pkd.getRowData().getPkValue();
        Object personId = pkd.getRowData().get("person.id");
        switch (fieldKey) {
            case "rank": {
                DynamicObject empLevelObj = this.gradeRankMap.get(pkValue);
                Optional.ofNullable(empLevelObj).ifPresent(dynamicObject -> pkd.setFormatValue((Object)empLevelObj.getString("joblevel.name")));
                break;
            }
            case "grade": {
                DynamicObject empGradeObj = this.gradeRankMap.get(pkValue);
                Optional.ofNullable(empGradeObj).ifPresent(dynamicObject -> pkd.setFormatValue((Object)empGradeObj.getString("jobgrade.name")));
                break;
            }
            case "idno": {
                String idNumber = this.idNumMap.get(Long.parseLong(personId.toString()));
                Optional.ofNullable(idNumber).ifPresent(arg_0 -> ((PackageDataEvent)pkd).setFormatValue(arg_0));
                break;
            }
            case "politicalstatus.name": {
                String politicalName = this.politicalMap.get(Long.parseLong(personId.toString()));
                pkd.setFormatValue((Object)politicalName);
                break;
            }
            case "cadrefile.cadrecategory.name": {
                Object cadreCateGory = pkd.getFormatValue();
                if (cadreCateGory != null) break;
                pkd.setFormatValue((Object)this.empCadreMap.get(this.personMgMap.get(pkValue)));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if ("refresh".equals(((FormOperate)args.getSource()).getOperateKey())) {
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if (operationResult == null) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        if (successPkIds != null && successPkIds.size() > 0) {
            operationResult.setSuccess(true);
            operationResult.setAllErrorInfo(Collections.emptyList());
            operationResult.setValidateResult(new ValidateResultCollection());
        }
        if (successPkIds != null && operationResult.isSuccess()) {
            this.doOperationHelper(args, successPkIds);
        }
    }

    private void doOperationHelper(AfterDoOperationEventArgs args, List<Object> successPkIds) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        FormShowParameter parameter = new FormShowParameter();
        List<Long> idList = successPkIds.stream().map(value -> (Long)value).collect(Collectors.toList());
        switch (operateKey) {
            case "filings": {
                List<Long> selPrimaryIds = this.getSelectPrimaryKeyValue();
                if (selPrimaryIds.size() == 1) {
                    this.buildParameter(parameter, "soefam_filingsbox", idList);
                    break;
                }
                this.buildParameter(parameter, "soefam_batfilingsbox", idList);
                break;
            }
            case "secfilings": {
                List<Long> selSecPrimaryIds = this.getSelectPrimaryKeyValue();
                if (selSecPrimaryIds.size() == 1) {
                    this.buildParameter(parameter, "soefam_secfilingsbox", idList);
                    break;
                }
                this.buildParameter(parameter, "soefam_batsecfilingsbox", idList);
                break;
            }
            case "modpertype": {
                String entityId = "soefam_filpermanage";
                FormShowParameter showParameter = FIL_PERSON_LIST_FORM_SERVICE.getFormShowParameter("soefam_modpertype", new CloseCallBack((IFormPlugin)this, "filing_commit_close"), idList, entityId);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.checkDataStatus(args);
    }

    private void checkDataStatus(HyperLinkClickArgs args) {
        Object primaryKeyValue = this.getPrimaryKeyValue();
        QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject personMgObj = PERSON_MG_DOMAIN_SERVICE.queryOne("person", qFilter.toArray());
        if (personMgObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FilPersonMgListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private Object getPrimaryKeyValue() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow listSelectedRow = listView.getCurrentSelectedRowInfo();
        return listSelectedRow.getPrimaryKeyValue();
    }

    private List<Long> getSelectPrimaryKeyValue() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        return selectedRows.stream().map(selectRow -> Long.parseLong(selectRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
    }

    private void buildParameter(FormShowParameter parameter, String pageKey, List<Long> selPrimaryIds) {
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", selPrimaryIds);
        parameter.setFormId(pageKey);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "filing_commit_close"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("filing_commit_close".equals(actionId)) {
            this.getView().invokeOperation("refresh");
            this.getView().getParentView().invokeOperation("refresh_data");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

