/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.foreledger;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.application.external.hrmp.HrpiQueryServiceHelper;
import kd.sihc.soefam.business.application.service.manageorg.ManageOrgApplicationService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.ledger.ForeignLedgerConstants;
import kd.sihc.soefam.common.utils.PermissionUtils;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import org.apache.commons.lang3.time.StopWatch;

public class CertFileRegListDataPlugin
extends AbstractReportListDataPlugin
implements ForeignLedgerConstants {
    private static final HRBaseServiceHelper CERTIFICATE_HELPER = new HRBaseServiceHelper("soefam_certificate");
    private static final HRBaseServiceHelper CERTINREG_HELPER = new HRBaseServiceHelper("soefam_certinreg");
    private static final HRBaseServiceHelper CERTOUTREG_HELPER = new HRBaseServiceHelper("soefam_certoutreg");
    private static final HRBaseServiceHelper FILPERMANAGE_HELPER = new HRBaseServiceHelper("soefam_filpermanage");
    private static final HRBaseServiceHelper EMPPOSORGREL_HELPER = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper ADMINORGHR_HELPER = new HRBaseServiceHelper("haos_adminorghr");
    private static final HRBaseServiceHelper POSITIONHR_HELPER = new HRBaseServiceHelper("hbpm_positionhr");
    private static final HRBaseServiceHelper STPOSITION_HELPER = new HRBaseServiceHelper("hbpm_stposition");
    private static final HRBaseServiceHelper JOBHR_HELPER = new HRBaseServiceHelper("hbjm_jobhr");
    private static final HRBaseServiceHelper PERSON_HELPER = new HRBaseServiceHelper("hrpi_person");
    private static final HRBaseServiceHelper CONCERTTYPE_HELPER = new HRBaseServiceHelper("soefam_concerttype");
    private static final HRBaseServiceHelper CERTINFO_HELPER = new HRBaseServiceHelper("soefam_certinfo");
    private static final ManageOrgApplicationService MANAGE_ORG_APPLICATION_SERVICE = (ManageOrgApplicationService)ServiceFactory.getService(ManageOrgApplicationService.class);
    private static final HRBaseServiceHelper CADREFILE_HELPER = new HRBaseServiceHelper("soebs_cadrefile");
    private static final HRBaseServiceHelper ORG_HELPER = new HRBaseServiceHelper("bos_org");
    private static final HRBaseServiceHelper ORGHR_HELPER = new HRBaseServiceHelper("haos_adminorghr");

    public DataSet query(ReportQueryParam reportQueryParam, Object object) throws Throwable {
        QFilter manageOrgQFilter;
        List manageOrgIdList;
        QFilter qFilter = null;
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        QFilter permissionQFilter = PermissionUtils.getPermissionQFilter((String)"soefam_certificate");
        DynamicObjectCollection org = (DynamicObjectCollection)reportQueryParam.getFilter().getFilterItem("org").getValue();
        if (!ObjectUtils.isEmpty((Object)org)) {
            List orgIdList = org.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            qFilter = new QFilter("filperson.org", "in", orgIdList);
            if (permissionQFilter == null) {
                permissionQFilter = qFilter;
            } else {
                permissionQFilter.and(qFilter);
            }
        } else {
            qFilter = PermissionUtils.getUserHasPermOrgs((String)"soefam_filpermanage", (String)"filperson.org");
            if (permissionQFilter == null) {
                permissionQFilter = qFilter;
            } else {
                permissionQFilter.and(qFilter);
            }
        }
        DynamicObjectCollection manageOrg = (DynamicObjectCollection)reportQueryParam.getFilter().getFilterItem("manageorg").getValue();
        if (!ObjectUtils.isEmpty((Object)manageOrg)) {
            manageOrgIdList = manageOrg.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            manageOrgQFilter = new QFilter("manageorg", "in", manageOrgIdList);
            if (permissionQFilter == null) {
                permissionQFilter = manageOrgQFilter;
            } else {
                permissionQFilter.and(manageOrgQFilter);
            }
        } else {
            manageOrgIdList = MANAGE_ORG_APPLICATION_SERVICE.getManageOrgInfo("2", "soefam_certificate");
            manageOrgQFilter = new QFilter("manageorg", "in", manageOrgIdList);
            if (permissionQFilter == null) {
                permissionQFilter = manageOrgQFilter;
            } else {
                permissionQFilter.and(manageOrgQFilter);
            }
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"getQFilter");
        stopWatch.reset();
        stopWatch.start();
        DataSet certificateId = CERTIFICATE_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id", new QFilter[]{permissionQFilter});
        ArrayList<Long> certIdList = new ArrayList<Long>(8);
        for (Row row : certificateId.copy()) {
            Long id = row.getLong("id");
            certIdList.add(id);
        }
        String certificateSelectFields = "id,concerttype,filperson,onfilenum,certinfo,manageorg";
        DataSet certificate = CERTIFICATE_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), certificateSelectFields, new QFilter[]{new QFilter("id", "in", certIdList)});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"certificate");
        stopWatch.reset();
        stopWatch.start();
        ArrayList<Long> concerttypeIds = new ArrayList<Long>(10);
        ArrayList<Long> manorgIds = new ArrayList<Long>(10);
        for (Row row : certificate.copy()) {
            concerttypeIds.add(row.getLong("concerttype"));
            manorgIds.add(row.getLong("manageorg"));
        }
        DataSet manOrg = ORGHR_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as listmanorg", new QFilter[]{new QFilter("id", "in", manorgIds)});
        certificate = certificate.leftJoin(manOrg).on("manageorg", "id").select(new String[]{"id", "concerttype", "filperson", "onfilenum", "certinfo", "manageorg"}, new String[]{"listmanorg"}).finish();
        String concerttypeSelectFields = "id,name as concerttype,controlclassify";
        DataSet concerttype = CONCERTTYPE_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), concerttypeSelectFields, new QFilter[]{new QFilter("id", "in", concerttypeIds)});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"concerttype");
        stopWatch.reset();
        stopWatch.start();
        ArrayList<Long> certinfoId = new ArrayList<Long>(10);
        for (Row row : certificate.copy()) {
            certinfoId.add(row.getLong("certinfo"));
        }
        String certinfoSelectFields = "id,certnumber,signorg,signdate,pervaldate";
        DataSet certinfo = CERTINFO_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), certinfoSelectFields, new QFilter[]{new QFilter("id", "in", certinfoId)});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"certinfo");
        stopWatch.reset();
        stopWatch.start();
        ArrayList<Long> filpersonIds = new ArrayList<Long>(10);
        for (Row row : certificate.copy()) {
            filpersonIds.add(row.getLong("filperson"));
        }
        String filpersonSelectFields = "id,person as personid,employee,empposorgrel,cadrefile,org";
        DataSet filperson = FILPERMANAGE_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), filpersonSelectFields, new QFilter[]{new QFilter("id", "in", filpersonIds)});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"filperson");
        stopWatch.reset();
        stopWatch.start();
        ArrayList<Long> personids = new ArrayList<Long>(10);
        ArrayList<Long> empIds = new ArrayList<Long>(10);
        ArrayList<Long> cadreFileIds = new ArrayList<Long>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (Row row : filperson.copy()) {
            personids.add(row.getLong("personid"));
            empIds.add(row.getLong("employee"));
            orgIds.add(row.getLong("org"));
            Long cadreFileId = row.getLong("cadrefile");
            if (cadreFileId <= 0L) continue;
            cadreFileIds.add(cadreFileId);
        }
        DataSet listOrg = ORG_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as listorg", new QFilter[]{new QFilter("id", "in", orgIds)});
        filperson = filperson.leftJoin(listOrg).on("org", "id").select(new String[]{"id", "personid", "employee", "empposorgrel", "cadrefile"}, new String[]{"listorg"}).finish();
        DataSet person = PERSON_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name,number", new QFilter[]{new QFilter("id", "in", personids)});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"person");
        stopWatch.reset();
        stopWatch.start();
        DataSet cadreFile = CADREFILE_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,cadrecategory.name as cadrecategory", new QFilter[]{new QFilter("id", "in", cadreFileIds)});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"person");
        stopWatch.reset();
        stopWatch.start();
        ArrayList<Long> empposorgrelids = new ArrayList<Long>(10);
        for (Row row : filperson.copy()) {
            empposorgrelids.add(row.getLong("empposorgrel"));
        }
        String empposorgrelSelectFields = "id,company as companyid,adminorg as adminorgid,position as positionid,stdposition as stdpositionid,job as jobid";
        DataSet empposorgrel = EMPPOSORGREL_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), empposorgrelSelectFields, new QFilter[]{new QFilter("id", "in", empposorgrelids)});
        ArrayList<Long> companyIds = new ArrayList<Long>(10);
        for (Row row : empposorgrel.copy()) {
            companyIds.add(row.getLong("companyid"));
        }
        DataSet company = ADMINORGHR_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as company", new QFilter[]{new QFilter("id", "in", companyIds)});
        ArrayList<Long> adminorgIds = new ArrayList<Long>(10);
        for (Row row : empposorgrel.copy()) {
            adminorgIds.add(row.getLong("adminorgid"));
        }
        DataSet adminorg = ADMINORGHR_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as adminorg", new QFilter[]{new QFilter("id", "in", adminorgIds)});
        ArrayList<Long> positionIds = new ArrayList<Long>(10);
        for (Row row : empposorgrel.copy()) {
            positionIds.add(row.getLong("positionid"));
        }
        DataSet position = POSITIONHR_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as position", new QFilter[]{new QFilter("id", "in", positionIds)});
        ArrayList<Long> stdpositionIds = new ArrayList<Long>(10);
        for (Row row : empposorgrel.copy()) {
            stdpositionIds.add(row.getLong("stdpositionid"));
        }
        DataSet stdposition = STPOSITION_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as stdposition", new QFilter[]{new QFilter("id", "in", stdpositionIds)});
        ArrayList<Long> jobIds = new ArrayList<Long>(10);
        for (Row row : empposorgrel.copy()) {
            jobIds.add(row.getLong("jobid"));
        }
        DataSet job = JOBHR_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), "id,name as job", new QFilter[]{new QFilter("id", "in", jobIds)});
        DataSet empposorgrel1 = empposorgrel.leftJoin(company).on("companyid", "id").select(new String[]{"id", "companyid", "adminorgid", "positionid", "stdpositionid", "jobid"}, new String[]{"company"}).finish();
        DataSet empposorgrel2 = empposorgrel1.leftJoin(adminorg).on("adminorgid", "id").select(new String[]{"id", "companyid", "adminorgid", "positionid", "stdpositionid", "jobid", "company"}, new String[]{"adminorg"}).finish();
        DataSet empposorgrel3 = empposorgrel2.leftJoin(position).on("positionid", "id").select(new String[]{"id", "companyid", "adminorgid", "positionid", "stdpositionid", "jobid", "company", "adminorg"}, new String[]{"position"}).finish();
        DataSet empposorgrel4 = empposorgrel3.leftJoin(stdposition).on("stdpositionid", "id").select(new String[]{"id", "companyid", "adminorgid", "positionid", "stdpositionid", "jobid", "company", "adminorg", "position"}, new String[]{"stdposition"}).finish();
        DataSet empposorgrel5 = empposorgrel4.leftJoin(job).on("jobid", "id").select(new String[]{"id", "companyid", "adminorgid", "positionid", "stdpositionid", "jobid", "company", "adminorg", "position", "stdposition"}, new String[]{"job"}).finish();
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"empposorgrel");
        stopWatch.reset();
        stopWatch.start();
        String inRegSelectFields = "certificate,storagedate";
        DataSet inRegDataSet = CERTINREG_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), inRegSelectFields, new QFilter[]{new QFilter("certificate", "in", certIdList)});
        String inStr = ResManager.loadKDString((String)"'\u5165\u5e93'", (String)"CertFileRegListDataPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        inRegDataSet = inRegDataSet.addField(inStr, "regtype");
        String outRegSelectFields = "certificate,outdate as storagedate";
        DataSet outRegDataSet = CERTOUTREG_HELPER.queryDataSet(((Object)((Object)this)).getClass().getName(), outRegSelectFields, new QFilter[]{new QFilter("certificate", "in", certIdList)});
        String outStr = ResManager.loadKDString((String)"'\u51fa\u5e93'", (String)"CertFileRegListDataPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        outRegDataSet = outRegDataSet.addField(outStr, "regtype");
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"inRegAndOutReg");
        stopWatch.reset();
        stopWatch.start();
        DataSet inRegAndOutRegDataSet = inRegDataSet.union(outRegDataSet);
        DataSet filperson1 = filperson.leftJoin(person).on("personid", "id").select(new String[]{"id", "employee", "empposorgrel", "cadrefile", "listorg"}, new String[]{"name", "number"}).finish();
        DataSet filperson2 = filperson1.leftJoin(empposorgrel5).on("empposorgrel", "id").select(new String[]{"id", "name", "number", "employee", "cadrefile", "listorg"}, new String[]{"company", "adminorg", "position", "stdposition", "job"}).finish();
        filperson2 = filperson2.leftJoin(cadreFile).on("cadrefile", "id").select(new String[]{"id", "name", "number", "company", "adminorg", "employee", "position", "stdposition", "job", "listorg"}, new String[]{"cadrecategory"}).finish();
        DataSet certificate1 = certificate.leftJoin(concerttype).on("concerttype", "id").select(new String[]{"id", "filperson", "onfilenum", "certinfo", "listmanorg"}, new String[]{"concerttype", "controlclassify"}).finish();
        DataSet certificate2 = certificate1.leftJoin(certinfo).on("certinfo", "id").select(new String[]{"id", "filperson", "onfilenum", "concerttype", "controlclassify", "listmanorg"}, new String[]{"certnumber", "signorg", "signdate", "pervaldate"}).finish();
        DataSet certificate3 = certificate2.leftJoin(filperson2).on("filperson", "id").select(new String[]{"id", "onfilenum", "concerttype", "controlclassify", "certnumber", "signorg", "signdate", "pervaldate", "listmanorg"}, new String[]{"name", "number", "company", "adminorg", "position", "stdposition", "job", "cadrecategory", "employee", "listorg"}).finish();
        DataSet empCadre = HrpiQueryServiceHelper.getEmpCadreByEmployee((String)((Object)((Object)this)).getClass().getName(), empIds);
        String ys = ResManager.loadKDString((String)"'\u56e0\u79c1\u8bc1\u7167'", (String)"CertFileRegListDataPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        String yg = ResManager.loadKDString((String)"'\u56e0\u516c\u8bc1\u7167'", (String)"CertFileRegListDataPlugin_4", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
        DataSet finish = certificate3.join(inRegAndOutRegDataSet).on("id", "certificate").select(new String[]{"id", "onfilenum", "concerttype", "CASE WHEN controlclassify ='0' THEN " + yg + " ELSE " + ys + " END AS controlclassify", "certnumber", "signorg", "signdate", "pervaldate", "name", "number", "company", "adminorg", "position", "stdposition", "job", "cadrecategory", "employee", "listorg", "listmanorg"}, new String[]{"storagedate", "regtype"}).finish();
        finish = finish.leftJoin(empCadre).on("employee", "employee").select(new String[]{"id", "onfilenum", "concerttype", "controlclassify", "certnumber", "signorg", "signdate", "pervaldate", "name", "number", "company", "adminorg", "position", "stdposition", "job", "cadrecategory", "employee", "storagedate", "regtype", "listorg", "listmanorg"}, new String[]{"cadretype"}).finish();
        finish = finish.select(new String[]{"id", "onfilenum", "concerttype", "controlclassify", "certnumber", "signorg", "signdate", "pervaldate", "name", "number", "company", "adminorg", "position", "stdposition", "job", "cadrecategory", "employee", "storagedate", "regtype", "cadretype", "CASE WHEN cadrecategory is null THEN cadretype ELSE cadrecategory END AS cadretypename", "listorg", "listmanorg"});
        DataSet rows = finish.orderBy(new String[]{"storagedate desc"});
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertFileRegListDataPlugin.class, (String)"query", (String)"DataSetJoin");
        return rows;
    }
}

