/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.foreledger;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.business.application.service.manageorg.ManageOrgApplicationService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;
import kd.sihc.soefam.common.utils.PermissionUtils;

public class CertUsageReportFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final HRBaseServiceHelper CERTINFO_HELPER = new HRBaseServiceHelper("bas_manageprinttpl");
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final ManageOrgApplicationService MANAGE_ORG_APPLICATION_SERVICE = (ManageOrgApplicationService)ServiceFactory.getService(ManageOrgApplicationService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar mbar = (Toolbar)this.getView().getControl("toolbarap");
        mbar.addItemClickListener((ItemClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit manageOrg = (BasedataEdit)this.getView().getControl("manageorg");
        manageOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Boolean certusagetable;
        super.beforeItemClick(evt);
        if ("baritemap".equals(evt.getItemKey()) && !(certusagetable = this.getDefaulttplInManangeTool("soefam_certusagetable")).booleanValue()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"CertUsageReportFormPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean getDefaulttplInManangeTool(String formId) {
        QFilter qFilter = new QFilter("billformid", "=", (Object)formId);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject[] query = CERTINFO_HELPER.query(qFilter.toArray());
        return query.length > 0;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return super.verifyQuery(queryParam);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!(args.getSource() instanceof DefaultDynamicFormOperate)) {
            return;
        }
        DefaultDynamicFormOperate source = (DefaultDynamicFormOperate)args.getSource();
        OperateOption option = source.getOption();
        HashMap<String, Boolean> extParam = new HashMap<String, Boolean>(16);
        extParam.put("turnoffpaging", true);
        option.setVariableValue("extParam", SerializationUtils.toJsonString(extParam));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("org".equals(name)) {
            QFilter permOrgs = PermissionUtils.getUserHasPermOrgs((String)"soefam_filpermanage", (String)"id");
            beforeF7SelectEvent.addCustomQFilter(permOrgs);
        } else if ("manageorg".equals(name)) {
            Map customParams = beforeF7SelectEvent.getFormShowParameter().getCustomParams();
            customParams.put("struct_project_is_to_all_areas", "true");
            List<Long> ids = Collections.singletonList(ManageOrgConstants.ID_MANAGEORG);
            customParams.put("struct_project_ids", SerializationUtils.toJsonString(ids));
            List manageOrgInfo = MANAGE_ORG_APPLICATION_SERVICE.getManageOrgInfo("2", "soefam_certificate");
            QFilter qFilter = new QFilter("adminorg.id", "in", (Object)manageOrgInfo);
            customParams.put("bizQFilterKey", qFilter.toSerializedString());
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)manageOrgInfo));
        }
    }

    public void setExcelName(List<String> list) {
        super.setExcelName(list);
        String format = this.SIMPLE_DATE_FORMAT.format(new Date());
        list.add(ResManager.loadKDString((String)"\u56e0\u79c1\u56e0\u516c\u51fa\u56fd\uff08\u5883\uff09\u8bc1\u7167\u4f7f\u7528\u60c5\u51b5\u660e\u7ec6\u8868_%s", (String)"CertUsagePrintPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[]{format}));
    }
}

