/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.manageorg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.sihc.soefam.business.application.service.manageorg.ManageOrgApplicationService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.manageorg.ManageOrgConstants;

public class ManageOrgFilterListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ManageOrgFilterListPlugin.class);
    private static final ManageOrgApplicationService MANAGE_ORG_APPLICATION_SERVICE = (ManageOrgApplicationService)ServiceFactory.getService(ManageOrgApplicationService.class);

    public void filterColumnSetFilter(SetFilterEvent args) {
        FilterColumn source = (FilterColumn)args.getSource();
        String fieldName = source.getFieldName();
        if ("manageorg.name".equals(fieldName) || "manageorg.fbasedataid.name".equals(fieldName)) {
            List qFilters = args.getQFilters();
            List<Long> manageOrgInfo = this.getManOrgIds();
            QFilter admOrg = new QFilter("id", "in", manageOrgInfo);
            qFilters.add(admOrg);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filter : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn;
            List comboItems;
            String fieldName = filter.getFieldName();
            if (!"manageorg.name".equals(fieldName) && !"manageorg.fbasedataid.name".equals(fieldName) || (comboItems = (commonFilterColumn = (CommonFilterColumn)filter).getComboItems()).size() != 0) continue;
            commonFilterColumn.setMulti(false);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        logger.info("ManageOrgFilter.filterContainerBeforeF7Select.fieldName:{}", (Object)fieldName);
        if (fieldName.startsWith("manageorg")) {
            Map customParams = args.getCustomParams();
            customParams.put("struct_project_is_to_all_areas", "true");
            List<Long> ids = Collections.singletonList(ManageOrgConstants.ID_MANAGEORG);
            customParams.put("struct_project_ids", SerializationUtils.toJsonString(ids));
            customParams.put("custom_parent_f7_prop", "manageorg");
            List<Long> manageOrgIds = this.getManOrgIds();
            logger.info("ManageOrgFilter.filterContainerBeforeF7Select.manageOrgIds:{}", manageOrgIds);
            QFilter qFilter = new QFilter("adminorg.id", "in", manageOrgIds);
            customParams.put("bizQFilterKey", qFilter.toSerializedString());
            QFilter manQFilter = new QFilter("id", "in", manageOrgIds);
            args.addCustomQFilter(manQFilter);
        }
    }

    private List<Long> getManOrgIds() {
        String entityNum;
        String queType;
        String entityId = ((ListView)this.getView()).getBillFormId();
        ArrayList<String> stringColl = new ArrayList<String>(5);
        stringColl.add("soefam_filpermannolimit");
        stringColl.add("soefam_filpermannofil");
        stringColl.add("soefam_filpermanlarfil");
        stringColl.add("soefam_filpermanpenterfil");
        stringColl.add("soefam_filpermanlarterfil");
        if ("soefam_filperlist".equals(entityId)) {
            queType = "2";
            entityNum = "soefam_filperlist";
        } else if ("soefam_filingperpenter".equals(entityId)) {
            queType = "2";
            entityNum = "soefam_filingperpenter";
        } else if (stringColl.contains(entityId)) {
            queType = "2";
            entityNum = "soefam_filpermanage";
        } else {
            queType = "2";
            entityNum = "soefam_certificate";
        }
        return MANAGE_ORG_APPLICATION_SERVICE.getManageOrgInfo(queType, entityNum);
    }
}

