/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.onbusabroadapply;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sihc.soefam.business.application.service.faapply.FaapplyApplicationService;
import kd.sihc.soefam.business.application.service.lock.LockApplicationService;
import kd.sihc.soefam.business.formservice.OnBusAbroadFormService;
import kd.sihc.soefam.business.formservice.faapplication.FAApplicationService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.faapply.FaApplyConstants;
import kd.sihc.soefam.common.enums.ForAffProcessStatusEnum;

public class OnBusAbroadPlugin
extends AbstractFormPlugin
implements CellClickListener,
TabSelectListener,
FaApplyConstants {
    private static final OnBusAbroadFormService ON_BUS_ABROAD_FORM_SERVICE = (OnBusAbroadFormService)ServiceFactory.getService(OnBusAbroadFormService.class);
    public static final String[] UN_CHANGED_PROPS = new String[]{"visperson_id", "visdepemp_id"};

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("famaterialentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"btn_sysin", "viewinstruction", "sysindel", "sysoutdel"});
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Tab audTab = (Tab)this.getControl("audtabap");
        audTab.addTabSelectListener((TabSelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BillShowParameter formShowParameter = (BillShowParameter)args.getFormShowParameter();
        if (formShowParameter.getPkId() != null) {
            Long pkId = Long.valueOf(formShowParameter.getPkId().toString());
            ON_BUS_ABROAD_FORM_SERVICE.setBillTitle(formShowParameter, pkId);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Container baseInfo = (Container)this.getControl("applicantinfo");
        baseInfo.setCollapse(!OperationStatus.ADDNEW.equals((Object)status));
        Object org = this.getView().getModel().getDataEntity().get("org");
        if (org != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"contentflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"placeholderflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"placeholderflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentflex"});
        }
        ON_BUS_ABROAD_FORM_SERVICE.setAccPerFlexVis(this.getView());
        FAApplicationService.setOnBusTabVisible((IFormView)this.getView());
        Object processStatus = this.getModel().getValue("processstatus");
        if (processStatus != null) {
            this.getView().setVisible(Boolean.valueOf(!ForAffProcessStatusEnum.STATUS_TERM.getKey().equals(processStatus.toString())), new String[]{"bar_submit"});
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            FAApplicationService.faMaterialAssignment((IFormView)this.getView(), (String)"0");
        }
        FAApplicationService.faMaterialDownload((IFormView)this.getView());
        EntryGrid fAMaterialEntity = (EntryGrid)this.getView().getControl("famaterialentity");
        Optional.ofNullable(fAMaterialEntity).ifPresent(entryGrid -> entryGrid.setColumnProperty("famaterialtpl", "isFixed", (Object)Boolean.TRUE));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"visitcounum", "visitdays"});
        this.setVisitCouNum();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("intabpage".equals(tabKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"sysindel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sysoutdel"});
        } else if ("outtabpage".equals(tabKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"sysoutdel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sysindel"});
        } else if ("approvaltab".equals(tabKey)) {
            this.getView().updateView("approvaltab");
        } else if ("insighttab".equals(tabKey)) {
            OnBusAbroadFormService onBusAbroadFormService = new OnBusAbroadFormService();
            FormShowParameter formShowParameter = onBusAbroadFormService.buildOnBusLayout("insighttab", Long.valueOf(Long.parseLong(this.getModel().getValue("id").toString())));
            this.getView().showForm(formShowParameter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String itemKey = source.getKey();
        if ("btn_sysin".equals(itemKey)) {
            Tab tabAp = (Tab)this.getView().getControl("tabap");
            if (null != tabAp) {
                tabAp.activeTab("intabpage");
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            ListShowParameter employeeShowParam = ON_BUS_ABROAD_FORM_SERVICE.getEmployeeShowParam(dataEntity, new CloseCallBack((IFormPlugin)this, "close_addper"));
            this.getView().showForm((FormShowParameter)employeeShowParam);
        } else if ("viewinstruction".equals(itemKey)) {
            FAApplicationService.clickHandle((EventObject)evt, (IFormView)this.getView());
        } else if ("sysindel".equals(itemKey)) {
            this.showConfirmPrompt("vispersonentity", "sysindel");
        } else if ("sysoutdel".equals(itemKey)) {
            this.showConfirmPrompt("outentryentity", "sysoutdel");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "close_addper": {
                ListSelectedRowCollection selectedRows;
                List demIds;
                if (returnData == null || (demIds = (selectedRows = (ListSelectedRowCollection)returnData).stream().map(selectRow -> (Long)selectRow.getPrimaryKeyValue()).collect(Collectors.toList())).size() == 0) break;
                FaapplyApplicationService faapplyApplicationService = new FaapplyApplicationService();
                DynamicObject dataEntity = this.getView().getModel().getDataEntity();
                String message = faapplyApplicationService.isExistOnBusAbrApplicant(demIds, dataEntity.getString("applyformtype"), Long.valueOf(dataEntity.getLong("id")));
                if (message != null) {
                    this.getView().showErrorNotification(message);
                }
                ON_BUS_ABROAD_FORM_SERVICE.setInSysPersonEntity(demIds, this.getView());
                ON_BUS_ABROAD_FORM_SERVICE.setAccPerFlexVis(this.getView());
                this.getView().updateView("tabap");
                this.setVisitCouNum();
                break;
            }
            case "terProcess": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String entityId = this.getView().getEntityId();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.setVisitCouNum();
        } else if ("unsubmit".equals(operateKey) || "donothing_termination".equals(operateKey)) {
            this.setMutex(args, entityId);
        }
    }

    private void setVisitCouNum() {
        DynamicObjectCollection inDynObjColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("vispersonentity");
        DynamicObjectCollection outDynObjColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("outentryentity");
        int num = 0;
        for (DynamicObject dynamicObject : outDynObjColl) {
            if (dynamicObject.get("outname") == null || "".equals(dynamicObject.get("outname"))) continue;
            ++num;
        }
        this.getView().getModel().setValue("visitcounum", (Object)(inDynObjColl.size() + num));
    }

    private void setMutex(BeforeDoOperationEventArgs args, String entityId) {
        DynamicObject[] mutexDys = "soefam_onbusabroad".equals(entityId) ? LockApplicationService.checkHasMutex((String)"soefam_onbusabroad_self", Collections.singletonList(this.getModel().getDataEntity().getPkValue()), (String)"modify") : LockApplicationService.checkHasMutex((String)"soefam_onbusabroad", Collections.singletonList(this.getModel().getDataEntity().getPkValue()), (String)"modify");
        this.mutexMessage(args, mutexDys);
    }

    public void mutexMessage(BeforeDoOperationEventArgs args, DynamicObject[] mutexDys) {
        if (mutexDys != null && mutexDys.length != 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"OnBusAbroadListPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[]{mutexDys[0].getString("user.name")}));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        switch (operateKey) {
            case "indeleteentry": {
                ON_BUS_ABROAD_FORM_SERVICE.setAccPerFlexVis(this.getView());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OnBusAbroadPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                this.setVisitCouNum();
                break;
            }
            case "newentry": {
                ON_BUS_ABROAD_FORM_SERVICE.setAccPerFlexVis(this.getView());
                this.setSysOutTab();
                this.setVisitCouNum();
                break;
            }
            case "outdeleteentry": {
                ON_BUS_ABROAD_FORM_SERVICE.setAccPerFlexVis(this.getView());
                this.setSysOutTab();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OnBusAbroadPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                this.setVisitCouNum();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("sysindel".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("indeleteentry");
        } else if ("sysoutdel".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("outdeleteentry");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        evt.setSkipNoField(true);
        DynamicObjectCollection dataEntityColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("vispersonentity");
        for (DynamicObject dataEntity : dataEntityColl) {
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            for (String unChangedProp : UN_CHANGED_PROPS) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)unChangedProp);
                if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
        }
        DynamicObjectCollection dataFaColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("famaterialentity");
        for (DynamicObject dataFaEntity : dataFaColl) {
            DataEntityState dataEntityState = dataFaEntity.getDataEntityState();
            DataEntityPropertyCollection properties = dataFaEntity.getDataEntityType().getProperties();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"famaterialtpl_id");
            if (HRObjectUtils.isEmpty((Object)iDataEntityProperty)) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        this.getModel().updateCache();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        FAApplicationService.downFAMaterial((CellClickEvent)cellClickEvent, (IFormView)this.getView());
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void showConfirmPrompt(String entityId, String closeSign) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entityId);
        int[] selectRows = entryGrid.getSelectRows();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(closeSign, (IFormPlugin)this);
        if (selectRows.length == 1) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\uff1f", (String)"OnBusAbroadPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        } else if (selectRows.length > 1) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5220\u9664\uff1f", (String)"OnBusAbroadPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[]{selectRows.length}), MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OnBusAbroadPlugin_4", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
        }
    }

    private void setSysOutTab() {
        Tab tab = (Tab)this.getControl("tabap");
        if (null != tab) {
            tab.activeTab("outtabpage");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"planleavedate", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"planbackdate", (CharSequence)fieldKey)) {
            Object planLeaveDate = this.getView().getModel().getValue("planleavedate");
            Object planBackDate = this.getView().getModel().getValue("planbackdate");
            if (planLeaveDate != null && planBackDate != null) {
                long leaveDate = ((Date)planLeaveDate).getTime();
                long backDate = ((Date)planBackDate).getTime();
                long planNum = backDate - leaveDate;
                if ((planNum = planNum / 24L / 60L / 60L / 1000L + 1L) < 0L) {
                    planNum = 0L;
                }
                this.getView().getModel().setValue("visitdays", (Object)planNum);
            }
        }
    }
}

