/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.onbusabroadapply;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sihc.soebs.common.constants.rpc.HRCSRpcConstants;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.formservice.OnBusAbroadFormService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.formplugin.web.manageorg.ManageOrgFilterListPlugin;

public class OnBusAbroadSelfPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(ManageOrgFilterListPlugin.class);
    private static final String HR_SUCCESS = "success";
    private static final String HR_DATA = "data";
    private static final String HR_ADMIN_ORG_ID = "adminorg_id";
    private static final String HR_DEP_EMP_ID = "depemp_id";
    private static final String CACHE_CURRENT_USER_DMP_ID = "CACHE_CURRENT_USER_DMP_ID:";
    private static final OnBusAbroadFormService ON_BUS_ABROAD_FORM_SERVICE = (OnBusAbroadFormService)ServiceFactory.getService(OnBusAbroadFormService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"sysindel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Long depEmpId = this.initOrg();
            Optional.ofNullable(depEmpId).ifPresent(id -> ON_BUS_ABROAD_FORM_SERVICE.setInSysPersonEntity(Collections.singletonList(id), this.getView()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOrg();
    }

    private Long initOrg() {
        Map personModel = HrmpExternalService.getPersonModelId();
        boolean isSuccess = (Boolean)personModel.get(HR_SUCCESS);
        if (!isSuccess) {
            return null;
        }
        Map data = (Map)personModel.get(HR_DATA);
        Long personId = (Long)data.get("person");
        Map primaryEmpPosOrgRel = HrmpExternalService.getPrimaryEmpposorgrel((Long)personId);
        LOG.info("OnBusAbroadSelfPlugin.initOrg primaryEmpPosOrgRel : {} ; empId : {}", (Object)primaryEmpPosOrgRel, primaryEmpPosOrgRel.get(HR_DEP_EMP_ID));
        if (primaryEmpPosOrgRel.get(HR_ADMIN_ORG_ID) == null) {
            this.getPageCache().put(CACHE_CURRENT_USER_DMP_ID + RequestContext.get().getCurrUserId(), primaryEmpPosOrgRel.get(HR_DEP_EMP_ID) == null ? "" : primaryEmpPosOrgRel.get(HR_DEP_EMP_ID).toString());
            return 0L;
        }
        HashMap<Long, Set<Long>> paramMap = new HashMap<Long, Set<Long>>(16);
        LOG.info("OnBusAbroadSelf.initOrg.personId:{}", (Object)personId);
        LOG.info("OnBusAbroadSelf.initOrg.primaryEmpPosOrgRel:{}", (Object)primaryEmpPosOrgRel);
        LOG.info("OnBusAbroadSelf.initOrg.primaryEmpPosOrgRel.ORG_ID:{}", primaryEmpPosOrgRel.get(HR_ADMIN_ORG_ID));
        paramMap.put((Long)primaryEmpPosOrgRel.get(HR_ADMIN_ORG_ID), Collections.singleton(HRCSRpcConstants.BIZ_TYPE));
        List resultList = HrmpExternalService.getHrBuByBusinessType(paramMap, (Long)HRCSRpcConstants.BIZ_OBJ_TYPE);
        for (Map result : resultList) {
            Long hrBuId = (Long)result.get("hrBuId");
            this.getView().getModel().setValue("org", (Object)hrBuId);
        }
        Object empId = primaryEmpPosOrgRel.get(HR_DEP_EMP_ID);
        this.getPageCache().put(CACHE_CURRENT_USER_DMP_ID + RequestContext.get().getCurrUserId(), empId.toString());
        return (Long)empId;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        String currentDmpId = this.getPageCache().get(CACHE_CURRENT_USER_DMP_ID + RequestContext.get().getCurrUserId());
        if ("sysindel".equals(clickKey)) {
            this.doSysInDel(evt, currentDmpId);
        }
    }

    private void doSysInDel(BeforeClickEvent evt, Object currentDmpId) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("vispersonentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        for (int selectRow : selectRows) {
            long empId = dataEntitys[selectRow].getLong("visdepemp.id");
            if (!Long.toString(empId).equals(currentDmpId)) continue;
            String userName = dataEntitys[selectRow].getString("visperson.name");
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u662f\u5355\u636e\u521b\u5efa\u4eba\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"OnBusAbroadSelfPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[]{userName}));
            evt.setCancel(true);
        }
    }
}

