/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.previewbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.sihc.soefam.business.application.external.PrintTemplateExternalService;
import kd.sihc.soefam.business.application.service.filingsperson.FilPerScopeApplicationService;
import kd.sihc.soefam.business.formservice.print.PrintPageDataService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OnBusAbroadPrintPlugin
extends AbstractPrintPlugin {
    private static final Log LOG = LogFactory.getLog(OnBusAbroadPrintPlugin.class);
    private static final PrintPageDataService PRINT_PAGE_DATA_SERVICE = (PrintPageDataService)ServiceFactory.getService(PrintPageDataService.class);
    private Long applyId = 0L;

    public void afterLoadData(AfterLoadDataEvent evt) {
        super.afterLoadData(evt);
        String dsName = evt.getDataSource().getDsName();
        if (!"soefam_onbusabroad".equals(dsName) && !"soefam_onbusabroad_self".equals(dsName)) {
            return;
        }
        List dataRowSets = evt.getDataRowSets();
        if (ObjectUtils.isEmpty((Object)dataRowSets)) {
            return;
        }
        ArrayList<String> perIdList = new ArrayList<String>(16);
        Field field = ((DataRowSet)dataRowSets.get(0)).getField("id");
        if (StringUtils.isNotEmpty((CharSequence)field.toString())) {
            this.applyId = Long.parseLong(field.toString());
        }
        for (DataRowSet dataRows : dataRowSets) {
            CollectionField collectionField = dataRows.getCollectionField("vispersonentity");
            for (DataRowSet colDataRows : collectionField.getValue()) {
                Field firstField = colDataRows.getField("visperson.id");
                perIdList.add(firstField.getValue().toString());
            }
        }
        Map employeeInfo = PrintTemplateExternalService.getContactInfoMap(perIdList);
        Map perContact = PrintTemplateExternalService.getTargetResult((Map)employeeInfo, (String)"hrpi_percre");
        this.setPersonEntityInfo(dataRowSets, perContact);
    }

    private void setPersonEntityInfo(List<DataRowSet> dataRowSets, Map<Long, List<Map<String, Object>>> perContact) {
        for (DataRowSet dataRows : dataRowSets) {
            CollectionField collectionField = dataRows.getCollectionField("vispersonentity");
            List personIds = collectionField.getValue().stream().map(colData -> Long.parseLong(colData.getField("visperson.id").getValue().toString())).collect(Collectors.toList());
            DynamicObject[] perInfoDynObj = FilPerScopeApplicationService.listPersonInfoDys(personIds);
            HashMap<Long, DynamicObject> personBaseInfoMap = new HashMap<Long, DynamicObject>(perInfoDynObj.length);
            for (DynamicObject dynObj : perInfoDynObj) {
                personBaseInfoMap.put(dynObj.getLong("person.id"), dynObj);
            }
            for (DataRowSet colDataRows : collectionField.getValue()) {
                TextField numberField = new TextField();
                TextField genderField = new TextField();
                Field firstField = colDataRows.getField("visperson.id");
                List<Map<String, Object>> perCreList = perContact.get(Long.parseLong(firstField.getValue().toString()));
                if (perCreList == null) {
                    numberField.setValue("");
                    genderField.setValue("");
                    colDataRows.put("idnoshow", (Field)numberField);
                    colDataRows.put("isinhead", (Field)genderField);
                    continue;
                }
                DynamicObject personBaseInfo = (DynamicObject)personBaseInfoMap.get(Long.parseLong(firstField.getValue().toString()));
                Object number = this.getNumberValue(perCreList);
                String gender = personBaseInfo.getDynamicObject("gender") != null ? personBaseInfo.getDynamicObject("gender").getString("name") : null;
                numberField.setValue(number != "" ? number.toString() : "");
                genderField.setValue(gender != null ? gender.toString() : "");
                colDataRows.put("idnoshow", (Field)numberField);
                colDataRows.put("isinhead", (Field)genderField);
            }
            CollectionField outPerEntity = dataRows.getCollectionField("outentryentity");
            ArrayList<DataRowSet> outRowSets = new ArrayList<DataRowSet>(outPerEntity.size());
            for (DataRowSet outDataRows : outPerEntity.getValue()) {
                DataRowSet newDataRows = new DataRowSet();
                Field name = outDataRows.getField("outname");
                Field company = outDataRows.getField("organization");
                Field position = outDataRows.getField("outposition");
                newDataRows.put("visperson.name", name);
                newDataRows.put("affcompany.name", company);
                newDataRows.put("inposition.name", position);
                newDataRows.put("idnoshow", (Field)new TextField());
                outRowSets.add(newDataRows);
            }
            collectionField.getValue().addAll(outRowSets);
        }
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        DataRowSet dataRowSet;
        super.loadCustomData(evt);
        String dsName = evt.getDataSource().getDsName();
        if ("headperson".equals(dsName)) {
            FaApplyQueryService faApplyQueryService = new FaApplyQueryService();
            DynamicObject faBill = faApplyQueryService.getFaBillById(this.applyId);
            DynamicObjectCollection entryObjs = faBill.getDynamicObjectCollection("vispersonentity");
            DynamicObjectCollection outEntryObjs = faBill.getDynamicObjectCollection("outentryentity");
            String name = "";
            for (DynamicObject col : entryObjs) {
                String isInHead = col.get("isinhead") != null ? col.get("isinhead").toString() : "";
                if (!isInHead.equals("1")) continue;
                name = col.getDynamicObject("visperson").getString("name");
            }
            for (DynamicObject outCol : outEntryObjs) {
                String isOutHead = outCol.get("isouthead") != null ? outCol.get("isouthead").toString() : "";
                if (!isOutHead.equals("1")) continue;
                name = outCol.getString("outname");
            }
            DataRowSet dataRowSet2 = new DataRowSet();
            TextField textField = new TextField();
            textField.setValue(name);
            dataRowSet2.put("pername", (Field)textField);
            if (ObjectUtils.isNotEmpty((Object)dataRowSet2)) {
                evt.getCustomDataRows().add(dataRowSet2);
            }
        }
        if ("personaudit".equals(dsName) && ObjectUtils.isNotEmpty((Object)(dataRowSet = PRINT_PAGE_DATA_SERVICE.getDataRowSet(this.applyId)))) {
            evt.getCustomDataRows().add(dataRowSet);
        }
    }

    private Object getNumberValue(List<Map<String, Object>> perCreList) {
        Object number = "";
        for (Map<String, Object> perCre : perCreList) {
            Boolean flag = perCre.get("ismajor") != null ? (Boolean)perCre.get("ismajor") : Boolean.FALSE;
            if (!flag.booleanValue()) continue;
            number = perCre.get("number");
        }
        return number;
    }
}

