/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.remind;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soebs.business.application.service.tempmanage.ITempManageParser;
import kd.sihc.soebs.business.domain.message.ReminderMessageService;
import kd.sihc.soebs.business.domain.tempmanage.impl.EmailMessageImpl;
import kd.sihc.soebs.business.domain.tempmanage.impl.OtherMessageImpl;
import kd.sihc.soebs.business.form.SoeAbstractFormPlugin;
import kd.sihc.soebs.business.form.events.BeforeCheckAuthorEventArgs;
import kd.sihc.soebs.business.form.events.PreAfterDoOperationEventArgs;
import kd.sihc.soebs.business.formservice.MsgTemplateFormService;
import kd.sihc.soebs.business.queryservice.MsgTemplateQueryService;
import kd.sihc.soebs.business.queryservice.TempManageQueryService;
import kd.sihc.soebs.common.constants.MsgTemplateConstants;
import kd.sihc.soebs.common.constants.dto.message.MessageContentDO;
import kd.sihc.soefam.business.application.external.hrmp.HrmpExternalService;
import kd.sihc.soefam.business.domain.messagerecord.MessageRecordDomainService;
import kd.sihc.soefam.business.formservice.MesReminderFormService;
import kd.sihc.soefam.business.formservice.SelectPersonFormService;
import kd.sihc.soefam.business.queryservice.CertificateQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.certificate.CertOperateKeyConstants;
import kd.sihc.soefam.common.constants.certificate.MesReminderConstants;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;
import kd.sihc.soefam.common.enums.CertStockStatusEnum;
import kd.sihc.soefam.common.enums.MesReminderNameEnum;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MesReminderPlugin
extends SoeAbstractFormPlugin
implements BeforeF7SelectListener,
MesReminderConstants,
MsgTemplateConstants,
CertOperateKeyConstants {
    private static final Log LOG = LogFactory.getLog(MesReminderPlugin.class);
    private static final MesReminderFormService MES_REMINDER_FORM_SERVICE = (MesReminderFormService)ServiceFactory.getService(MesReminderFormService.class);
    private static final SelectPersonFormService SELECT_PERSON_FORM_SERVICE = (SelectPersonFormService)ServiceFactory.getService(SelectPersonFormService.class);
    private static final CertificateQueryService CERTIFICATE_QUERY_SERVICE = (CertificateQueryService)ServiceFactory.getService(CertificateQueryService.class);
    private static final TempManageQueryService TEMP_MANAGE_QUERY_SERVICE = (TempManageQueryService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(TempManageQueryService.class);
    private static final MsgTemplateQueryService MSG_TEMPLATE_QUERY_SERVICE = (MsgTemplateQueryService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(MsgTemplateQueryService.class);
    private final MessageRecordDomainService MSG_RECORD_DOMAIN_SERVICE = (MessageRecordDomainService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(MessageRecordDomainService.class);
    private Map<String, String> LABEL_VARIABLE_MAP = Maps.newHashMap();

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"previewlbl", "vectorap"});
        BasedataEdit msgTem = (BasedataEdit)this.getControl("msgtemplate");
        msgTem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        String opType = (String)formShowParameter.getCustomParam("parameteroptype");
        formShowParameter.setCaption(MesReminderNameEnum.valueByKey((String)opType).getDesc());
    }

    public void beforeBindData(EventObject eventObject) {
        String opType = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype");
        Object custom = this.getView().getFormShowParameter().getCustomParam("id");
        List<Long> certIds = new ArrayList(16);
        if (custom instanceof List) {
            certIds = (List)this.getView().getFormShowParameter().getCustomParam("id");
        } else {
            Object customParam = this.getView().getFormShowParameter().getCustomParam("id");
            certIds.add(Long.parseLong(customParam.toString()));
        }
        FormShowParameter formShowParameter = MES_REMINDER_FORM_SERVICE.getFormShowParameter(this.getView(), opType, "soefam_selectperson", "selectperflex", null, certIds);
        this.getView().showForm(formShowParameter);
        this.setDefTemplate(opType);
        this.setMesModule();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        String opType = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype");
        if (HRStringUtils.equals((String)"msgtemplate", (String)fieldKey)) {
            QFilter qFilter;
            List<Long> userOrgFilter = this.getUserOrgFilter();
            List<Object> tempIds = new ArrayList(16);
            if (userOrgFilter != null) {
                qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"soebs_msgtemplate", userOrgFilter, (boolean)true);
                Long useId = (Long)MesReminderFormService.STATUS_NUMBER_MAPPING.get(opType);
                DynamicObject[] result = MSG_TEMPLATE_QUERY_SERVICE.queryMsgTemplate(qFilter, useId);
                tempIds = Arrays.stream(result).map(res -> res.getLong("id")).collect(Collectors.toList());
            }
            qFilter = new QFilter("id", "in", tempIds);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("sihc_precheck".equals(operateKey)) {
            RichTextEditor emailRichText = this.checkRichTextEditor();
            if (emailRichText == null) {
                args.setCancel(true);
                return;
            }
            if (this.checkManRecord()) {
                args.setCancel(true);
                return;
            }
            boolean emailBool = this.getView().getModel().getDataEntity().getBoolean("email");
            boolean smsBool = this.getView().getModel().getDataEntity().getBoolean("sms");
            boolean sysBool = this.getView().getModel().getDataEntity().getBoolean("sys");
            if (!(emailBool || smsBool || sysBool)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"MesReminderPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            RichTextEditor email = (RichTextEditor)this.getView().getControl("emailtemplate");
            String sms = this.getView().getModel().getDataEntity().getString("smstemplate");
            String sys = this.getView().getModel().getDataEntity().getString("systemplate");
            boolean flag = false;
            int num = 0;
            if (emailBool && (email == null || HRStringUtils.isEmpty((String)email.getText()))) {
                flag = true;
                ++num;
            }
            if (smsBool && StringUtils.isEmpty((CharSequence)sms)) {
                flag = true;
                ++num;
            }
            if (sysBool && StringUtils.isEmpty((CharSequence)sys)) {
                flag = true;
                ++num;
            }
            if (flag) {
                String message = num > 1 ? String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6b63\u6587\uff08%s\uff09\u201d\u3002", (String)"MesReminderPlugin_7", (String)"sihc-soefam-formplugin", (Object[])new Object[0]), num) : ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6b63\u6587\u201d\u3002", (String)"MesReminderPlugin_2", (String)"sihc-soefam-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("send".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            OtherMessageImpl otherMessageParser;
            String opType;
            List<Long> certIds = this.getCertIdList();
            DynamicObject[] certDynObj = this.getDynamicObjects(certIds, opType = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype"));
            if (certDynObj == null || certDynObj.length == 0) {
                if (this.getView().getParentView() != null) {
                    this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u4eba\u5904\u7406\u3002", (String)"MesReminderPlugin_8", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            Map certMap = SELECT_PERSON_FORM_SERVICE.getPerInfoMap(certDynObj);
            Long loginPersonId = this.getLoginPersonId();
            Map<Long, List<Map<String, Object>>> perContact = this.getPerContactInfoMap(certDynObj, loginPersonId);
            Set<Long> personIdSet = MapUtils.isNotEmpty(perContact) ? perContact.keySet() : null;
            Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdSet);
            RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailtemplate");
            String emailTemplate = emailRichText.getText();
            String smsTemplate = this.getModel().getDataEntity().getString("smstemplate");
            String sysTemplate = this.getModel().getDataEntity().getString("systemplate");
            boolean email = this.getView().getModel().getDataEntity().getBoolean("email");
            boolean sms = this.getView().getModel().getDataEntity().getBoolean("sms");
            boolean sys = this.getView().getModel().getDataEntity().getBoolean("sys");
            ArrayList<MessageContentDO> messageContentDOList = new ArrayList<MessageContentDO>(10);
            if (email) {
                EmailMessageImpl emailMessageParser = new EmailMessageImpl();
                this.setSendMessageListInfo((ITempManageParser)emailMessageParser, certMap, null, loginPersonId, perContact, messageContentDOList, emailTemplate, MessageChannels.EMAIL);
            }
            if (sms) {
                otherMessageParser = new OtherMessageImpl();
                this.setSendMessageListInfo((ITempManageParser)otherMessageParser, certMap, null, loginPersonId, perContact, messageContentDOList, smsTemplate, MessageChannels.SMS);
            }
            if (sys) {
                otherMessageParser = new OtherMessageImpl();
                this.setSendMessageListInfo((ITempManageParser)otherMessageParser, certMap, perSysIdMap, loginPersonId, perContact, messageContentDOList, sysTemplate, MessageChannels.MC);
            }
            String pushScene = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype");
            List msgRecordDTOList = this.MSG_RECORD_DOMAIN_SERVICE.getMsgRecordDTOS(messageContentDOList, pushScene);
            this.MSG_RECORD_DOMAIN_SERVICE.saveMessageByMsgIds(msgRecordDTOList);
            List msgRecordDTOs = ReminderMessageService.batchSendMessage(messageContentDOList);
            this.MSG_RECORD_DOMAIN_SERVICE.updateIntoStorage(msgRecordDTOs);
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MesReminderPlugin_9", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private DynamicObject[] getDynamicObjects(List<Long> certIds, String opType) {
        DynamicObject[] certDynObj = null;
        ArrayList<String> manStatus = new ArrayList<String>(8);
        ArrayList<String> stockStatus = new ArrayList<String>(8);
        if ("instoreremin".equals(opType)) {
            stockStatus.add(CertStockStatusEnum.STATUS_NOTIN.getKey());
            certDynObj = CERTIFICATE_QUERY_SERVICE.queryCertificateById("id,filperson,concerttype", certIds, manStatus, stockStatus, null);
        } else if ("recremain".equals(opType)) {
            stockStatus.add(CertStockStatusEnum.STATUS_IN.getKey());
            stockStatus.add(CertStockStatusEnum.STATUS_TOOUT.getKey());
            manStatus.add(CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
            certDynObj = CERTIFICATE_QUERY_SERVICE.queryCertificateById("id,filperson,concerttype", certIds, manStatus, stockStatus, null);
        } else if ("returnremain".equals(opType)) {
            stockStatus.add(CertStockStatusEnum.STATUS_IN.getKey());
            stockStatus.add(CertStockStatusEnum.STATUS_TOOUT.getKey());
            manStatus.add(CertManageStatusEnum.STATUS_TORETURN.getKey());
            certDynObj = CERTIFICATE_QUERY_SERVICE.queryCertificateById("id,filperson,concerttype", certIds, manStatus, stockStatus, null);
        } else if ("repremain".equals(opType)) {
            stockStatus.add(CertStockStatusEnum.STATUS_IN.getKey());
            stockStatus.add(CertStockStatusEnum.STATUS_TOOUT.getKey());
            certDynObj = CERTIFICATE_QUERY_SERVICE.queryCertificateById("id,filperson,concerttype", certIds, manStatus, stockStatus, "0");
        } else if ("outremain".equals(opType)) {
            stockStatus.add(CertStockStatusEnum.STATUS_TOOUT.getKey());
            manStatus.add(CertManageStatusEnum.STATUS_SAVE.getKey());
            manStatus.add(CertManageStatusEnum.STATUS_TOLENTOUT.getKey());
            certDynObj = CERTIFICATE_QUERY_SERVICE.queryCertificateById("id,filperson,concerttype", certIds, manStatus, stockStatus, null);
        }
        return certDynObj;
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String name;
        super.propertyChanged(propertyChangedArgs);
        switch (name = propertyChangedArgs.getProperty().getName()) {
            case "msgtemplate": {
                this.setMesModule();
                break;
            }
            case "email": {
                boolean email = this.getView().getModel().getDataEntity().getBoolean("email");
                FieldEdit control = (FieldEdit)this.getView().getControl("emailtheme");
                if (email) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"ematabpage"});
                    control.setMustInput(true);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"ematabpage"});
                control.setMustInput(false);
                break;
            }
            case "sms": {
                boolean sms = this.getView().getModel().getDataEntity().getBoolean("sms");
                if (sms) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"smstabpage"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"smstabpage"});
                break;
            }
            case "sys": {
                boolean sys = this.getView().getModel().getDataEntity().getBoolean("sys");
                if (sys) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"systabpage"});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"systabpage"});
                break;
            }
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        MsgTemplateFormService.setSlidePreviewForm((IFormView)this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        DynamicObject msgTempDynObj = this.getView().getModel().getDataEntity().getDynamicObject("msgtemplate");
        Long useSceneId = msgTempDynObj != null ? msgTempDynObj.getDynamicObject("usescene").getLong("id") : 0L;
        if ("previewlbl".equals(control.getKey()) || "vectorap".equals(control.getKey())) {
            List<Long> certIds = this.getCertIdList();
            DynamicObject[] certDynObj = CERTIFICATE_QUERY_SERVICE.queryOrderNumById("id,filperson,concerttype", certIds, null);
            if (certDynObj == null || certDynObj.length == 0) {
                return;
            }
            RichTextEditor emailRichText = this.checkRichTextEditor();
            if (emailRichText == null) {
                return;
            }
            this.executePreOperation(certDynObj, emailRichText);
            MsgTemplateFormService.showSlidePreviewForm((IFormView)this.getView());
        } else if (control.getKey().startsWith("labelemail_")) {
            String[] splitString = control.getKey().split("_");
            DynamicObject[] dynamicObjects = TEMP_MANAGE_QUERY_SERVICE.queryVariablesNameByField(splitString[1], useSceneId);
            this.setRichTextClickLabel(dynamicObjects[0].getString("name"));
        } else if (control.getKey().startsWith("labelsms_")) {
            String[] splitString = control.getKey().split("_");
            DynamicObject[] dynamicObjects = TEMP_MANAGE_QUERY_SERVICE.queryVariablesNameByField(splitString[1], useSceneId);
            this.setMultiTextClickLabel(dynamicObjects[0].getString("name"), "smstemplate");
        } else if (control.getKey().startsWith("labelsys_")) {
            String[] splitString = control.getKey().split("_");
            DynamicObject[] dynamicObjects = TEMP_MANAGE_QUERY_SERVICE.queryVariablesNameByField(splitString[1], useSceneId);
            this.setMultiTextClickLabel(dynamicObjects[0].getString("name"), "systemplate");
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (key.startsWith("label")) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            args.setControl((Control)vector);
        }
    }

    public void beforeCheckAuthor(BeforeCheckAuthorEventArgs eventArgs) {
        super.beforeCheckAuthor(eventArgs);
        String opType = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype");
        if ("sihc_precheck".equals(eventArgs.getOption().getOperateKey())) {
            if ("instoreremin".equals(opType)) {
                eventArgs.setOperationKey("instoreremin");
            } else if ("recremain".equals(opType)) {
                eventArgs.setOperationKey("recremain");
            } else if ("returnremain".equals(opType)) {
                eventArgs.setOperationKey("returnremain");
            } else if ("repremain".equals(opType)) {
                eventArgs.setOperationKey("repremain");
            } else if ("outremain".equals(opType)) {
                eventArgs.setOperationKey("outremain");
            }
            eventArgs.setEntityNumber("soefam_certificate");
            List<Long> certificateIdList = this.getCertIdList();
            if (certificateIdList != null && certificateIdList.size() > 0) {
                eventArgs.setIds(certificateIdList.toArray());
            }
        }
    }

    public void preAfterDoOperation(PreAfterDoOperationEventArgs preAfterDoOperationEventArgs) {
        super.preAfterDoOperation(preAfterDoOperationEventArgs);
        preAfterDoOperationEventArgs.setOperationKey("send");
        preAfterDoOperationEventArgs.setShowPartFailReason(false);
    }

    public void doRemoveFailRow(OperationResult operationResult, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.doRemoveFailRow(operationResult, afterDoOperationEventArgs);
        if ("sihc_precheck".equals(afterDoOperationEventArgs.getOperateKey())) {
            List<Long> certId = operationResult.getSuccessPkIds().stream().map(id -> id != null ? Long.parseLong(id.toString()) : 0L).collect(Collectors.toList());
            this.setCertIdList(certId);
        }
    }

    private void setDefTemplate(String opType) {
        List<Long> userOrgFilter = this.getUserOrgFilter();
        if (userOrgFilter != null) {
            Long useId;
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"soebs_msgtemplate", userOrgFilter, (boolean)true);
            DynamicObject[] result = MSG_TEMPLATE_QUERY_SERVICE.queryMsgTemplate(qFilter, useId = (Long)MesReminderFormService.STATUS_NUMBER_MAPPING.get(opType));
            Long tempId = result.length > 0 ? result[0].getLong("id") : 0L;
            this.getView().getModel().setValue("msgtemplate", (Object)tempId);
        }
    }

    private List<Long> getUserOrgFilter() {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (!Objects.isNull(result)) {
            return result.getHasPermOrgs();
        }
        return null;
    }

    private void setMesModule() {
        DynamicObject msgTem = this.getView().getModel().getDataEntity().getDynamicObject("msgtemplate");
        if (msgTem != null && msgTem.get("sendchannel") != null) {
            this.getView().getModel().setValue("emailtheme", (Object)msgTem.getString("emailtheme"));
            String emailText = MSG_TEMPLATE_QUERY_SERVICE.queryMsgTemplateStyle(Long.valueOf(msgTem.getLong("id")));
            RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailtemplate");
            emailRichText.setText(emailText);
            this.getView().getModel().setValue("smstemplate", (Object)msgTem.getString("smstemplate"));
            this.getView().getModel().setValue("systemplate", (Object)msgTem.getString("systemplate"));
            DynamicObject useSceneDyn = msgTem.getDynamicObject("usescene");
            MsgTemplateFormService.updateMsgTempVariablesLabel((IFormView)this.getView(), (DynamicObject)useSceneDyn);
            String value = msgTem.getString("sendchannel");
            List<String> sList = Arrays.asList(value.substring(0, value.length() - 1).split(","));
            this.getView().setVisible(Boolean.FALSE, new String[]{"ematabpage", "smstabpage", "systabpage"});
            this.getView().getModel().setValue("email", (Object)Boolean.FALSE);
            this.getView().getModel().setValue("sms", (Object)Boolean.FALSE);
            this.getView().getModel().setValue("sys", (Object)Boolean.FALSE);
            if (sList.contains("0")) {
                this.getView().getModel().setValue("email", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"ematabpage"});
                FieldEdit control = (FieldEdit)this.getView().getControl("emailtheme");
                control.setMustInput(true);
            }
            if (sList.contains("1")) {
                this.getView().getModel().setValue("sms", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"smstabpage"});
            }
            if (sList.contains("2")) {
                this.getView().getModel().setValue("sys", (Object)Boolean.TRUE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"systabpage"});
            }
        } else {
            MES_REMINDER_FORM_SERVICE.cleanMessageInfo(this.getView());
        }
    }

    private void setRichTextClickLabel(String variateName) {
        String variableValue = "{" + variateName + "}";
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("emailtemplate", "insertText", new Object[]{variableValue});
    }

    private void setMultiTextClickLabel(String variateName, String multiTextEdit) {
        String variableValue = "{" + variateName + "}";
        String value = (String)this.getModel().getValue(multiTextEdit);
        this.getModel().setValue(multiTextEdit, (Object)(value + variableValue));
    }

    private RichTextEditor checkRichTextEditor() {
        RichTextEditor emailRichText = (RichTextEditor)this.getView().getControl("emailtemplate");
        if (ObjectUtils.isNotEmpty((Object)emailRichText.getText()) && emailRichText.getText().length() > 10000) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90ae\u4ef6\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc710000\u4e2a\u5b57\u7b26\u3002", (String)"MesReminderPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            return null;
        }
        return emailRichText;
    }

    private boolean checkManRecord() {
        Object emlTheme = this.getView().getModel().getDataEntity().get("emailtheme");
        Object smsTemplate = this.getView().getModel().getDataEntity().get("smstemplate");
        Object sysTemplate = this.getView().getModel().getDataEntity().get("systemplate");
        if (emlTheme != null && emlTheme.toString().length() > 30) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90ae\u4ef6\u4e3b\u9898\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26\u3002", (String)"MesReminderPlugin_4", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (smsTemplate != null && smsTemplate.toString().length() > 450) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u77ed\u4fe1\u6a21\u677f\u5185\u5bb9\u9650\u5236\u5728450\u4e2a\u5b57\u7b26\u5185\u3002", (String)"MesReminderPlugin_5", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (sysTemplate != null && sysTemplate.toString().length() > 2000) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc72000\u4e2a\u5b57\u7b26\u3002", (String)"MesReminderPlugin_6", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setSendMessageListInfo(ITempManageParser messageParser, Map<Long, List<DynamicObject>> certMap, Map<Long, Long> perSysIdMap, Long loginPersonId, Map<Long, List<Map<String, Object>>> perContact, List<MessageContentDO> messageContentDOList, String template, MessageChannels mesChannel) {
        for (Map.Entry<Long, List<DynamicObject>> entry : certMap.entrySet()) {
            List<DynamicObject> certDynObjInfo = entry.getValue();
            Object perName = entry.getValue().get(0).get("filperson.person.name");
            Map<String, Object> customParams = this.getPreviewNeedMap(loginPersonId, perContact, perName, certDynObjInfo);
            this.LABEL_VARIABLE_MAP = this.constructLabelVariablesMap(this.getModel().getDataEntity().getLong("msgtemplate.usescene.id"));
            String content = messageParser.parseMessage(template, customParams, this.LABEL_VARIABLE_MAP, null);
            Object phone = perContact.get(entry.getValue().get(0).getLong("filperson.person.id")) != null ? perContact.get(entry.getValue().get(0).getLong("filperson.person.id")).get(0).get("phone") : null;
            Object busEmail = perContact.get(entry.getValue().get(0).getLong("filperson.person.id")) != null ? perContact.get(entry.getValue().get(0).getLong("filperson.person.id")).get(0).get("busemail") : null;
            Long sysId = perSysIdMap != null ? perSysIdMap.get(entry.getValue().get(0).getLong("filperson.person.id")) : Long.valueOf(0L);
            String opType = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype");
            String systemTitle = ResManager.loadKDString((String)"%1$s\u7684%2$s", (String)"MesReminderPlugin_3", (String)"sihc-soefam-formplugin", (Object[])new Object[]{perName, MesReminderNameEnum.valueByKey((String)opType).getDesc()});
            List certId = certDynObjInfo.stream().map(certDyn -> certDyn.getLong("id")).collect(Collectors.toList());
            MessageContentDO messageContentDO = new MessageContentDO();
            messageContentDO.setBoType("soefam_certificate");
            messageContentDO.setBusObjId(certId);
            messageContentDO.setMessageChannel(mesChannel);
            messageContentDO.setEmailTitle(this.getView().getModel().getDataEntity().getString("emailtheme"));
            messageContentDO.setMessageContent(content);
            messageContentDO.setReceiverEmail(busEmail != null ? busEmail.toString() : null);
            messageContentDO.setReceiverPhone(phone != null ? phone.toString() : null);
            messageContentDO.setSystemId(sysId);
            messageContentDO.setSystemTitle(systemTitle);
            DynamicObject msgTem = this.getView().getModel().getDataEntity().getDynamicObject("msgtemplate");
            customParams.put("templatenumber", msgTem.getString("number"));
            messageContentDO.setCustomParams(customParams);
            messageContentDOList.add(messageContentDO);
        }
    }

    private Map<String, Object> getPreviewNeedMap(Long loginPersonId, Map<Long, List<Map<String, Object>>> perContact, Object perName, List<DynamicObject> certDynObjInfo) {
        StringBuilder certName = new StringBuilder();
        int num = 0;
        for (DynamicObject dynOnj : certDynObjInfo) {
            certName.append(dynOnj.get("concerttype.name") != null ? dynOnj.get("concerttype.name").toString() : "");
            if (num < certDynObjInfo.size() - 1) {
                certName.append('\u3001');
            }
            ++num;
        }
        Object sendPerName = UserServiceHelper.getUserInfoByID((long)UserServiceHelper.getCurrentUserId()).get("name");
        Object sendPerEmail = perContact.get(loginPersonId) != null ? perContact.get(loginPersonId).get(0).get("busemail") : null;
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("replaceVar", "1");
        customParams.put("emailtheme", this.getModel().getDataEntity().getString("emailtheme"));
        customParams.put("pername", perName);
        customParams.put("certname", certName);
        customParams.put("sendpername", sendPerName);
        customParams.put("workemail", sendPerEmail);
        return customParams;
    }

    private Map<String, String> constructLabelVariablesMap(Long useSceneId) {
        DynamicObject[] tempVariables = TEMP_MANAGE_QUERY_SERVICE.getTempVariables(useSceneId);
        HashMap<String, String> map = new HashMap<String, String>(tempVariables.length);
        for (DynamicObject tempVariable : tempVariables) {
            map.put(tempVariable.getString("fieldname"), tempVariable.getString("name"));
        }
        return map;
    }

    private List<Long> getCertIdList() {
        IFormView view = this.getView().getView(this.getView().getPageId() + RequestContext.get().getCurrUserId());
        String certIdListStr = view.getPageCache().get("filperid");
        if (certIdListStr == null) {
            return null;
        }
        return SerializationUtils.fromJsonStringToList((String)certIdListStr, Long.class);
    }

    private void setCertIdList(List<Long> certIds) {
        IFormView view = this.getView().getView(this.getView().getPageId() + RequestContext.get().getCurrUserId());
        view.getPageCache().put("filperid", SerializationUtils.toJsonString(certIds));
    }

    private void executePreOperation(DynamicObject[] certDynObj, RichTextEditor emailRichText) {
        boolean sys;
        boolean sms;
        Map certMap = SELECT_PERSON_FORM_SERVICE.getPerInfoMap(certDynObj);
        Long loginPersonId = this.getLoginPersonId();
        Map<Long, List<Map<String, Object>>> perContact = this.getPerContactInfoMap(certDynObj, loginPersonId);
        Long filPerId = certDynObj[0].getDynamicObject("filperson").getLong("id");
        List certDynObjInfo = (List)certMap.get(filPerId);
        Object perName = certDynObj[0].get("filperson.person.name");
        Map<String, Object> customParams = this.getPreviewNeedMap(loginPersonId, perContact, perName, certDynObjInfo);
        this.LABEL_VARIABLE_MAP = this.constructLabelVariablesMap(this.getModel().getDataEntity().getLong("msgtemplate.usescene.id"));
        IAppCache iAppCache = AppCache.get((String)"cache_soebs_msgtemplate");
        String emailTemplate = emailRichText.getText();
        String smsTemplate = this.getModel().getDataEntity().getString("smstemplate");
        String sysTemplate = this.getModel().getDataEntity().getString("systemplate");
        customParams.put("emailtheme", this.getModel().getDataEntity().getString("emailtheme"));
        customParams.put("replaceVar", "1");
        EmailMessageImpl emailMessageParser = new EmailMessageImpl();
        OtherMessageImpl otherMessageParser = new OtherMessageImpl();
        String emailContent = emailMessageParser.parseMessage(emailTemplate, customParams, this.LABEL_VARIABLE_MAP, null);
        String smsContent = otherMessageParser.parseMessage(smsTemplate, customParams, this.LABEL_VARIABLE_MAP, null);
        String sysContent = otherMessageParser.parseMessage(sysTemplate, customParams, this.LABEL_VARIABLE_MAP, null);
        iAppCache.put("emailtemplate", (Object)emailContent);
        iAppCache.put("smstemplate", (Object)smsContent);
        iAppCache.put("systemplate", (Object)sysContent);
        StringBuilder builder = new StringBuilder();
        boolean email = this.getView().getModel().getDataEntity().getBoolean("email");
        if (email) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ematabpage"});
            builder.append('0');
            builder.append(',');
        }
        if (sms = this.getView().getModel().getDataEntity().getBoolean("sms")) {
            builder.append('1');
            builder.append(',');
        }
        if (sys = this.getView().getModel().getDataEntity().getBoolean("sys")) {
            builder.append('2');
            builder.append(',');
        }
        iAppCache.put("msgtemplate", (Object)builder);
        String currentTab = ((Tab)this.getView().getControl("tabap")).getCurrentTab();
        iAppCache.put("pagenumber", (Object)currentTab);
    }

    private Map<Long, List<Map<String, Object>>> getPerContactInfoMap(DynamicObject[] certDynObj, Long loginPersonId) {
        List perIdList = Arrays.stream(certDynObj).map(certDyn -> certDyn.get("filperson.person.id") != null ? certDyn.getString("filperson.person.id") : null).collect(Collectors.toList());
        perIdList.add(String.valueOf(loginPersonId));
        perIdList.remove("null");
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"003"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", perIdList);
        Map employeeInfo = HrmpExternalService.queryEmployeeInfo(param);
        Map<Long, List<Map<String, Object>>> perContact = this.getTargetResult(employeeInfo, "hrpi_percontact");
        return perContact;
    }

    private Map<Long, Long> getPerSysIdMap(Set<Long> personIdSet) {
        if (personIdSet != null) {
            HashMap<Long, Long> perSysMap = new HashMap<Long, Long>(personIdSet.size());
            ArrayList<Long> pIds = new ArrayList<Long>(personIdSet);
            HashMap<String, ArrayList<Long>> idMaps = new HashMap<String, ArrayList<Long>>(16);
            idMaps.put("person", pIds);
            Map userMap = HrmpExternalService.getUserIdByPersonInfo(idMaps);
            Map userInfoMap = (Map)userMap.get("data");
            for (Long pId : pIds) {
                Map personInfoMap;
                if (userInfoMap == null || (personInfoMap = (Map)userInfoMap.get(pId)) == null) continue;
                Long userId = (Long)personInfoMap.get("user");
                perSysMap.put(pId, userId);
            }
            return perSysMap;
        }
        return null;
    }

    public Long getLoginPersonId() {
        Map personModel = HrmpExternalService.getPersonModelId();
        boolean isSuccess = (Boolean)personModel.get("success");
        if (isSuccess) {
            Map data = (Map)personModel.get("data");
            Long personId = (Long)data.get("person");
            return personId;
        }
        return null;
    }

    public Map<Long, List<Map<String, Object>>> getTargetResult(Map<String, Map<String, Object>> result, String targetName) {
        if (CollectionUtils.isEmpty(result)) {
            return Maps.newHashMap();
        }
        HashMap targetResultMap = Maps.newHashMap();
        result.forEach((personIdStr, map) -> {
            if (null == map) {
                return;
            }
            Long personId = Long.parseLong(personIdStr);
            Object target = map.get(targetName);
            if (null == target) {
                return;
            }
            List targetMapList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(target), ArrayList.class);
            targetResultMap.put(personId, targetMapList);
        });
        return targetResultMap;
    }
}

