/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.remind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.sihc.soebs.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.business.domain.messagerecord.MessageRecordDomainService;
import kd.sihc.soefam.common.constants.MsgRecordConstant;
import kd.sihc.soefam.common.constants.certificate.MesReminderConstants;

public class MesReminderRecordPlugin
extends AbstractFormPlugin
implements MesReminderConstants,
RowClickEventListener,
MsgRecordConstant {
    private final MessageRecordDomainService MESSAGERECORDDOMAINSERVICE = (MessageRecordDomainService)ServiceFactory.getService(MessageRecordDomainService.class);
    public static final String SLIDE_MOTION = "afterShowSlideBill";
    private static final String PARAM_MSG_BATCH_ID = "msgBatchId";
    private static final String PARAM_BIZ_OBJ = "bizObj";

    public void customEvent(CustomEventArgs args) {
        if (SLIDE_MOTION.equals(args.getKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"cardentryflexpanelap1"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        IAppCache iAppCache = AppCache.get((String)"cache_soefam_pkidlist");
        Long pkId = (Long)iAppCache.get("fid", Long.class);
        DynamicObject[] dynamicObjects = this.MESSAGERECORDDOMAINSERVICE.getDynamicObjects(pkId);
        List<Object> dynamicObjectList = Arrays.asList(dynamicObjects);
        dynamicObjectList = dynamicObjectList.stream().sorted(Comparator.comparing(obj -> obj.getString("sendtime")).reversed()).collect(Collectors.toList());
        LinkedHashMap<Long, List<DynamicObject>> orgDynamicObject = new LinkedHashMap<Long, List<DynamicObject>>(0);
        for (DynamicObject dynamicObject : dynamicObjectList) {
            orgDynamicObject.put(Long.valueOf(dynamicObject.get("msgbatchid").toString()), dynamicObjectList);
        }
        this.initEntity(orgDynamicObject);
        if (!orgDynamicObject.isEmpty()) {
            Object bizObj = ((DynamicObject)dynamicObjectList.get(0)).get("bizobj");
            Object object = ((DynamicObject)dynamicObjectList.get(0)).get("msgbatchid");
            this.showFormMethod(bizObj, object);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        CardEntry entryGrid = (CardEntry)this.getView().getControl("entryentity");
        int size = this.getModel().getEntryEntity("entryentity").size();
        int focusRow = entryGrid.getEntryState().getFocusRow();
        Object bizObj = this.getModel().getValue("bizobj", focusRow);
        Object msgBatchId = this.getModel().getValue("msgbatchid", focusRow);
        this.showFormMethod(bizObj, msgBatchId);
        for (int index = 0; index < size; ++index) {
            entryGrid.setChildVisible(Boolean.FALSE.booleanValue(), index, new String[]{"cardentryflexpanelapout"});
            entryGrid.setChildVisible(Boolean.TRUE.booleanValue(), index, new String[]{"cardentryflexpanelap5"});
        }
        entryGrid.setChildVisible(Boolean.FALSE.booleanValue(), focusRow, new String[]{"cardentryflexpanelap5"});
        entryGrid.setChildVisible(Boolean.TRUE.booleanValue(), focusRow, new String[]{"cardentryflexpanelapout"});
    }

    private void initEntity(Map<Long, List<DynamicObject>> orgDynamicObject) {
        if (!orgDynamicObject.isEmpty()) {
            this.getView().getModel().deleteEntryData("entryentity");
            this.getView().getModel().batchCreateNewEntryRow("entryentity", orgDynamicObject.size());
            Set<Map.Entry<Long, List<DynamicObject>>> entries = orgDynamicObject.entrySet();
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            int num = 0;
            for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
                List<DynamicObject> dynamicObjectListOld = orgDynamicObject.get(entry.getKey());
                ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(0);
                for (DynamicObject dynamicObject : dynamicObjectListOld) {
                    if (!dynamicObject.get("msgbatchid").toString().equals(String.valueOf(entry.getKey()))) continue;
                    dynamicObjectList.add(dynamicObject);
                }
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    if (dynamicObject.get("sendchannel").toString().equals("0")) {
                        this.getView().getModel().setValue("emailstatus", dynamicObject.get("sendstatus"), num);
                        this.getView().getModel().setValue("emailstatussl", dynamicObject.get("sendstatus"), num);
                        continue;
                    }
                    if (dynamicObject.get("sendchannel").toString().equals("1")) {
                        this.getView().getModel().setValue("smsstatus", dynamicObject.get("sendstatus"), num);
                        this.getView().getModel().setValue("smsstatussl", dynamicObject.get("sendstatus"), num);
                        continue;
                    }
                    if (!dynamicObject.get("sendchannel").toString().equals("2")) continue;
                    this.getView().getModel().setValue("sysstatus", dynamicObject.get("sendstatus"), num);
                    this.getView().getModel().setValue("sysstatussl", dynamicObject.get("sendstatus"), num);
                }
                String sender = ((DynamicObject)dynamicObjectList.get(0)).getDynamicObject("sender").getString("name");
                Date sendTimeDae = ((DynamicObject)dynamicObjectList.get(0)).getDate("sendtime");
                String sendTime = HRInteDateTimeUtil.formatDate((String)"soefam_reminderrecord", (String)"sendtime", (Date)sendTimeDae);
                this.getView().getModel().setValue("sendername", (Object)sender, num);
                this.getView().getModel().setValue("sendernamesl", (Object)sender, num);
                this.getView().getModel().setValue("dateandtime", (Object)sendTime, num);
                this.getView().getModel().setValue("remindrecord", ((DynamicObject)dynamicObjectList.get(0)).get("pushscene"), num);
                this.getView().getModel().setValue("bizobj", ((DynamicObject)dynamicObjectList.get(0)).get("bizobj"), num);
                this.getView().getModel().setValue("msgbatchid", ((DynamicObject)dynamicObjectList.get(0)).get("msgbatchid"), num);
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), num, new String[]{"cardentryflexpanelapout"});
                ++num;
            }
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{"cardentryflexpanelap5"});
            cardEntry.setChildVisible(Boolean.TRUE.booleanValue(), 0, new String[]{"cardentryflexpanelapout"});
        }
    }

    private FormShowParameter showFormMethod(Object bizObj, Object msgBatchId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u901a\u77e5\u8bb0\u5f55", (String)"MesReminderRecordPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("soefam_msgrecordpreview");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam(PARAM_MSG_BATCH_ID, msgBatchId);
        showParameter.setCustomParam(PARAM_BIZ_OBJ, bizObj);
        showParameter.getOpenStyle().setTargetKey("flexpanelap3");
        this.getView().showForm(showParameter);
        return showParameter;
    }
}

