/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.formplugin.web.remind.record;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Html;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sihc.soefam.common.constants.MsgRecordConstant;

public class MsgRecordPreviewPlugin
extends AbstractFormPlugin
implements MsgRecordConstant {
    private static final String PARAM_MSG_BATCH_ID = "msgBatchId";
    private static final String PARAM_BIZ_OBJ = "bizObj";
    private static final String HTML_AP = "htmlap";
    private static final String SYS_CONTROL = "syscontrol";
    private static final String SMS_CONTROL = "smscontrol";

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object msgBatchId = customParams.get(PARAM_MSG_BATCH_ID);
        Object bizObj = customParams.get(PARAM_BIZ_OBJ);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("soefam_reminderrecord");
        QFilter qFilter = new QFilter("msgbatchid", "=", msgBatchId);
        qFilter.and(new QFilter("bizobj", "=", bizObj));
        DynamicObject[] dynamicObjs = hrBaseServiceHelper.query("msgcontent_tag,sendchannel,sendstatus", qFilter.toArray());
        Optional.ofNullable(dynamicObjs).ifPresent(dynamicObjects -> this.updateTemplateContent(dynamicObjs));
    }

    private void updateTemplateContent(DynamicObject[] recordObjs) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"ematabpage", "smstabpage", "systabpage", "imagemail", "imagmsg", "imagsys", "sysfail", "msgfail", "emailfail"});
        if (recordObjs.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
            return;
        }
        for (DynamicObject dynamicObj : recordObjs) {
            this.setMsgContent(dynamicObj);
        }
    }

    private void setMsgContent(DynamicObject recordObj) {
        switch (recordObj.getString("sendchannel")) {
            case "0": {
                this.setEmailContent(recordObj);
                break;
            }
            case "1": {
                this.setSmsContent(recordObj);
                break;
            }
            case "2": {
                this.setSysContent(recordObj);
                break;
            }
        }
    }

    private void setSysContent(DynamicObject recordObj) {
        String sysTemplate = recordObj.getString("msgcontent_tag");
        this.getView().setVisible(Boolean.TRUE, new String[]{"systabpage"});
        this.updateCustomControlContent(SYS_CONTROL, sysTemplate);
        if (recordObj.get("sendstatus").equals("0")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"imagsys"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"sysfail"});
            this.getView().setVisible(Boolean.FALSE, new String[]{SYS_CONTROL});
        }
    }

    private void setSmsContent(DynamicObject recordObj) {
        String smsTemplate = recordObj.getString("msgcontent_tag");
        this.getView().setVisible(Boolean.TRUE, new String[]{"smstabpage"});
        this.updateCustomControlContent(SMS_CONTROL, smsTemplate);
        if (recordObj.get("sendstatus").equals("0")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"imagmsg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"msgfail"});
            this.getView().setVisible(Boolean.FALSE, new String[]{SMS_CONTROL});
        }
    }

    private void setEmailContent(DynamicObject recordObj) {
        String emailTemplate = recordObj.getString("msgcontent_tag");
        this.getView().setVisible(Boolean.TRUE, new String[]{"ematabpage"});
        Html html = (Html)this.getView().getControl(HTML_AP);
        html.setConent(emailTemplate);
        if (recordObj.get("sendstatus").equals("0")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"imagemail"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"emailfail"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{HTML_AP});
        }
    }

    private void updateCustomControlContent(String customControlName, String content) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(customControlName);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("text", content);
        customcontrol.setData(data);
    }
}

