/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.validator.certificate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;
import kd.sihc.soefam.business.domain.certificate.helper.CertlentoutregHelper;
import kd.sihc.soefam.common.enums.CertManageStatusEnum;

public class CertOverRegValidator
extends HRDataBaseValidator {
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();
    private static final CertlentoutregHelper CERTLENTOUTREGHELPER = CertlentoutregHelper.init();

    public void validate() {
        DynamicObjectCollection entryEntity;
        super.validate();
        boolean isEntryEntityData = false;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List idList = Arrays.stream(dataEntities).filter(dy -> dy.getDataEntity().containsProperty("id")).map(dynamicObject -> dynamicObject.getDataEntity().getLong("id")).collect(Collectors.toList());
        if (idList.size() == 0 && dataEntities.length == 1 && dataEntities[0].getDataEntity().containsProperty("entryentity") && (idList = (entryEntity = dataEntities[0].getDataEntity().getDynamicObjectCollection("entryentity")).stream().filter(dy -> dy.containsProperty("certificateentity")).map(dy -> dy.getDynamicObject("certificateentity").getLong("id")).collect(Collectors.toList())).size() > 0) {
            isEntryEntityData = true;
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] certificates = CERTIFICATEMGDOMAINSERVICE.query("managestatus", idFilter.toArray());
        Map<Long, DynamicObject> certificateMap = Arrays.stream(certificates).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), Function.identity(), (v1, v2) -> v1));
        QFilter qFilter = new QFilter("certificate", "in", idList);
        QFilter stateQFilter = new QFilter("registerstate", "=", (Object)"0");
        stateQFilter.and(qFilter);
        DynamicObject[] query = CERTLENTOUTREGHELPER.query("id,certificate", stateQFilter.toArray());
        Map<Object, List<DynamicObject>> collect = Arrays.stream(query).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.get("certificate.id")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (isEntryEntityData) {
                dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").forEach(dy -> this.checkDataStatus(certificateMap, collect, dataEntity, dy.getDynamicObject("certificateentity")));
                continue;
            }
            DynamicObject dataEntityObj = dataEntity.getDataEntity();
            this.checkDataStatus(certificateMap, collect, dataEntity, dataEntityObj);
        }
    }

    private void checkDataStatus(Map<Long, DynamicObject> certificateMap, Map<Object, List<DynamicObject>> collect, ExtendedDataEntity dataEntity, DynamicObject dataEntityObj) {
        String manageStatus = certificateMap.get(dataEntityObj.getLong("id")).get("managestatus").toString();
        if (!manageStatus.equals(CertManageStatusEnum.STATUS_TOLENTOUT.getKey())) {
            if (manageStatus.equals(CertManageStatusEnum.STATUS_TORETURN.getKey())) {
                List<DynamicObject> dynamicObjects = collect.get(dataEntityObj.getLong("id"));
                if (null == dynamicObjects) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc1\u7167\u65e0\u5f85\u501f\u51fa\u4fe1\u606f\uff0c\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u4eba\u5904\u7406\u3002", (String)"CertRegLoanValidator_0", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
                } else {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc1\u7167\u6709\u672a\u5904\u7406\u7684\u5f85\u5f52\u8fd8\u8bb0\u5f55\uff0c\u8bf7\u5904\u7406\u540e\u518d\u8fdb\u884c\u7ec8\u6b62\u501f\u51fa\u3002", (String)"CertOverRegValidator_0", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc1\u7167\u65e0\u5f85\u501f\u51fa\u4fe1\u606f\uff0c\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u4eba\u5904\u7406\u3002", (String)"CertRegLoanValidator_0", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

