/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.validator.certificate;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.sihc.soefam.business.domain.certificate.CertificateMgDomainService;

public class CertificateRepRegValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(CertificateRepRegValidator.class);
    private static final CertificateMgDomainService CERTIFICATEMGDOMAINSERVICE = CertificateMgDomainService.init();

    public void validate() {
        DynamicObject[] certificateList;
        super.validate();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        LOG.info("CertificateRepRegValidator.validate calendar : {}", (Object)calendar.getTime());
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        DynamicObjectCollection dataEntities = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(dataEntities.size());
        for (int index = 0; index < dataEntities.size(); ++index) {
            idList.add(((DynamicObject)dataEntities.get(index)).getDynamicObject("certificateentity").getLong("id"));
            Date replaceDate = ((DynamicObject)dataEntities.get(index)).getDate("replacedate");
            if (replaceDate == null) continue;
            if (replaceDate.compareTo(calendar.getTime()) > 0) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8303\u56f4\u5185\u7684\u66f4\u6362\u65e5\u671f\u3002", (String)"CertificateRepRegValidator_0", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
            }
            if (((DynamicObject)dataEntities.get(index)).getDate("pervaldate") != null) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff1a\u201c\u6709\u6548\u671f\u81f3\u201d\u3002", (String)"CertificateRepRegValidator_2", (String)"sihc-soefam-opplugin", (Object[])new Object[]{index + 1}));
        }
        QFilter qFilter = new QFilter("id", "in", idList);
        for (DynamicObject dynamicObject : certificateList = CERTIFICATEMGDOMAINSERVICE.query("certinfo,stockstatus", qFilter.toArray())) {
            if ("A".equals(dynamicObject.getString("stockstatus")) || "D".equals(dynamicObject.getString("stockstatus"))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bc1\u7167\u72b6\u6001\u5fc5\u987b\u662f\u201c\u5df2\u5165\u5e93\u201d\u624d\u80fd\u8fdb\u884c\u66f4\u6362\u767b\u8bb0\u3002", (String)"CertificateRepRegValidator_3", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
            }
            if (!"C".equals(dynamicObject.getString("stockstatus"))) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f85\u66f4\u6362\u8bc1\u7167\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u4eba\u5904\u7406\u3002", (String)"CertificateRepRegValidator_4", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
        }
    }
}

