/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.validator.manageorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.sihc.soefam.business.domain.manageorg.ManageOrgValidatorService;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import org.apache.commons.lang3.time.StopWatch;

public class MgOrgRangeSaveValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(MgOrgRangeSaveValidator.class);
    public static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)MgOrgRangeSaveValidator.class.getName(), (int)16);

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        LOG.info("MgOrgRangeSaveValidator.stopWatch start");
        ManageOrgValidatorService manageOrgService = new ManageOrgValidatorService();
        Map manageOrgMap = Arrays.stream(manageOrgService.getManageOrg(null)).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (V1, V2) -> V1));
        String request_source = (String)this.getOption().getVariables().get("request_source");
        List selectDataIdList = Arrays.stream(this.getDataEntities()).map(extDy -> extDy.getDataEntity().getLong("id")).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String enableStr;
            DynamicObject mgOrgEntity = "list".equals(request_source) ? (DynamicObject)manageOrgMap.get(dataEntity.getDataEntity().getLong("id")) : dataEntity.getDataEntity();
            String string = enableStr = manageOrgMap.get(dataEntity.getDataEntity().getLong("id")) != null ? ((DynamicObject)manageOrgMap.get(dataEntity.getDataEntity().getLong("id"))).getString("enable") : mgOrgEntity.getString("enable");
            if ("save".equals(operateKey) && !"1".equals(enableStr)) continue;
            Map curMap = manageOrgService.generateJudgeObj(mgOrgEntity);
            String msgStr = manageOrgService.checkManageOrgPosition(curMap);
            if (StringUtils.isNotEmpty((String)msgStr)) {
                this.addErrorMessage(this.getDataEntities()[0], msgStr);
                continue;
            }
            List filterManageOrgList = manageOrgMap.values().stream().filter(dy -> dy.getString("controlclass").equals(mgOrgEntity.getString("controlclass"))).filter(dy -> dy.getLong("id") != mgOrgEntity.getLong("id")).filter(dy -> "1".equals(dy.getString("enable")) || selectDataIdList.contains(dy.getLong("id")) && dy.getString("controlclass").equals(mgOrgEntity.getString("controlclass"))).collect(Collectors.toList());
            List errorList = Collections.synchronizedList(new ArrayList(filterManageOrgList.size()));
            ArrayList futures = new ArrayList(filterManageOrgList.size());
            for (DynamicObject dynamicObject : filterManageOrgList) {
                futures.add(EXECUTOR_SERVICE.submit(() -> {
                    Map map = manageOrgService.generateJudgeObj(dynamicObject);
                    Map repeatMap = manageOrgService.judgeRepeat(curMap, map);
                    if (!repeatMap.isEmpty()) {
                        errorList.add(repeatMap);
                    }
                }));
            }
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (Exception exception) {
                LOG.error("MgOrgRangeSaveValidator.validate error", (Throwable)exception);
                this.addErrorMessage(dataEntity, "Run failed");
            }
            List errorMessage = manageOrgService.errorMessage(errorList);
            if (errorMessage.size() <= 0) continue;
            this.addErrorMessage(dataEntity, (String)errorMessage.get(0));
        }
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, MgOrgRangeSaveValidator.class, (String)"validate", null);
    }
}

