/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.validator.notgacapply;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.login.utils.DateUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.sihc.soebs.business.cadre.file.HspmIdentityServiceImpl;
import kd.sihc.soefam.business.application.external.inte.InternationService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class NotGACApplySaveAndSubmitValidator
extends HRDataBaseValidator {
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = (FaApplyQueryService)ServiceFactory.getService(FaApplyQueryService.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity extendedData : dataEntities = this.getDataEntities()) {
            DynamicObject sameApplicantBill;
            DynamicObject dataEntity = extendedData.getDataEntity();
            String auditStatus = dataEntity.getString("auditstatus");
            if ("A".equals(auditStatus) && (sameApplicantBill = FA_APPLY_QUERY_SERVICE.isExistSameApplicant(Long.valueOf(dataEntity.getLong("person.id")), dataEntity.getString("applyformtype"), Long.valueOf(dataEntity.getLong("id")))) != null) {
                String entityKey = this.getEntityKey();
                this.sameBillMessage(extendedData, dataEntity, sameApplicantBill, entityKey);
            }
            Date planLendDate = dataEntity.getDate("planlenddate");
            Date planReturnDate = dataEntity.getDate("planreturndate");
            if (planLendDate != null && planReturnDate != null) {
                this.dataMessage(extendedData, planLendDate, planReturnDate);
            }
            DynamicObjectCollection fAMaterialEntity = dataEntity.getDynamicObjectCollection("famaterialentity");
            List<DynamicObject> notUploadEntity = fAMaterialEntity.stream().filter(entry -> "1".equals(entry.getString("famaterialtpl.ismustupload"))).filter(entry -> entry.getDynamicObjectCollection("famaterialatt").size() == 0).collect(Collectors.toList());
            this.faMaterialMessage(extendedData, notUploadEntity);
            String idno = dataEntity.getString("idno");
            if (!StringUtils.isBlank((CharSequence)idno)) {
                this.validNumber(extendedData, idno);
            }
            if (!"1".equals(dataEntity.getString("businesstype"))) continue;
            DynamicObjectCollection visaEntity = dataEntity.getDynamicObjectCollection("visaprocessentity");
            this.checkVisaEntity(extendedData, visaEntity);
        }
    }

    private void checkVisaEntity(ExtendedDataEntity extendedData, DynamicObjectCollection visaEntity) {
        long num = visaEntity.stream().filter(dynamicObject -> dynamicObject.get("ischecked").equals(true)).count();
        if (num == 0L) {
            this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8bc1\u7167\u529e\u7406\u4e8b\u9879\u3002", (String)"NotGACApplySaveAndSubmitValidator_4", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
        }
    }

    public void validNumber(ExtendedDataEntity extendedData, String number) {
        Boolean isValid = new HspmIdentityServiceImpl().validIdentityCardNo(null, "CN01", number);
        if (isValid != null && !isValid.booleanValue()) {
            this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"NotGACApplySaveAndSubmitValidator_3", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
        }
    }

    public void faMaterialMessage(ExtendedDataEntity extendedData, List<DynamicObject> notUploadEntity) {
        if (notUploadEntity.size() == 1) {
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u4e0a\u4f20\u6750\u6599\u3002", (String)"NotGACApplySaveAndSubmitValidator_1", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
        } else if (notUploadEntity.size() > 1) {
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u4e0a\u4f20\u6750\u6599\u201c%s\u201d\u3002", (String)"NotGACApplySaveAndSubmitValidator_2", (String)"sihc-soefam-opplugin", (Object[])new Object[]{notUploadEntity.size()}));
        }
    }

    public void dataMessage(ExtendedDataEntity extendedData, Date planLendDate, Date planReturnDate) {
        String dateFormat = InternationService.getDateFormat();
        if (planLendDate.after(planReturnDate)) {
            String planLendDateStr = DateUtils.formatDate((Date)planLendDate, (Object[])new Object[]{dateFormat});
            String planReturnDateStr = DateUtils.formatDate((Date)planReturnDate, (Object[])new Object[]{dateFormat});
            OperateOption option = this.getOption();
            if (option == null) {
                return;
            }
            String modelType = option.getVariableValue("modeltypeforwf");
            if (modelType != null && modelType.contains("mobile")) {
                this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u8ba1\u5212\u501f\u51fa\u65e5\u671f\u5e94\u65e9\u4e8e\u8ba1\u5212\u5f52\u8fd8\u65e5\u671f\uff08%s\uff09\u3002", (String)"NotGACApplySaveAndSubmitValidator_5", (String)"sihc-soefam-opplugin", (Object[])new Object[]{planReturnDateStr}));
            } else {
                this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u8ba1\u5212\u501f\u51fa\u65e5\u671f\uff08%1$s\uff09\u5e94\u65e9\u4e8e\u8ba1\u5212\u5f52\u8fd8\u65e5\u671f\uff08%2$s\uff09\u3002", (String)"NotGACApplySaveAndSubmitValidator_0", (String)"sihc-soefam-opplugin", (Object[])new Object[]{planLendDateStr, planReturnDateStr}));
            }
        }
    }

    public void sameBillMessage(ExtendedDataEntity extendedData, DynamicObject dataEntity, DynamicObject sameApplicantBill, String entityKey) {
        if ("soefam_notgacapply".equals(entityKey)) {
            this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"%1$s\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u4e0d\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"NotGACApplyPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[]{dataEntity.getString("person.name"), sameApplicantBill.getString("billno")}));
        } else {
            this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u4e0d\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355\u201c%s\u201d\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"NotGACApplySelfListPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[]{sameApplicantBill.getString("billno")}));
        }
    }
}

